/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.XMLWriter;
import org.infoglue.cms.applications.contenttool.actions.ViewContentVersionAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionControllerProxy;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class UpdateContentVersionAction
extends ViewContentVersionAction {
    private static final long serialVersionUID = 1L;
    public static final Logger logger = Logger.getLogger((String)UpdateContentVersionAction.class.getName());
    private ContentVersionVO contentVersionVO;
    private Integer contentId;
    private Integer languageId;
    private Integer contentVersionId;
    private Integer currentEditorId;
    private String attributeName;
    private long oldModifiedDateTime = -1L;
    private boolean concurrentModification = false;
    private ConstraintExceptionBuffer ceb;

    public UpdateContentVersionAction() {
        this(new ContentVersionVO());
    }

    public UpdateContentVersionAction(ContentVersionVO contentVersionVO) {
        this.contentVersionVO = contentVersionVO;
        this.ceb = new ConstraintExceptionBuffer();
    }

    public String doExecute() throws Exception {
        super.initialize(this.contentVersionId, this.contentId, this.languageId);
        this.ceb.throwIfNotEmpty();
        ContentVersionVO currentContentVersionVO = null;
        if (this.contentVersionVO.getId() != null) {
            currentContentVersionVO = ContentVersionController.getContentVersionController().getContentVersionVOWithId(this.contentVersionVO.getId());
        }
        if (currentContentVersionVO != null) {
            logger.info((Object)("oldModifiedDateTime:" + this.oldModifiedDateTime));
            logger.info((Object)("modifiedDateTime2:" + currentContentVersionVO.getModifiedDateTime().getTime()));
        }
        if (currentContentVersionVO == null || this.oldModifiedDateTime == currentContentVersionVO.getModifiedDateTime().getTime()) {
            this.contentVersionVO.setVersionModifier(this.getInfoGluePrincipal().getName());
            try {
                this.contentVersionVO = ContentVersionControllerProxy.getController().acUpdate(this.getInfoGluePrincipal(), this.contentId, this.languageId, this.contentVersionVO);
                this.contentVersionVO = ContentVersionController.getContentVersionController().getContentVersionVOWithId(this.contentVersionVO.getId());
                this.oldModifiedDateTime = this.contentVersionVO.getModifiedDateTime().getTime();
            }
            catch (ConstraintException ce) {
                ((ViewContentVersionAction)this).contentVersionVO = this.contentVersionVO;
                throw ce;
            }
        } else {
            this.contentVersionVO.setVersionModifier(this.getInfoGluePrincipal().getName());
            ((ViewContentVersionAction)this).contentVersionVO = this.contentVersionVO;
            this.concurrentModification = true;
        }
        return "success";
    }

    public String doUpdateVersionValue() throws Exception {
        super.initialize(this.contentVersionId, this.contentId, this.languageId);
        this.ceb.throwIfNotEmpty();
        ContentVersionVO currentContentVersionVO = null;
        if (this.contentVersionVO.getId() != null) {
            currentContentVersionVO = ContentVersionController.getContentVersionController().getContentVersionVOWithId(this.contentVersionVO.getId());
        }
        if (currentContentVersionVO != null) {
            logger.info((Object)("oldModifiedDateTime:" + this.oldModifiedDateTime));
            logger.info((Object)("modifiedDateTime2:" + currentContentVersionVO.getModifiedDateTime().getTime()));
        }
        this.contentVersionVO.setVersionModifier(this.getInfoGluePrincipal().getName());
        try {
            this.contentVersionVO = ContentVersionControllerProxy.getController().acUpdate(this.getInfoGluePrincipal(), this.contentId, this.languageId, this.contentVersionVO);
            this.oldModifiedDateTime = this.contentVersionVO.getModifiedDateTime().getTime();
        }
        catch (ConstraintException ce) {
            ((ViewContentVersionAction)this).contentVersionVO = this.contentVersionVO;
            throw ce;
        }
        this.currentEditorId = new Integer(1);
        this.concurrentModification = false;
        return "success";
    }

    public String doStandalone() throws Exception {
        super.initialize(this.contentVersionId, this.contentId, this.languageId);
        this.ceb.throwIfNotEmpty();
        try {
            this.contentVersionVO.setVersionModifier(this.getInfoGluePrincipal().getName());
            this.contentVersionVO = ContentVersionControllerProxy.getController().acUpdate(this.getInfoGluePrincipal(), this.contentId, this.languageId, this.contentVersionVO);
            this.contentVersionVO = ContentVersionController.getContentVersionController().getContentVersionVOWithId(this.contentVersionVO.getId());
        }
        catch (ConstraintException ce) {
            ((ViewContentVersionAction)this).contentVersionVO = this.contentVersionVO;
            ce.setResult("inputStandalone");
            throw ce;
        }
        return "standalone";
    }

    public String doSaveAndExit() throws Exception {
        this.doExecute();
        return "saveAndExit";
    }

    public String doSaveAndExitStandalone() throws Exception {
        try {
            this.doExecute();
        }
        catch (ConstraintException ce) {
            ((ViewContentVersionAction)this).contentVersionVO = this.contentVersionVO;
            ce.setResult("inputStandalone");
            throw ce;
        }
        return "saveAndExitStandalone";
    }

    public String doBackground() throws Exception {
        this.doExecute();
        return "background";
    }

    public String doXml() throws IOException, SystemException, Bug, DocumentException {
        XMLWriter xmlWriter;
        String xmlResult;
        block9: {
            xmlResult = null;
            this.getResponse().setContentType("text/xml; charset=UTF-8");
            this.getResponse().setHeader("Cache-Control", "no-cache");
            this.getResponse().setHeader("Pragma", "no-cache");
            this.getResponse().setDateHeader("Expires", 0L);
            PrintWriter out = this.getResponse().getWriter();
            xmlWriter = new XMLWriter((Writer)out);
            XStream xStream = new XStream();
            xStream.omitField(this.contentVersionVO.getClass(), "versionValue");
            ContentVersionVO currentContentVersionVO = null;
            ContentVersionVO activeContentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(this.contentId, this.languageId);
            if (activeContentVersionVO.getContentVersionId().equals(this.contentVersionVO.getContentVersionId())) {
                if (this.contentVersionVO.getId() != null) {
                    currentContentVersionVO = ContentVersionController.getContentVersionController().getContentVersionVOWithId(this.contentVersionVO.getId());
                }
                if (currentContentVersionVO == null || this.oldModifiedDateTime == currentContentVersionVO.getModifiedDateTime().getTime()) {
                    this.contentVersionVO.setVersionModifier(this.getInfoGluePrincipal().getName());
                    try {
                        if (activeContentVersionVO.getStateId().equals(ContentVersionVO.WORKING_STATE)) {
                            this.contentVersionVO = ContentVersionControllerProxy.getController().acUpdate(this.getInfoGluePrincipal(), this.contentId, this.languageId, this.contentVersionVO);
                            this.contentVersionVO = ContentVersionController.getContentVersionController().getContentVersionVOWithId(this.contentVersionVO.getId());
                            this.oldModifiedDateTime = this.contentVersionVO.getModifiedDateTime().getTime();
                            xmlResult = xStream.toXML((Object)this.contentVersionVO);
                            break block9;
                        }
                        xmlResult = "<invalidstate/>";
                    }
                    catch (ConstraintException ce) {
                        xmlResult = xStream.toXML((Object)ce);
                    }
                    catch (Exception e) {
                        xmlResult = xStream.toXML((Object)e);
                    }
                } else {
                    this.contentVersionVO.setVersionModifier(this.getInfoGluePrincipal().getName());
                    ((ViewContentVersionAction)this).contentVersionVO = this.contentVersionVO;
                    this.concurrentModification = true;
                    xmlResult = "<concurrentmodification/>";
                }
            } else {
                xmlResult = "<invalidversion/>";
            }
        }
        xmlWriter.write(DocumentHelper.parseText((String)xmlResult));
        xmlWriter.flush();
        return null;
    }

    public void setContentVersionId(Integer contentVersionId) {
        this.contentVersionVO.setContentVersionId(contentVersionId);
    }

    public Integer getContentVersionId() {
        return this.contentVersionVO.getContentVersionId();
    }

    public void setStateId(Integer stateId) {
        this.contentVersionVO.setStateId(stateId);
    }

    public Integer getStateId() {
        return this.contentVersionVO.getStateId();
    }

    public void setContentId(Integer contentId) {
        this.contentId = contentId;
    }

    public Integer getContentId() {
        return this.contentId;
    }

    public void setLanguageId(Integer languageId) {
        this.languageId = languageId;
    }

    public Integer getLanguageId() {
        return this.languageId;
    }

    public String getVersionValue() {
        return this.contentVersionVO.getVersionValue();
    }

    public void setVersionValue(String versionValue) {
        this.contentVersionVO.setVersionValue(versionValue);
    }

    public Integer getCurrentEditorId() {
        return this.currentEditorId;
    }

    public void setCurrentEditorId(Integer integer) {
        this.currentEditorId = integer;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getVersionComment() {
        return this.contentVersionVO.getVersionComment();
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public long getOldModifiedDateTime() {
        return this.oldModifiedDateTime;
    }

    public void setOldModifiedDateTime(long oldModifiedDateTime) {
        this.oldModifiedDateTime = oldModifiedDateTime;
    }

    public boolean getConcurrentModification() {
        return this.concurrentModification;
    }
}

