/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import java.util.Collections;
import java.util.List;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.contenttool.actions.ViewContentAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.InfoGlueSettingsController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.sorters.ReflectionComparator;

public class UpdateContentAction
extends ViewContentAction {
    private static final long serialVersionUID = 1L;
    private ContentVO contentVO = null;
    private Integer repositoryId;
    private Integer contentTypeDefinitionId;
    private Integer newContentTypeDefinitionId;
    private ConstraintExceptionBuffer ceb;

    public UpdateContentAction() {
        this(new ContentVO());
    }

    public UpdateContentAction(ContentVO contentVO) {
        this.contentVO = contentVO;
        this.ceb = new ConstraintExceptionBuffer();
    }

    public String doInputContentType() throws Exception {
        super.initialize(this.getContentId());
        return "successInputContentType";
    }

    public String doChangeContentType() throws Exception {
        super.initialize(this.getContentId());
        ContentVO oldContentVO = ContentController.getContentController().getContentVOWithId(this.getContentId());
        this.ceb = oldContentVO.validate();
        this.ceb.throwIfNotEmpty();
        ContentControllerProxy.getController().acUpdate(this.getInfoGluePrincipal(), oldContentVO, this.newContentTypeDefinitionId);
        return "success";
    }

    public String doExecute() throws Exception {
        super.initialize(this.getContentId());
        ContentVO oldContentVO = ContentController.getContentController().getContentVOWithId(this.getContentId());
        this.contentVO.setCreatorName(this.getInfoGluePrincipal().getName());
        this.contentVO.setIsBranch(oldContentVO.getIsBranch());
        this.ceb = this.contentVO.validate();
        this.ceb.throwIfNotEmpty();
        ContentControllerProxy.getController().acUpdate(this.getInfoGluePrincipal(), this.contentVO, this.contentTypeDefinitionId);
        return "success";
    }

    public String doV3() throws Exception {
        super.initialize(this.getContentId());
        ContentVO oldContentVO = ContentController.getContentController().getContentVOWithId(this.getContentId());
        this.contentVO.setCreatorName(this.getInfoGluePrincipal().getName());
        this.contentVO.setIsBranch(oldContentVO.getIsBranch());
        this.ceb = this.contentVO.validate();
        this.ceb.throwIfNotEmpty();
        ContentControllerProxy.getController().acUpdate(this.getInfoGluePrincipal(), this.contentVO, this.contentTypeDefinitionId);
        return "successV3";
    }

    public String doStandalone() throws Exception {
        this.doExecute();
        return "successStandalone";
    }

    public String doSaveAndExit() throws Exception {
        this.doExecute();
        return "saveAndExit";
    }

    public List getContentTypeDefinitions() throws Exception {
        List contentTypeVOList = null;
        String protectContentTypes = CmsPropertyHandler.getProtectContentTypes();
        contentTypeVOList = protectContentTypes != null && protectContentTypes.equalsIgnoreCase("true") ? ContentTypeDefinitionController.getController().getAuthorizedContentTypeDefinitionVOList(this.getInfoGluePrincipal()) : ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList();
        Collections.sort(contentTypeVOList, new ReflectionComparator("name"));
        return contentTypeVOList;
    }

    public String getDefaultFolderContentTypeName() {
        return InfoGlueSettingsController.getInfoGlueSettingsController().getProperty("repository_" + this.getRepositoryId() + "_defaultFolderContentTypeName", "applicationProperties", null, false, false, false, false, null);
    }

    public void setContentId(Integer contentId) {
        this.contentVO.setContentId(contentId);
    }

    public Integer getContentId() {
        return this.contentVO.getContentId();
    }

    public String getName() {
        return this.contentVO.getName();
    }

    public Boolean getIsBranch() {
        return this.contentVO.getIsBranch();
    }

    public void setName(String name) {
        this.contentVO.setName(name);
    }

    public Integer getIsProtected() {
        return this.contentVO.getIsProtected();
    }

    public void setIsProtected(Integer isProtected) {
        this.contentVO.setIsProtected(isProtected);
    }

    public void setPublishDateTime(String publishDateTime) {
        this.contentVO.setPublishDateTime(new VisualFormatter().parseDate(publishDateTime, "yyyy-MM-dd HH:mm"));
    }

    public void setExpireDateTime(String expireDateTime) {
        this.contentVO.setExpireDateTime(new VisualFormatter().parseDate(expireDateTime, "yyyy-MM-dd HH:mm"));
    }

    public void setIsBranch(Boolean isBranch) {
        this.contentVO.setIsBranch(isBranch);
    }

    public void setContentTypeDefinitionId(Integer contentTypeDefinitionId) {
        this.contentTypeDefinitionId = contentTypeDefinitionId;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public Integer getNewContentTypeDefinitionId() {
        return this.newContentTypeDefinitionId;
    }

    public void setNewContentTypeDefinitionId(Integer newContentTypeDefinitionId) {
        this.newContentTypeDefinitionId = newContentTypeDefinitionId;
    }
}

