/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionControllerProxy;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.exception.AccessConstraintException;
import org.infoglue.cms.util.AccessConstraintExceptionBuffer;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class UpdateAccessRightsAction
extends InfoGlueAbstractAction {
    private static final long serialVersionUID = 1L;
    private Integer interceptionPointId;
    private Integer accessRightId;
    private String parameters = "";
    private String roleName;
    private String returnAddress;
    private String url;
    private String interceptionPointCategory;
    private ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();

    public String doExecute() throws Exception {
        AccessConstraintExceptionBuffer ceb = new AccessConstraintExceptionBuffer();
        if (this.interceptionPointCategory.equalsIgnoreCase("Content")) {
            Integer contentId = new Integer(this.parameters);
            ContentVO contentVO = ContentControllerProxy.getController().getContentVOWithId(contentId);
            if (!contentVO.getCreatorName().equalsIgnoreCase(this.getInfoGluePrincipal().getName())) {
                Integer protectedContentId = ContentControllerProxy.getController().getProtectedContentId(contentId);
                if (ContentControllerProxy.getController().getIsContentProtected(contentId) && !AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), "Content.ChangeAccessRights", protectedContentId.toString())) {
                    ceb.add(new AccessConstraintException("Content.contentId", "1006"));
                }
            }
        } else if (this.interceptionPointCategory.equalsIgnoreCase("SiteNodeVersion")) {
            Integer protectedSiteNodeVersionId;
            Integer siteNodeVersionId = new Integer(this.parameters);
            SiteNodeVersionVO siteNodeVersionVO = SiteNodeVersionController.getController().getSiteNodeVersionVOWithId(siteNodeVersionId);
            if (!siteNodeVersionVO.getVersionModifier().equalsIgnoreCase(this.getInfoGluePrincipal().getName()) && (protectedSiteNodeVersionId = SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().getProtectedSiteNodeVersionId(siteNodeVersionId)) != null && !AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), "SiteNodeVersion.ChangeAccessRights", siteNodeVersionId.toString())) {
                ceb.add(new AccessConstraintException("SiteNodeVersion.siteNodeId", "1006"));
            }
        }
        ceb.throwIfNotEmpty();
        AccessRightController.getController().update(this.parameters, this.getRequest());
        this.url = this.getResponse().encodeRedirectURL(this.returnAddress);
        if (this.returnAddress.indexOf("http") == 0) {
            this.getResponse().sendRedirect(this.url);
            return "none";
        }
        return "success";
    }

    public String doAddGroups() throws Exception {
        AccessConstraintExceptionBuffer ceb = new AccessConstraintExceptionBuffer();
        if (this.interceptionPointCategory.equalsIgnoreCase("Content")) {
            Integer contentId = new Integer(this.parameters);
            ContentVO contentVO = ContentControllerProxy.getController().getContentVOWithId(contentId);
            if (!contentVO.getCreatorName().equalsIgnoreCase(this.getInfoGluePrincipal().getName())) {
                Integer protectedContentId = ContentControllerProxy.getController().getProtectedContentId(contentId);
                if (ContentControllerProxy.getController().getIsContentProtected(contentId) && !AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), "Content.ChangeAccessRights", protectedContentId.toString())) {
                    ceb.add(new AccessConstraintException("Content.contentId", "1006"));
                }
            }
        } else if (this.interceptionPointCategory.equalsIgnoreCase("SiteNodeVersion")) {
            Integer protectedSiteNodeVersionId;
            Integer siteNodeVersionId = new Integer(this.parameters);
            SiteNodeVersionVO siteNodeVersionVO = SiteNodeVersionController.getController().getSiteNodeVersionVOWithId(siteNodeVersionId);
            if (!siteNodeVersionVO.getVersionModifier().equalsIgnoreCase(this.getInfoGluePrincipal().getName()) && (protectedSiteNodeVersionId = SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().getProtectedSiteNodeVersionId(siteNodeVersionId)) != null && !AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), "SiteNodeVersion.ChangeAccessRights", siteNodeVersionId.toString())) {
                ceb.add(new AccessConstraintException("SiteNodeVersion.siteNodeId", "1006"));
            }
        }
        ceb.throwIfNotEmpty();
        String[] groupNames = this.getRequest().getParameterValues("groupName");
        AccessRightController.getController().updateGroups(this.accessRightId, this.parameters, groupNames);
        this.url = this.getResponse().encodeRedirectURL(this.returnAddress);
        if (this.returnAddress.indexOf("http") == 0) {
            this.getResponse().sendRedirect(this.url);
            return "none";
        }
        return "success";
    }

    public String doAddUser() throws Exception {
        AccessConstraintExceptionBuffer ceb = new AccessConstraintExceptionBuffer();
        if (this.interceptionPointCategory.equalsIgnoreCase("Content")) {
            Integer contentId = new Integer(this.parameters);
            ContentVO contentVO = ContentControllerProxy.getController().getContentVOWithId(contentId);
            if (!contentVO.getCreatorName().equalsIgnoreCase(this.getInfoGluePrincipal().getName())) {
                Integer protectedContentId = ContentControllerProxy.getController().getProtectedContentId(contentId);
                if (ContentControllerProxy.getController().getIsContentProtected(contentId) && !AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), "Content.ChangeAccessRights", protectedContentId.toString())) {
                    ceb.add(new AccessConstraintException("Content.contentId", "1006"));
                }
            }
        } else if (this.interceptionPointCategory.equalsIgnoreCase("SiteNodeVersion")) {
            Integer protectedSiteNodeVersionId;
            Integer siteNodeVersionId = new Integer(this.parameters);
            SiteNodeVersionVO siteNodeVersionVO = SiteNodeVersionController.getController().getSiteNodeVersionVOWithId(siteNodeVersionId);
            if (!siteNodeVersionVO.getVersionModifier().equalsIgnoreCase(this.getInfoGluePrincipal().getName()) && (protectedSiteNodeVersionId = SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().getProtectedSiteNodeVersionId(siteNodeVersionId)) != null && !AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), "SiteNodeVersion.ChangeAccessRights", siteNodeVersionId.toString())) {
                ceb.add(new AccessConstraintException("SiteNodeVersion.siteNodeId", "1006"));
            }
        }
        ceb.throwIfNotEmpty();
        String userName = this.getRequest().getParameter("userName");
        AccessRightController.getController().addUser(this.interceptionPointCategory, this.parameters, userName, this.getRequest());
        this.url = this.getResponse().encodeRedirectURL(this.returnAddress);
        if (this.returnAddress.indexOf("http") == 0) {
            this.getResponse().sendRedirect(this.url);
            return "none";
        }
        return "success";
    }

    public String doDeleteUser() throws Exception {
        AccessConstraintExceptionBuffer ceb = new AccessConstraintExceptionBuffer();
        if (this.interceptionPointCategory.equalsIgnoreCase("Content")) {
            Integer contentId = new Integer(this.parameters);
            ContentVO contentVO = ContentControllerProxy.getController().getContentVOWithId(contentId);
            if (!contentVO.getCreatorName().equalsIgnoreCase(this.getInfoGluePrincipal().getName())) {
                Integer protectedContentId = ContentControllerProxy.getController().getProtectedContentId(contentId);
                if (ContentControllerProxy.getController().getIsContentProtected(contentId) && !AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), "Content.ChangeAccessRights", protectedContentId.toString())) {
                    ceb.add(new AccessConstraintException("Content.contentId", "1006"));
                }
            }
        } else if (this.interceptionPointCategory.equalsIgnoreCase("SiteNodeVersion")) {
            Integer protectedSiteNodeVersionId;
            Integer siteNodeVersionId = new Integer(this.parameters);
            SiteNodeVersionVO siteNodeVersionVO = SiteNodeVersionController.getController().getSiteNodeVersionVOWithId(siteNodeVersionId);
            if (!siteNodeVersionVO.getVersionModifier().equalsIgnoreCase(this.getInfoGluePrincipal().getName()) && (protectedSiteNodeVersionId = SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().getProtectedSiteNodeVersionId(siteNodeVersionId)) != null && !AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), "SiteNodeVersion.ChangeAccessRights", siteNodeVersionId.toString())) {
                ceb.add(new AccessConstraintException("SiteNodeVersion.siteNodeId", "1006"));
            }
        }
        ceb.throwIfNotEmpty();
        String userName = this.getRequest().getParameter("userName");
        AccessRightController.getController().deleteUser(this.interceptionPointCategory, this.parameters, userName, this.getRequest());
        this.url = this.getResponse().encodeRedirectURL(this.returnAddress);
        if (this.returnAddress.indexOf("http") == 0) {
            this.getResponse().sendRedirect(this.url);
            return "none";
        }
        return "success";
    }

    public String doSaveAndExit() throws Exception {
        this.doExecute();
        return "saveAndExit";
    }

    public String getReturnAddress() {
        return this.returnAddress;
    }

    public void setReturnAddress(String returnAddress) {
        this.returnAddress = returnAddress;
    }

    public Integer getInterceptionPointId() {
        return this.interceptionPointId;
    }

    public void setInterceptionPointId(Integer interceptionPointId) {
        this.interceptionPointId = interceptionPointId;
    }

    public Integer getAccessRightId() {
        return this.accessRightId;
    }

    public void setAccessRightId(Integer accessRightId) {
        this.accessRightId = accessRightId;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public String getInterceptionPointCategory() {
        return this.interceptionPointCategory;
    }

    public void setInterceptionPointCategory(String interceptionPointCategory) {
        this.interceptionPointCategory = interceptionPointCategory;
    }

    public String getUrl() {
        return this.url;
    }
}

