/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.EventController;
import org.infoglue.cms.controllers.kernel.impl.simple.PublicationController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.publishing.PublicationVO;
import org.infoglue.cms.entities.workflow.EventVO;
import org.infoglue.cms.exception.AccessConstraintException;
import org.infoglue.cms.util.AccessConstraintExceptionBuffer;

public class UnpublishContentVersionAction
extends InfoGlueAbstractAction {
    private static final long serialVersionUID = 1L;
    private List contentVersionVOList = new ArrayList();
    private List contentVOList = new ArrayList();
    private Integer contentId;
    private Integer repositoryId;
    private List contentVersionId = new ArrayList();
    private Integer stateId;
    private Integer languageId;
    private String versionComment;
    private boolean overrideVersionModifyer = false;
    private String attemptDirectPublishing = "false";

    public String doInput() throws Exception {
        if (this.contentId != null) {
            ContentVO contentVO = ContentController.getContentController().getContentVOWithId(this.contentId);
            this.repositoryId = contentVO.getRepositoryId();
            AccessConstraintExceptionBuffer ceb = new AccessConstraintExceptionBuffer();
            Integer protectedContentId = ContentControllerProxy.getController().getProtectedContentId(this.contentId);
            if (protectedContentId != null && !AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), "Content.SubmitToPublish", protectedContentId.toString())) {
                ceb.add(new AccessConstraintException("Content.contentId", "1005"));
            }
            ceb.throwIfNotEmpty();
            this.contentVersionVOList = ContentVersionController.getContentVersionController().getContentVersionVOWithParentRecursive(this.contentId, ContentVersionVO.PUBLISHED_STATE, false);
        }
        return "input";
    }

    public String doInputChooseContents() throws Exception {
        if (this.contentId != null) {
            ContentVO contentVO = ContentController.getContentController().getContentVOWithId(this.contentId);
            this.repositoryId = contentVO.getRepositoryId();
            AccessConstraintExceptionBuffer ceb = new AccessConstraintExceptionBuffer();
            Integer protectedContentId = ContentControllerProxy.getController().getProtectedContentId(this.contentId);
            if (protectedContentId != null && !AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), "Content.SubmitToPublish", protectedContentId.toString())) {
                ceb.add(new AccessConstraintException("Content.contentId", "1005"));
            }
            ceb.throwIfNotEmpty();
            this.contentVOList = ContentController.getContentController().getContentVOWithParentRecursive(this.contentId);
        }
        return "inputChooseContents";
    }

    public String doExecute() throws Exception {
        this.setContentVersionId(this.getRequest().getParameterValues("sel"));
        Iterator it = this.getContentVersionId().iterator();
        ArrayList<EventVO> events = new ArrayList<EventVO>();
        while (it.hasNext()) {
            Integer contentVersionId = (Integer)it.next();
            ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getFullContentVersionVOWithId(contentVersionId);
            EventVO eventVO = new EventVO();
            eventVO.setDescription(this.versionComment);
            eventVO.setEntityClass(ContentVersion.class.getName());
            eventVO.setEntityId(contentVersionId);
            eventVO.setName(String.valueOf(contentVersionVO.getContentName()) + "(" + contentVersionVO.getLanguageName() + ")");
            eventVO.setTypeId(EventVO.UNPUBLISH_LATEST);
            eventVO = EventController.create(eventVO, this.repositoryId, this.getInfoGluePrincipal());
            events.add(eventVO);
        }
        if (this.attemptDirectPublishing.equalsIgnoreCase("true")) {
            PublicationVO publicationVO = new PublicationVO();
            publicationVO.setName("Direct publication by " + this.getInfoGluePrincipal().getName());
            publicationVO.setDescription(this.getVersionComment());
            publicationVO.setRepositoryId(this.repositoryId);
            PublicationVO publicationVO2 = PublicationController.getController().createAndPublish(publicationVO, events, this.overrideVersionModifyer, this.getInfoGluePrincipal());
        }
        return "success";
    }

    public String doUnpublishAll() throws Exception {
        String[] contentIds = this.getRequest().getParameterValues("sel");
        ArrayList<EventVO> events = new ArrayList<EventVO>();
        int i = 0;
        while (i < contentIds.length) {
            String contentIdString = contentIds[i];
            List contentVersionsVOList = ContentVersionController.getContentVersionController().getPublishedActiveContentVersionVOList(new Integer(contentIdString));
            for (ContentVersionVO contentVersionVO : contentVersionsVOList) {
                EventVO eventVO = new EventVO();
                eventVO.setDescription(this.versionComment);
                eventVO.setEntityClass(ContentVersion.class.getName());
                eventVO.setEntityId(contentVersionVO.getContentVersionId());
                eventVO.setName(String.valueOf(contentVersionVO.getContentName()) + "(" + contentVersionVO.getLanguageName() + ")");
                eventVO.setTypeId(EventVO.UNPUBLISH_LATEST);
                eventVO = EventController.create(eventVO, this.repositoryId, this.getInfoGluePrincipal());
                events.add(eventVO);
            }
            ++i;
        }
        if (this.attemptDirectPublishing.equalsIgnoreCase("true")) {
            PublicationVO publicationVO = new PublicationVO();
            publicationVO.setName("Direct publication by " + this.getInfoGluePrincipal().getName());
            publicationVO.setDescription(this.getVersionComment());
            publicationVO.setRepositoryId(this.repositoryId);
            PublicationVO publicationVO2 = PublicationController.getController().createAndPublish(publicationVO, events, this.overrideVersionModifyer, this.getInfoGluePrincipal());
        }
        return "success";
    }

    public List getContentVersions() {
        return this.contentVersionVOList;
    }

    public List getContents() {
        return this.contentVOList;
    }

    public Integer getContentId() {
        return this.contentId;
    }

    public void setContentId(Integer contentId) {
        this.contentId = contentId;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public Integer getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(Integer languageId) {
        this.languageId = languageId;
    }

    public void setStateId(Integer stateId) {
        this.stateId = stateId;
    }

    public void setVersionComment(String versionComment) {
        this.versionComment = versionComment;
    }

    public String getVersionComment() {
        return this.versionComment;
    }

    public Integer getStateId() {
        return this.stateId;
    }

    public List getContentVersionId() {
        return this.contentVersionId;
    }

    private void setContentVersionId(String[] list) {
        this.contentVersionId = new ArrayList();
        int i = 0;
        while (i < list.length) {
            this.contentVersionId.add(new Integer(list[i]));
            ++i;
        }
    }

    public void setAttemptDirectPublishing(String attemptDirectPublishing) {
        this.attemptDirectPublishing = attemptDirectPublishing;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public boolean getOverrideVersionModifyer() {
        return this.overrideVersionModifyer;
    }

    public void setOverrideVersionModifyer(boolean overrideVersionModifyer) {
        this.overrideVersionModifyer = overrideVersionModifyer;
    }
}

