/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.entities.management.AvailableServiceBindingVO;
import org.infoglue.cms.entities.management.SiteNodeTypeDefinitionVO;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.deliver.applications.databeans.DatabaseWrapper;
import org.infoglue.deliver.controllers.kernel.impl.simple.BasicTemplateController;
import org.infoglue.deliver.controllers.kernel.impl.simple.IntegrationDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.NodeDeliveryController;
import org.infoglue.deliver.util.BrowserBean;

public class TextToImageEditorAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)TextToImageEditorAction.class.getName());
    private static final long serialVersionUID = 1L;
    private Integer languageId = null;
    private Integer contentId = null;
    private Integer siteNodeId = null;
    private Integer repositoryId = null;
    private String[] defaultSizes = new String[]{"8", "9", "10", "11", "12", "13", "14", "15", "16", "18", "20", "22", "24", "26", "28", "30", "36", "42", "48", "72"};
    private String text = "Sample";
    private String canvasWidth = "200";
    private String canvasHeight = "50";
    private String textStartPosX = "0";
    private String textStartPosY = "0";
    private String textWidth = "20";
    private String textHeight = "20";
    private String fontName = "Serif";
    private String fontStyle = "0";
    private String fontSize = "12";
    private String foregroundColor = "000000";
    private String backgroundColor = "FFFFFF";
    private String generatedImage = "";
    private String generatedCommand = "";
    private Collection fontNames = new ArrayList();
    private Collection fonts = new ArrayList();
    private SiteNodeVO siteNodeVO;
    private SiteNodeVersionVO siteNodeVersionVO;
    private SiteNodeTypeDefinitionVO siteNodeTypeDefinitionVO;
    private List availableServiceBindings;
    private List serviceBindings;

    public int getBoldValue() {
        return 1;
    }

    public int getItalicValue() {
        return 2;
    }

    public String[] getSizes() {
        return this.defaultSizes;
    }

    private String q(String t) {
        return "\"" + t + "\"";
    }

    private String qc(String t) {
        return "\"" + t + "\", ";
    }

    private String c(String t) {
        return t + ", ";
    }

    protected void initialize(Integer siteNodeId) throws Exception {
        this.siteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(siteNodeId);
        this.siteNodeVersionVO = SiteNodeVersionController.getController().getLatestSiteNodeVersionVO(siteNodeId);
        if (this.siteNodeVO.getSiteNodeTypeDefinitionId() != null) {
            this.siteNodeTypeDefinitionVO = SiteNodeTypeDefinitionController.getController().getSiteNodeTypeDefinitionVOWithId(this.siteNodeVO.getSiteNodeTypeDefinitionId());
            this.availableServiceBindings = SiteNodeTypeDefinitionController.getController().getAvailableServiceBindingVOList(this.siteNodeVO.getSiteNodeTypeDefinitionId());
            this.serviceBindings = SiteNodeVersionController.getServiceBindningVOList(this.siteNodeVersionVO.getSiteNodeVersionId());
        }
    }

    protected String doExecute() throws Exception {
        DatabaseWrapper dbWrapper = new DatabaseWrapper(CastorDatabaseService.getDatabase());
        this.beginTransaction(dbWrapper.getDatabase());
        try {
            if (this.siteNodeId == null) {
                this.siteNodeId = SiteNodeController.getController().getRootSiteNodeVO(this.repositoryId).getId();
            }
            if (this.languageId == null) {
                this.languageId = LanguageController.getController().getMasterLanguage(this.repositoryId).getId();
            }
            if (this.contentId == null) {
                this.contentId = new Integer(-1);
            }
            this.initialize(this.siteNodeId);
            Font[] allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
            int i = 0;
            while (i < allFonts.length) {
                this.fonts.add(allFonts[i]);
                ++i;
            }
            String[] fontNamesList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            int i2 = 0;
            while (i2 < fontNamesList.length) {
                this.fontNames.add(fontNamesList[i2]);
                ++i2;
            }
            StringBuffer t = new StringBuffer();
            t.append("$templateLogic.getStringAsImageUrl(");
            t.append(this.qc(this.text));
            t.append(this.c(this.canvasWidth));
            t.append(this.c(this.canvasHeight));
            t.append(this.c(this.textStartPosX));
            t.append(this.c(this.textStartPosY));
            t.append(this.c(this.textWidth));
            t.append(this.c(this.textHeight));
            t.append(this.qc(this.fontName));
            t.append(this.c(this.fontStyle));
            t.append(this.c(this.fontSize));
            t.append(this.qc(this.foregroundColor));
            t.append(this.q(this.backgroundColor));
            t.append(")");
            BasicTemplateController templateController = this.getTemplateController(dbWrapper, this.siteNodeId, this.languageId, this.contentId);
            this.generatedImage = templateController.renderString(t.toString());
            this.generatedCommand = t.toString();
            this.closeTransaction(dbWrapper.getDatabase());
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            this.rollbackTransaction(dbWrapper.getDatabase());
            throw new SystemException(e.getMessage());
        }
        return "success";
    }

    public BasicTemplateController getTemplateController(DatabaseWrapper databaseWrapper, Integer siteNodeId, Integer languageId, Integer contentId) throws SystemException, Exception {
        BasicTemplateController templateController = new BasicTemplateController(databaseWrapper, this.getInfoGluePrincipal());
        templateController.setStandardRequestParameters(siteNodeId, languageId, contentId);
        templateController.setHttpRequest(this.getRequest());
        templateController.setBrowserBean(new BrowserBean());
        templateController.setDeliveryControllers(NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, contentId), null, IntegrationDeliveryController.getIntegrationDeliveryController(siteNodeId, languageId, contentId));
        return templateController;
    }

    public List getSortedAvailableServiceBindings() {
        ArrayList<AvailableServiceBindingVO> sortedAvailableServiceBindings = new ArrayList<AvailableServiceBindingVO>();
        for (AvailableServiceBindingVO availableServiceBinding : this.availableServiceBindings) {
            int index = 0;
            for (AvailableServiceBindingVO sortedAvailableServiceBinding : sortedAvailableServiceBindings) {
                String currentAttribute = availableServiceBinding.getName();
                String sortedAttribute = sortedAvailableServiceBinding.getName();
                if (currentAttribute != null && sortedAttribute != null && currentAttribute.compareTo(sortedAttribute) < 0) break;
                ++index;
            }
            sortedAvailableServiceBindings.add(index, availableServiceBinding);
        }
        return sortedAvailableServiceBindings;
    }

    public List getSortedAvailableContentServiceBindings() {
        ArrayList<AvailableServiceBindingVO> sortedAvailableContentServiceBindings = new ArrayList<AvailableServiceBindingVO>();
        for (AvailableServiceBindingVO sortedAvailableServiceBinding : this.getSortedAvailableServiceBindings()) {
            if (sortedAvailableServiceBinding.getVisualizationAction().indexOf("Structure") != -1) continue;
            sortedAvailableContentServiceBindings.add(sortedAvailableServiceBinding);
        }
        return sortedAvailableContentServiceBindings;
    }

    public List getSortedAvailableSingleContentServiceBindings() {
        ArrayList<AvailableServiceBindingVO> sortedAvailableContentServiceBindings = new ArrayList<AvailableServiceBindingVO>();
        for (AvailableServiceBindingVO sortedAvailableServiceBinding : this.getSortedAvailableServiceBindings()) {
            if (sortedAvailableServiceBinding.getVisualizationAction().indexOf("Structure") != -1 || sortedAvailableServiceBinding.getVisualizationAction().indexOf("Multi") != -1) continue;
            sortedAvailableContentServiceBindings.add(sortedAvailableServiceBinding);
        }
        return sortedAvailableContentServiceBindings;
    }

    public List getAvailableAttributes() {
        ArrayList<AvailableServiceBindingVO> sortedAvailableContentServiceBindings = new ArrayList<AvailableServiceBindingVO>();
        for (AvailableServiceBindingVO sortedAvailableServiceBinding : this.getSortedAvailableServiceBindings()) {
            if (sortedAvailableServiceBinding.getVisualizationAction().indexOf("Structure") != -1 || sortedAvailableServiceBinding.getVisualizationAction().indexOf("Multi") != -1) continue;
            sortedAvailableContentServiceBindings.add(sortedAvailableServiceBinding);
        }
        return sortedAvailableContentServiceBindings;
    }

    public List getSortedAvailableStructureServiceBindings() {
        ArrayList<AvailableServiceBindingVO> sortedAvailableStructureServiceBindings = new ArrayList<AvailableServiceBindingVO>();
        for (AvailableServiceBindingVO sortedAvailableServiceBinding : this.getSortedAvailableServiceBindings()) {
            if (sortedAvailableServiceBinding.getVisualizationAction().indexOf("Structure") <= -1) continue;
            sortedAvailableStructureServiceBindings.add(sortedAvailableServiceBinding);
        }
        return sortedAvailableStructureServiceBindings;
    }

    public List getServiceBindings() {
        return this.serviceBindings;
    }

    public String getGeneratedImage() {
        return this.generatedImage;
    }

    public Collection getFonts() {
        return this.fonts;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public String getCanvasHeight() {
        return this.canvasHeight;
    }

    public void setCanvasHeight(String canvasHeight) {
        this.canvasHeight = canvasHeight;
    }

    public String getCanvasWidth() {
        return this.canvasWidth;
    }

    public void setCanvasWidth(String canvasWidth) {
        this.canvasWidth = canvasWidth;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
    }

    public String getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(String foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getTextHeight() {
        return this.textHeight;
    }

    public void setTextHeight(String textHeight) {
        this.textHeight = textHeight;
    }

    public String getTextStartPosX() {
        return this.textStartPosX;
    }

    public void setTextStartPosX(String textStartPosX) {
        this.textStartPosX = textStartPosX;
    }

    public String getTextStartPosY() {
        return this.textStartPosY;
    }

    public void setTextStartPosY(String textStartPosY) {
        this.textStartPosY = textStartPosY;
    }

    public String getTextWidth() {
        return this.textWidth;
    }

    public void setTextWidth(String textWidth) {
        this.textWidth = textWidth;
    }

    public Collection getFontNames() {
        return this.fontNames;
    }

    public Integer getContentId() {
        return this.contentId;
    }

    public void setContentId(Integer contentId) {
        this.contentId = contentId;
    }

    public Integer getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(Integer languageId) {
        this.languageId = languageId;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public Integer getSiteNodeId() {
        return this.siteNodeId;
    }

    public void setSiteNodeId(Integer siteNodeId) {
        this.siteNodeId = siteNodeId;
    }

    public String getGeneratedCommand() {
        return this.generatedCommand;
    }

    public void setGeneratedCommand(String generatedCommand) {
        this.generatedCommand = generatedCommand;
    }
}

