/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import com.frovi.ss.Tree.INodeSupplier;
import com.thoughtworks.xstream.core.util.Base64Encoder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.infoglue.cms.applications.common.actions.SimpleXmlServiceAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.treeservice.ss.ContentNodeSupplier;
import org.infoglue.deliver.util.CompressionHelper;

public class SimpleContentXmlAction
extends SimpleXmlServiceAction {
    private static final Logger logger = Logger.getLogger((String)SimpleContentXmlAction.class.getName());
    private static final long serialVersionUID = 1L;
    private static String TYPE_FOLDER = "ContentFolder";
    private static String TYPE_ITEM = "ContentItem";
    private String digitalAssetKey;
    private Integer digitalAssetId;
    private Integer languageId;
    private boolean enableCompression = false;

    public INodeSupplier getNodeSupplier() throws SystemException {
        ContentNodeSupplier sup = new ContentNodeSupplier(this.getRepositoryId(), this.getInfoGluePrincipal());
        sup.setShowLeafs(this.showLeafs.compareTo("yes") == 0);
        sup.setAllowedContentTypeIds(this.allowedContentTypeIds);
        return sup;
    }

    public String doDigitalAssets() throws Exception {
        String ret = "";
        DigitalAssetVO digitalAssetVO = null;
        digitalAssetVO = this.digitalAssetId != null ? DigitalAssetController.getDigitalAssetVOWithId(this.digitalAssetId) : DigitalAssetController.getDigitalAssetVO(this.parent, this.languageId, this.digitalAssetKey, true);
        ret = "<digitalAssetInfo><assetURL>" + DigitalAssetController.getDigitalAssetUrl(digitalAssetVO.getId()) + "</assetURL>" + "<assetId>" + digitalAssetVO.getId() + "</assetId>" + "</digitalAssetInfo>";
        return ret;
    }

    public ContentVersionVO getLatestContentVersionVO(Integer contentId, Integer languageId) {
        ContentVersionVO contentVersionVO = null;
        try {
            contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentId, languageId);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to get the latest version for the content:" + e.getMessage()), (Throwable)e);
        }
        return contentVersionVO;
    }

    public Element getContentElement(Integer contentId) throws Bug, Exception {
        ContentController contentController = ContentController.getContentController();
        ContentVO vo = contentController.getContentVOWithId(contentId);
        return this.getContentElement(vo);
    }

    public Element getContentElement(ContentVO vo) throws Bug, Exception {
        Element elm = DocumentHelper.createElement((String)"content");
        ContentVersionController contentVersionController = ContentVersionController.getContentVersionController();
        ContentVersionVO activeVersion = contentVersionController.getLatestActiveContentVersionVO(vo.getContentId(), LanguageController.getController().getMasterLanguage(vo.getRepositoryId()).getLanguageId());
        if (activeVersion != null) {
            elm.addAttribute("id", "" + vo.getContentId());
            elm.addAttribute("creatorName", vo.getCreatorName());
            elm.addAttribute("name", vo.getName());
            elm.addAttribute("typedefid", "" + vo.getContentTypeDefinitionId());
            elm.addAttribute("expiredatetime", "" + vo.getExpireDateTime().getTime());
            elm.addAttribute("publishdatetime", "" + vo.getPublishDateTime().getTime());
            elm.addAttribute("isbranch", "" + vo.getIsBranch());
            elm.addAttribute("activeVersion", "" + activeVersion.getContentVersionId());
            elm.addAttribute("activeVersionStateId", "" + activeVersion.getStateId());
            elm.addAttribute("activeVersionModifier", activeVersion.getVersionModifier());
            Element versionsElement = DocumentHelper.createElement((String)"versions");
            elm.add(versionsElement);
            List versions = contentVersionController.getContentVersionVOWithParent(vo.getContentId());
            for (ContentVersionVO version : versions) {
                Element contentVersionElement = DocumentHelper.createElement((String)"contentVersion");
                contentVersionElement.add(this.getContentVersionHeadElement(version));
                versionsElement.add(contentVersionElement);
            }
        }
        return elm;
    }

    public Element getContentVersionElement(Integer contentVersionId) throws SystemException, Bug, UnsupportedEncodingException {
        ContentVersionController contentVersionController = ContentVersionController.getContentVersionController();
        ContentVersionVO vo = contentVersionController.getContentVersionVOWithId(contentVersionId);
        return this.getContentVersionElement(vo);
    }

    public Element getContentVersionHeadElement(Integer contentVersionId) throws SystemException, Bug, UnsupportedEncodingException {
        ContentVersionController contentVersionController = ContentVersionController.getContentVersionController();
        ContentVersionVO vo = contentVersionController.getContentVersionVOWithId(contentVersionId);
        return this.getContentVersionHeadElement(vo);
    }

    public Element getContentVersionElement(ContentVersionVO vo) throws SystemException, Bug, UnsupportedEncodingException {
        Element element = DocumentHelper.createElement((String)"contentVersion");
        element.add(this.getContentVersionHeadElement(vo));
        element.add(this.getContentVersionValueElement(vo));
        return element;
    }

    public Element getContentVersionHeadElement(ContentVersionVO vo) throws SystemException, Bug, UnsupportedEncodingException {
        Element head = DocumentHelper.createElement((String)"head");
        head.addAttribute("id", "" + vo.getContentVersionId());
        head.addAttribute("languageId", "" + vo.getLanguageId());
        head.addAttribute("contentId", "" + vo.getContentId());
        head.addAttribute("languageName", vo.getLanguageName());
        head.addAttribute("isActive", "" + vo.getIsActive());
        head.addAttribute("mod", "" + vo.getModifiedDateTime().getTime());
        head.addAttribute("activeVersionModifier", vo.getVersionModifier());
        head.addAttribute("activeVersionStateId", "" + vo.getStateId());
        return head;
    }

    public Element getContentVersionValueElement(ContentVersionVO vo) throws SystemException, Bug, UnsupportedEncodingException {
        Element value = DocumentHelper.createElement((String)"value");
        if (this.enableCompression) {
            Base64Encoder encoder = new Base64Encoder();
            CompressionHelper zip = new CompressionHelper();
            byte[] val = zip.compress(vo.getVersionValue());
            value.addCDATA(encoder.encode(val));
        } else {
            value.addCDATA(URLEncoder.encode(vo.getVersionValue(), "UTF-8"));
        }
        return value;
    }

    public String doContentVersion() throws Exception {
        Document doc = DocumentHelper.createDocument();
        doc.add(this.getContentVersionElement(this.parent));
        return this.out(this.getFormattedDocument(doc));
    }

    public String doContent() throws Exception {
        Document doc = DocumentHelper.createDocument();
        doc.add(this.getContentElement(this.parent));
        return this.out(this.getFormattedDocument(doc));
    }

    public String doContentVersionHead() throws Exception {
        Document doc = DocumentHelper.createDocument();
        Element element = DocumentHelper.createElement((String)"contentVersion");
        element.add(this.getContentVersionHeadElement(this.parent));
        element.add(DocumentHelper.createElement((String)"value"));
        doc.add(element);
        return this.out(this.getFormattedDocument(doc));
    }

    public String doContentVersions() throws Exception {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("contentVersions");
        List availableLanguages = ContentController.getContentController().getRepositoryLanguages(this.parent);
        for (LanguageVO lvo : availableLanguages) {
            ContentVersionVO vo = this.getLatestContentVersionVO(this.parent, lvo.getLanguageId());
            if (vo == null) continue;
            root.add(this.getContentVersionElement(vo));
        }
        ContentVersionController contentVersionController = ContentVersionController.getContentVersionController();
        return this.out(this.getFormattedDocument(doc));
    }

    protected BaseEntityVO getRootEntityVO(Integer repositoryId, InfoGluePrincipal principal) throws ConstraintException, SystemException {
        return ContentControllerProxy.getController().getRootContentVO(repositoryId, principal.getName());
    }

    public boolean isEnableCompression() {
        return this.enableCompression;
    }

    public void setEnableCompression(boolean enableCompression) {
        this.enableCompression = enableCompression;
    }
}

