/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.SearchController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.util.CmsPropertyHandler;

public class SearchContentAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)SearchContentAction.class.getName());
    private static final long serialVersionUID = 1L;
    private List contentVersionVOList;
    private Set contentVOSet;
    private Integer repositoryId;
    private String searchString;
    private String name;
    private Integer languageId;
    private Integer contentTypeDefinitionId;
    private Integer caseSensitive;
    private boolean includeAssets = false;
    private Integer inverseSearch;
    private Integer stateId;
    private boolean advancedEnabled = false;
    private List selectedRepositoryIdList = new ArrayList();
    private String[] allowedContentTypeIds = null;
    private int maxRows = 0;
    private List principals = null;
    private List availableLanguages = null;
    private List contentTypeDefinitions = null;
    private List repositories = null;
    private String replaceString = null;

    public void setSearchString(String s) {
        this.searchString = s;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setMaxRows(int r) {
        this.maxRows = r;
    }

    public int getMaxRows() {
        if (this.maxRows == 0) {
            this.maxRows = 100;
        }
        return this.maxRows;
    }

    public List getContentVersionVOList() {
        return this.contentVersionVOList;
    }

    public String doExecute() throws Exception {
        int maxRows = 100;
        try {
            maxRows = Integer.parseInt(CmsPropertyHandler.getMaxRows());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] repositoryIdToSearch = this.getRequest().getParameterValues("repositoryIdToSearch");
        if (repositoryIdToSearch != null) {
            Integer[] repositoryIdAsIntegerToSearch = new Integer[repositoryIdToSearch.length];
            int i = 0;
            while (i < repositoryIdToSearch.length) {
                repositoryIdAsIntegerToSearch[i] = new Integer(repositoryIdToSearch[i]);
                this.selectedRepositoryIdList.add(repositoryIdToSearch[i]);
                ++i;
            }
            this.contentVersionVOList = SearchController.getContentVersions(repositoryIdAsIntegerToSearch, this.getSearchString(), maxRows, this.name, this.languageId, new Integer[]{this.contentTypeDefinitionId}, this.caseSensitive, this.stateId, this.includeAssets);
        } else {
            this.contentVersionVOList = SearchController.getContentVersions(this.repositoryId, this.getSearchString(), maxRows, this.name, this.languageId, new Integer[]{this.contentTypeDefinitionId}, this.caseSensitive, this.stateId, this.includeAssets);
            this.selectedRepositoryIdList.add("" + this.repositoryId);
        }
        this.principals = UserControllerProxy.getController().getAllUsers();
        this.availableLanguages = LanguageController.getController().getLanguageVOList(this.repositoryId);
        this.contentTypeDefinitions = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList();
        this.repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), false);
        return "success";
    }

    public String doBindingResult() throws Exception {
        Integer[] allowedContentTypeId = new Integer[]{};
        if (this.allowedContentTypeIds != null && this.allowedContentTypeIds.length != 0) {
            allowedContentTypeId = new Integer[this.allowedContentTypeIds.length];
            int i = 0;
            while (i < this.allowedContentTypeIds.length) {
                allowedContentTypeId[i] = new Integer(this.allowedContentTypeIds[i]);
                ++i;
            }
        }
        int maxRows = 100;
        try {
            maxRows = Integer.parseInt(CmsPropertyHandler.getMaxRows());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] repositoryIdToSearch = this.getRequest().getParameterValues("repositoryIdToSearch");
        if (repositoryIdToSearch != null) {
            Integer[] repositoryIdAsIntegerToSearch = new Integer[repositoryIdToSearch.length];
            int i = 0;
            while (i < repositoryIdToSearch.length) {
                repositoryIdAsIntegerToSearch[i] = new Integer(repositoryIdToSearch[i]);
                this.selectedRepositoryIdList.add(repositoryIdToSearch[i]);
                ++i;
            }
            this.contentVOSet = SearchController.getContents(repositoryIdAsIntegerToSearch, this.getSearchString(), maxRows, this.name, this.languageId, allowedContentTypeId, this.caseSensitive, this.stateId);
        } else {
            this.contentVOSet = SearchController.getContents(this.repositoryId, this.getSearchString(), maxRows, this.name, this.languageId, allowedContentTypeId, this.caseSensitive, this.stateId);
            this.selectedRepositoryIdList.add("" + this.repositoryId);
        }
        return "successBindingResult";
    }

    public String doInlineAssetResult() throws Exception {
        Integer[] allowedContentTypeId = new Integer[]{};
        if (this.allowedContentTypeIds != null && this.allowedContentTypeIds.length != 0) {
            allowedContentTypeId = new Integer[this.allowedContentTypeIds.length];
            int i = 0;
            while (i < this.allowedContentTypeIds.length) {
                allowedContentTypeId[i] = new Integer(this.allowedContentTypeIds[i]);
                ++i;
            }
        }
        int maxRows = 100;
        try {
            maxRows = Integer.parseInt(CmsPropertyHandler.getMaxRows());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] repositoryIdToSearch = this.getRequest().getParameterValues("repositoryIdToSearch");
        if (repositoryIdToSearch != null) {
            Integer[] repositoryIdAsIntegerToSearch = new Integer[repositoryIdToSearch.length];
            int i = 0;
            while (i < repositoryIdToSearch.length) {
                repositoryIdAsIntegerToSearch[i] = new Integer(repositoryIdToSearch[i]);
                this.selectedRepositoryIdList.add(repositoryIdToSearch[i]);
                ++i;
            }
            this.contentVOSet = SearchController.getContents(repositoryIdAsIntegerToSearch, this.getSearchString(), maxRows, this.name, this.languageId, allowedContentTypeId, this.caseSensitive, this.stateId, true);
        } else {
            this.contentVOSet = SearchController.getContents(this.repositoryId, this.getSearchString(), maxRows, this.name, this.languageId, allowedContentTypeId, this.caseSensitive, this.stateId, true);
            this.selectedRepositoryIdList.add("" + this.repositoryId);
        }
        return "successInlineAssetResult";
    }

    public String doInput() throws Exception {
        this.principals = UserControllerProxy.getController().getAllUsers();
        this.availableLanguages = LanguageController.getController().getLanguageVOList(this.repositoryId);
        this.contentTypeDefinitions = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList();
        this.repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), false);
        this.selectedRepositoryIdList.add("" + this.repositoryId);
        return "input";
    }

    public String doInputBinding() throws Exception {
        this.repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), false);
        return "inputBinding";
    }

    public String doInputInlineAsset() throws Exception {
        this.repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), false);
        return "inputInlineAsset";
    }

    public ContentVO getContentVO(Integer contentId) {
        ContentVO contentVO = null;
        try {
            if (contentId != null) {
                contentVO = ContentController.getContentController().getContentVOWithId(contentId);
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to get the content for this version:" + e.getMessage()), (Throwable)e);
        }
        return contentVO;
    }

    public String getContentPath(Integer contentId) throws Exception {
        StringBuffer sb = new StringBuffer();
        ContentVO contentVO = ContentController.getContentController().getContentVOWithId(contentId);
        sb.insert(0, contentVO.getName());
        while (contentVO.getParentContentId() != null) {
            contentVO = ContentController.getContentController().getContentVOWithId(contentVO.getParentContentId());
            sb.insert(0, String.valueOf(contentVO.getName()) + "/");
        }
        sb.insert(0, "/");
        return sb.toString();
    }

    public LanguageVO getLanguageVO(Integer languageId) {
        LanguageVO languageVO = null;
        try {
            if (languageId != null) {
                languageVO = LanguageController.getController().getLanguageVOWithId(languageId);
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to get the language for this version:" + e.getMessage()), (Throwable)e);
        }
        return languageVO;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(Integer integer) {
        this.repositoryId = integer;
    }

    public List getAvailableLanguages() {
        return this.availableLanguages;
    }

    public List getContentTypeDefinitions() {
        return this.contentTypeDefinitions;
    }

    public List getRepositories() {
        return this.repositories;
    }

    public List getPrincipals() {
        return this.principals;
    }

    public String getReplaceString() {
        return this.replaceString;
    }

    public void setReplaceString(String replaceString) {
        this.replaceString = replaceString;
    }

    public Integer getCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(Integer caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public Integer getContentTypeDefinitionId() {
        return this.contentTypeDefinitionId;
    }

    public void setContentTypeDefinitionId(Integer contentTypeDefinitionId) {
        this.contentTypeDefinitionId = contentTypeDefinitionId;
    }

    public Integer getInverseSearch() {
        return this.inverseSearch;
    }

    public void setInverseSearch(Integer inverseSearch) {
        this.inverseSearch = inverseSearch;
    }

    public Integer getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(Integer languageId) {
        this.languageId = languageId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getStateId() {
        return this.stateId;
    }

    public void setStateId(Integer stateId) {
        this.stateId = stateId;
    }

    public boolean isAdvancedEnabled() {
        return this.advancedEnabled;
    }

    public void setAdvancedEnabled(boolean advancedEnabled) {
        this.advancedEnabled = advancedEnabled;
    }

    public List getSelectedRepositoryIdList() {
        return this.selectedRepositoryIdList;
    }

    public void setAllowedContentTypeIds(String[] allowedContentTypeIds) {
        this.allowedContentTypeIds = allowedContentTypeIds;
    }

    public String getAllowedContentTypeIdsAsUrlEncodedString() throws Exception {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.allowedContentTypeIds.length) {
            if (i > 0) {
                sb.append("&");
            }
            sb.append("allowedContentTypeIds=" + URLEncoder.encode(this.allowedContentTypeIds[i], "UTF-8"));
            ++i;
        }
        return sb.toString();
    }

    public Set getContentVOSet() {
        return this.contentVOSet;
    }

    public String[] getAllowedContentTypeIds() {
        return this.allowedContentTypeIds;
    }

    public boolean getIncludeAssets() {
        return this.includeAssets;
    }

    public void setIncludeAssets(boolean includeAssets) {
        this.includeAssets = includeAssets;
    }
}

