/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.dom.DOMBuilder;

public class MoveMultipleContentAction
extends InfoGlueAbstractAction {
    private static final long serialVersionUID = 1L;
    private Integer originalContentId;
    private Integer repositoryId;
    private Integer contentId;
    private Integer parentContentId;
    private List qualifyers = new ArrayList();
    private boolean errorsOccurred = false;
    protected List repositories = null;
    protected String qualifyerXML = null;
    private Integer newParentContentId;
    private Integer changeTypeId;
    private Integer topContentId;
    private ConstraintExceptionBuffer ceb;
    private ContentVO contentVO;

    public MoveMultipleContentAction() {
        this(new ContentVO());
    }

    public MoveMultipleContentAction(ContentVO contentVO) {
        this.contentVO = contentVO;
        this.ceb = new ConstraintExceptionBuffer();
    }

    public void setContentId(Integer contentId) {
        this.contentVO.setContentId(contentId);
    }

    public void setNewParentContentId(Integer newParentContentId) {
        this.newParentContentId = newParentContentId;
    }

    public void setParentContentId(Integer parentContentId) {
        this.parentContentId = parentContentId;
    }

    public void setChangeTypeId(Integer changeTypeId) {
        this.changeTypeId = changeTypeId;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public Integer getParentContentId() {
        return this.parentContentId;
    }

    public Integer getContentId() {
        return this.contentVO.getContentId();
    }

    public Integer getNewParentContentId() {
        return this.newParentContentId;
    }

    public Integer getUnrefreshedContentId() {
        return this.newParentContentId;
    }

    public Integer getChangeTypeId() {
        return this.changeTypeId;
    }

    public String doInput() throws Exception {
        this.repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), false);
        if (this.qualifyerXML != null && !this.qualifyerXML.equals("")) {
            this.qualifyers = this.parseContentsFromXML(this.qualifyerXML);
        } else {
            ContentVO contentVO = ContentController.getContentController().getContentVOWithId(this.getContentId());
            this.qualifyers.add(contentVO);
        }
        return "input";
    }

    public String doExecute() throws Exception {
        if (this.newParentContentId == null) {
            this.repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), false);
            return "chooseDestination";
        }
        this.ceb.throwIfNotEmpty();
        try {
            if (this.qualifyerXML != null && this.qualifyerXML.length() != 0) {
                Document document = new DOMBuilder().getDocument(this.qualifyerXML);
                List contents = this.parseContentsFromXML(this.qualifyerXML);
                for (ContentVO contentVO : contents) {
                    try {
                        ContentControllerProxy.getController().acMoveContent(this.getInfoGluePrincipal(), contentVO, this.newParentContentId);
                    }
                    catch (Exception e) {
                        this.errorsOccurred = true;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.topContentId = ContentController.getContentController().getRootContentVO(this.repositoryId, this.getInfoGluePrincipal().getName()).getContentId();
        return "success";
    }

    private List parseContentsFromXML(String qualifyerXML) {
        ArrayList<ContentVO> contents = new ArrayList<ContentVO>();
        try {
            Document document = new DOMBuilder().getDocument(qualifyerXML);
            String entity = document.getRootElement().attributeValue("entity");
            HashMap<String, ContentVO> addedContents = new HashMap<String, ContentVO>();
            List children = document.getRootElement().elements();
            for (Element child : children) {
                String id = child.getStringValue();
                String path = child.attributeValue("path");
                if (addedContents.containsKey(id)) continue;
                ContentVO contentVO = ContentController.getContentController().getContentVOWithId(new Integer(id));
                contents.add(contentVO);
                addedContents.put(id, contentVO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contents;
    }

    public String getErrorKey() {
        return "Content.parentContentId";
    }

    public String getReturnAddress() {
        return "ViewContent.action?contentId=" + this.contentVO.getId() + "&repositoryId=" + this.repositoryId;
    }

    public String getQualifyerXML() {
        return this.qualifyerXML;
    }

    public void setQualifyerXML(String qualifyerXML) {
        this.qualifyerXML = qualifyerXML;
    }

    public List getQualifyers() {
        return this.qualifyers;
    }

    public Integer getOriginalContentId() {
        return this.originalContentId;
    }

    public void setOriginalContentId(Integer originalContentId) {
        this.originalContentId = originalContentId;
    }

    public Integer getTopContentId() {
        return this.topContentId;
    }

    public boolean getErrorsOccurred() {
        return this.errorsOccurred;
    }

    public List getRepositories() {
        return this.repositories;
    }
}

