/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Unmarshaller;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.content.ContentCategory;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.DigitalAsset;
import org.infoglue.cms.entities.content.impl.simple.ContentImpl;
import org.infoglue.cms.entities.content.impl.simple.ContentVersionImpl;
import org.infoglue.cms.entities.management.Category;
import org.infoglue.cms.entities.management.CategoryVO;
import org.infoglue.cms.entities.management.ContentTypeDefinition;
import org.infoglue.cms.entities.management.Language;
import org.infoglue.cms.entities.management.impl.simple.CategoryImpl;
import org.infoglue.cms.entities.management.impl.simple.ContentTypeDefinitionImpl;
import org.infoglue.cms.entities.management.impl.simple.InfoGlueExportImpl;
import org.infoglue.cms.entities.management.impl.simple.LanguageImpl;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.FileUploadHelper;
import webwork.action.ActionContext;

public class ImportContentAction
extends InfoGlueAbstractAction {
    public static final Logger logger = Logger.getLogger((String)ImportContentAction.class.getName());
    private String onlyLatestVersions = "true";
    private Integer parentContentId = null;
    private Integer repositoryId = null;

    public String doInput() throws Exception {
        return "input";
    }

    protected String doExecute() throws SystemException {
        if (!AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), "ContentTool.ImportExport", true)) {
            throw new SystemException("You are not allowed to import contents.");
        }
        Database db = CastorDatabaseService.getDatabase();
        try {
            ActionContext.getContext();
            File file = FileUploadHelper.getUploadedFile(ActionContext.getMultiPartRequest());
            if (file == null || !file.exists()) {
                throw new SystemException("The file upload must have gone bad as no file reached the import utility.");
            }
            String encoding = "UTF-8";
            int version = 2;
            Mapping map = new Mapping();
            logger.info((Object)("MappingFile:" + CastorDatabaseService.class.getResource("/xml_mapping_content_2.5.xml").toString()));
            map.loadMapping(CastorDatabaseService.class.getResource("/xml_mapping_content_2.5.xml").toString());
            db.begin();
            Content parentContent = ContentController.getContentController().getContentWithId(this.parentContentId, db);
            logger.info((Object)("parentContent:" + parentContent.getName()));
            this.repositoryId = parentContent.getRepositoryId();
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader reader = new InputStreamReader((InputStream)fis, encoding);
            Unmarshaller unmarshaller = new Unmarshaller(map);
            unmarshaller.setWhitespacePreserve(true);
            InfoGlueExportImpl infoGlueExportImplRead = (InfoGlueExportImpl)unmarshaller.unmarshal((Reader)reader);
            Collection contentTypeDefinitions = infoGlueExportImplRead.getContentTypeDefinitions();
            logger.info((Object)("Found " + contentTypeDefinitions.size() + " content type definitions"));
            Collection categories = infoGlueExportImplRead.getCategories();
            logger.info((Object)("Found " + categories.size() + " categories"));
            HashMap categoryIdMap = new HashMap();
            HashMap contentTypeIdMap = new HashMap();
            this.importCategories(categories, null, categoryIdMap, db);
            this.updateContentTypeDefinitions(contentTypeDefinitions, categoryIdMap);
            List readContents = infoGlueExportImplRead.getRootContent();
            HashMap contentIdMap = new HashMap();
            HashMap siteNodeIdMap = new HashMap();
            ArrayList allContents = new ArrayList();
            for (Content readContent : readContents) {
                readContent.setRepository(parentContent.getRepository());
                readContent.setParentContent((ContentImpl)parentContent);
                this.createContents(readContent, contentIdMap, contentTypeIdMap, allContents, Collections.unmodifiableCollection(contentTypeDefinitions), categoryIdMap, version, db);
                parentContent.getChildren().add(readContent);
            }
            ArrayList<Integer> allContentIds = new ArrayList<Integer>();
            for (Content content : allContents) {
                allContentIds.add(content.getContentId());
            }
            db.commit();
            db.close();
            for (Integer contentId : allContentIds) {
                try {
                    try {
                        db = CastorDatabaseService.getDatabase();
                        db.begin();
                        Content content = ContentController.getContentController().getContentWithId(contentId, db);
                        this.updateContentVersions(content, contentIdMap, siteNodeIdMap);
                        db.commit();
                    }
                    catch (Exception e) {
                        try {
                            db.rollback();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        logger.error((Object)("An error occurred when updating content version for content: " + e.getMessage()), (Throwable)e);
                        db.close();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    db.close();
                    throw throwable;
                }
                db.close();
            }
            reader.close();
        }
        catch (Exception e) {
            try {
                db.rollback();
                db.close();
            }
            catch (Exception e1) {
                logger.error((Object)("An error occurred when importing a repository: " + e.getMessage()), (Throwable)e);
                throw new SystemException("An error occurred when importing a repository: " + e.getMessage(), e);
            }
            logger.error((Object)("An error occurred when importing a repository: " + e.getMessage()), (Throwable)e);
            throw new SystemException("An error occurred when importing a repository: " + e.getMessage(), e);
        }
        return "success";
    }

    private void updateContentTypeDefinitions(Collection contentTypeDefinitions, Map categoryIdMap) {
        for (ContentTypeDefinition contentTypeDefinition : contentTypeDefinitions) {
            String schema = contentTypeDefinition.getSchemaValue();
            for (Integer oldId : categoryIdMap.keySet()) {
                Integer newId = (Integer)categoryIdMap.get(oldId);
                schema = schema.replaceAll("<categoryId>" + oldId + "</categoryId>", "<categoryId>new_" + newId + "</categoryId>");
            }
            schema = schema.replaceAll("<categoryId>new_", "<categoryId>");
            contentTypeDefinition.setSchemaValue(schema);
        }
    }

    private void importCategories(Collection categories, Category parentCategory, Map categoryIdMap, Database db) throws SystemException {
        logger.info((Object)("We want to create a list of categories if not existing under the parent category " + parentCategory));
        for (CategoryVO categoryVO : categories) {
            Category newParentCategory = null;
            List existingCategories = null;
            existingCategories = parentCategory != null ? CategoryController.getController().findByParent(parentCategory.getCategoryId(), db) : CategoryController.getController().findRootCategories(db);
            for (Category existingCategory : existingCategories) {
                logger.info((Object)("existingCategory:" + existingCategory.getName()));
                if (!existingCategory.getName().equals(categoryVO.getName())) continue;
                logger.info((Object)("Existed... setting " + existingCategory.getName() + " to new parent category."));
                newParentCategory = existingCategory;
                break;
            }
            if (newParentCategory == null) {
                logger.info((Object)"No existing category - we create it.");
                Integer oldId = categoryVO.getId();
                categoryVO.setCategoryId(null);
                if (parentCategory != null) {
                    categoryVO.setParentId(parentCategory.getCategoryId());
                } else {
                    categoryVO.setParentId(null);
                }
                Category newCategory = CategoryController.getController().save(categoryVO, db);
                categoryIdMap.put(oldId, newCategory.getCategoryId());
                newParentCategory = newCategory;
            } else {
                categoryIdMap.put(categoryVO.getId(), newParentCategory.getCategoryId());
            }
            this.importCategories(categoryVO.getChildren(), newParentCategory, categoryIdMap, db);
        }
    }

    private List createContents(Content content, Map idMap, Map contentTypeDefinitionIdMap, List allContents, Collection contentTypeDefinitions, Map categoryIdMap, int version, Database db) throws Exception {
        ContentTypeDefinition contentTypeDefinition = null;
        Integer originalContentId = content.getContentId();
        Integer contentTypeDefinitionId = ((ContentImpl)content).getContentTypeDefinitionId();
        if (contentTypeDefinitionId != null) {
            if (contentTypeDefinitionIdMap.containsKey(contentTypeDefinitionId)) {
                contentTypeDefinitionId = (Integer)contentTypeDefinitionIdMap.get(contentTypeDefinitionId);
            }
            ContentTypeDefinition originalContentTypeDefinition = null;
            for (ContentTypeDefinition contentTypeDefinitionCandidate : contentTypeDefinitions) {
                if (contentTypeDefinitionCandidate.getId().intValue() != contentTypeDefinitionId.intValue()) continue;
                originalContentTypeDefinition = contentTypeDefinitionCandidate;
                break;
            }
            if (originalContentTypeDefinition != null) {
                contentTypeDefinition = ContentTypeDefinitionController.getController().getContentTypeDefinitionWithName(originalContentTypeDefinition.getName(), db);
                if (contentTypeDefinition == null) {
                    Integer before = originalContentTypeDefinition.getId();
                    db.create((Object)originalContentTypeDefinition);
                    contentTypeDefinition = originalContentTypeDefinition;
                    Integer after = originalContentTypeDefinition.getId();
                    contentTypeDefinitionIdMap.put(before, after);
                }
                content.setContentTypeDefinition((ContentTypeDefinitionImpl)contentTypeDefinition);
            } else {
                logger.error((Object)("The content " + content.getName() + " had a content type not found amongst the listed ones:" + contentTypeDefinitionId));
            }
        } else {
            logger.error((Object)("The content " + content.getName() + " had no content type at all"));
        }
        if (content.getContentTypeDefinition() == null) {
            logger.error((Object)("No content type definition for content:" + content.getId()));
        }
        logger.info((Object)("Creating content:" + content.getName()));
        db.create((Object)content);
        allContents.add(content);
        Integer newContentId = content.getContentId();
        idMap.put(originalContentId.toString(), newContentId.toString());
        ArrayList<ContentVersion> contentVersions = content.getContentVersions();
        if (this.onlyLatestVersions.equalsIgnoreCase("true")) {
            logger.info((Object)("org contentVersions:" + contentVersions.size()));
            ArrayList<ContentVersion> selectedContentVersions = new ArrayList<ContentVersion>();
            for (ContentVersion contentVersion : contentVersions) {
                Iterator selectedContentVersionsIterator = selectedContentVersions.iterator();
                boolean addLanguageVersion = true;
                boolean noLanguageVersionFound = true;
                while (selectedContentVersionsIterator.hasNext()) {
                    ContentVersion currentContentVersion = (ContentVersion)selectedContentVersionsIterator.next();
                    logger.info((Object)(currentContentVersion.getLanguage().getLanguageCode() + "=" + contentVersion.getLanguage().getLanguageCode()));
                    if (!currentContentVersion.getLanguage().getLanguageCode().equals(contentVersion.getLanguage().getLanguageCode())) continue;
                    noLanguageVersionFound = false;
                    logger.info((Object)(contentVersion.getIsActive() + "=" + contentVersion.getLanguage().getLanguageCode()));
                    if (!contentVersion.getIsActive().booleanValue() || contentVersion.getContentVersionId() <= currentContentVersion.getContentVersionId()) continue;
                    logger.info((Object)"A later version was found... removing this one..");
                    selectedContentVersionsIterator.remove();
                    addLanguageVersion = true;
                }
                if (!addLanguageVersion && !noLanguageVersionFound) continue;
                selectedContentVersions.add(contentVersion);
            }
            contentVersions = selectedContentVersions;
        }
        logger.info((Object)("new contentVersions:" + contentVersions.size()));
        for (ContentVersion contentVersion : contentVersions) {
            Language language = LanguageController.getController().getLanguageWithCode(contentVersion.getLanguage().getLanguageCode(), db);
            logger.info((Object)("Creating contentVersion for language:" + contentVersion.getLanguage().getLanguageCode() + " on content " + content.getName()));
            contentVersion.setOwningContent((ContentImpl)content);
            contentVersion.setLanguage((LanguageImpl)language);
            Collection digitalAssets = contentVersion.getDigitalAssets();
            if (digitalAssets != null) {
                ArrayList<DigitalAsset> initialDigitalAssets = new ArrayList<DigitalAsset>();
                for (DigitalAsset digitalAsset : digitalAssets) {
                    ArrayList<ContentVersion> initialContentVersions = new ArrayList<ContentVersion>();
                    initialContentVersions.add(contentVersion);
                    digitalAsset.setContentVersions(initialContentVersions);
                    db.create((Object)digitalAsset);
                    initialDigitalAssets.add(digitalAsset);
                }
                contentVersion.setDigitalAssets(initialDigitalAssets);
            }
            Collection contentCategories = contentVersion.getContentCategories();
            logger.info((Object)("contentCategories:" + contentCategories.size()));
            db.create((Object)contentVersion);
            if (contentCategories == null) continue;
            ArrayList<ContentCategory> initialContentCategories = new ArrayList<ContentCategory>();
            for (ContentCategory contentCategory : contentCategories) {
                logger.info((Object)("contentCategory:" + contentCategory));
                contentCategory.setContentVersion((ContentVersionImpl)contentVersion);
                Integer oldCategoryId = contentCategory.getCategoryId();
                logger.info((Object)("oldCategoryId:" + oldCategoryId));
                Integer newCategoryId = (Integer)categoryIdMap.get(oldCategoryId);
                logger.info((Object)("newCategoryId:" + newCategoryId));
                if (newCategoryId == null) {
                    newCategoryId = oldCategoryId;
                }
                if (newCategoryId == null) continue;
                Category category = CategoryController.getController().findById(newCategoryId, db);
                logger.info((Object)("Got category:" + category));
                if (category == null) continue;
                contentCategory.setCategory((CategoryImpl)category);
                logger.info((Object)("Creating content category:" + contentCategory));
                db.create((Object)contentCategory);
                initialContentCategories.add(contentCategory);
            }
            contentVersion.setContentCategories(initialContentCategories);
        }
        Collection childContents = content.getChildren();
        if (childContents != null) {
            for (Content childContent : childContents) {
                childContent.setRepository(content.getRepository());
                childContent.setParentContent((ContentImpl)content);
                this.createContents(childContent, idMap, contentTypeDefinitionIdMap, allContents, contentTypeDefinitions, categoryIdMap, version, db);
            }
        }
        return allContents;
    }

    private void updateContentVersions(Content content, Map contentIdMap, Map siteNodeIdMap) throws Exception {
        logger.info((Object)("content:" + content.getName()));
        ArrayList<ContentVersion> contentVersions = content.getContentVersions();
        if (this.onlyLatestVersions.equalsIgnoreCase("true")) {
            logger.info((Object)("org contentVersions:" + contentVersions.size()));
            ArrayList<ContentVersion> selectedContentVersions = new ArrayList<ContentVersion>();
            for (ContentVersion contentVersion : contentVersions) {
                Iterator selectedContentVersionsIterator = selectedContentVersions.iterator();
                boolean addLanguageVersion = true;
                boolean noLanguageVersionFound = true;
                while (selectedContentVersionsIterator.hasNext()) {
                    ContentVersion currentContentVersion = (ContentVersion)selectedContentVersionsIterator.next();
                    logger.info((Object)(currentContentVersion.getLanguage().getLanguageCode() + "=" + contentVersion.getLanguage().getLanguageCode()));
                    if (!currentContentVersion.getLanguage().getLanguageCode().equals(contentVersion.getLanguage().getLanguageCode())) continue;
                    noLanguageVersionFound = false;
                    logger.info((Object)(contentVersion.getIsActive() + "=" + contentVersion.getLanguage().getLanguageCode()));
                    if (!contentVersion.getIsActive().booleanValue() || contentVersion.getContentVersionId() <= currentContentVersion.getContentVersionId()) continue;
                    logger.info((Object)"A later version was found... removing this one..");
                    selectedContentVersionsIterator.remove();
                    addLanguageVersion = true;
                }
                if (!addLanguageVersion && !noLanguageVersionFound) continue;
                selectedContentVersions.add(contentVersion);
            }
            contentVersions = selectedContentVersions;
        }
        for (ContentVersion contentVersion : contentVersions) {
            String contentVersionValue = contentVersion.getVersionValue();
            contentVersionValue = contentVersionValue.replaceAll("contentId=\"", "contentId=\"oldContentId_");
            contentVersionValue = contentVersionValue.replaceAll("\\?contentId=", "\\?contentId=oldContentId_");
            contentVersionValue = contentVersionValue.replaceAll("getInlineAssetUrl\\(", "getInlineAssetUrl\\(oldContentId_");
            contentVersionValue = contentVersionValue.replaceAll("languageId,", "languageId,oldContentId_");
            contentVersionValue = contentVersionValue.replaceAll("entity=\"Content\" entityId=\"", "entity=\"Content\" entityId=\"oldContentId_");
            contentVersionValue = contentVersionValue.replaceAll("siteNodeId=\"", "siteNodeId=\"oldSiteNodeId_");
            contentVersionValue = contentVersionValue.replaceAll("detailSiteNodeId=\"", "detailSiteNodeId=\"oldSiteNodeId_");
            contentVersionValue = contentVersionValue.replaceAll("getPageUrl\\((\\d)", "getPageUrl\\(oldSiteNodeId_$1");
            contentVersionValue = contentVersionValue.replaceAll("entity=\"SiteNode\" entityId=\"", "entity=\"SiteNode\" entityId=\"oldSiteNodeId_");
            contentVersionValue = this.prepareAllRelations(contentVersionValue);
            for (String oldContentId : contentIdMap.keySet()) {
                String newContentId = (String)contentIdMap.get(oldContentId);
                contentVersionValue = contentVersionValue.replaceAll("contentId=\"oldContentId_" + oldContentId + "\"", "contentId=\"" + newContentId + "\"");
                contentVersionValue = contentVersionValue.replaceAll("\\?contentId=oldContentId_" + oldContentId + "&", "\\?contentId=" + newContentId + "&");
                contentVersionValue = contentVersionValue.replaceAll("getInlineAssetUrl\\(oldContentId_" + oldContentId + ",", "getInlineAssetUrl\\(" + newContentId + ",");
                contentVersionValue = contentVersionValue.replaceAll("languageId,oldContentId_" + oldContentId + "\\)", "languageId," + newContentId + "\\)");
                contentVersionValue = contentVersionValue.replaceAll("entity=\"Content\" entityId=\"oldContentId_" + oldContentId + "\"", "entity=\"Content\" entityId=\"" + newContentId + "\"");
                contentVersionValue = contentVersionValue.replaceAll("<id>oldContentId_" + oldContentId + "</id>", "<id>" + newContentId + "</id>");
            }
            for (String oldSiteNodeId : siteNodeIdMap.keySet()) {
                String newSiteNodeId = (String)siteNodeIdMap.get(oldSiteNodeId);
                contentVersionValue = contentVersionValue.replaceAll("siteNodeId=\"oldSiteNodeId_" + oldSiteNodeId + "\"", "siteNodeId=\"" + newSiteNodeId + "\"");
                contentVersionValue = contentVersionValue.replaceAll("detailSiteNodeId=\"oldSiteNodeId_" + oldSiteNodeId + "\"", "detailSiteNodeId=\"" + newSiteNodeId + "\"");
                contentVersionValue = contentVersionValue.replaceAll("getPageUrl\\(oldSiteNodeId_" + oldSiteNodeId + ",", "getPageUrl\\(" + newSiteNodeId + ",");
                contentVersionValue = contentVersionValue.replaceAll("entity=\"SiteNode\" entityId=\"oldSiteNodeId_" + oldSiteNodeId + "\"", "entity=\"SiteNode\" entityId=\"" + newSiteNodeId + "\"");
                contentVersionValue = contentVersionValue.replaceAll("<id>oldSiteNodeId_" + oldSiteNodeId + "</id>", "<id>" + newSiteNodeId + "</id>");
            }
            contentVersionValue = contentVersionValue.replaceAll("oldContentId_", "");
            contentVersionValue = contentVersionValue.replaceAll("oldSiteNodeId_", "");
            logger.info((Object)("new contentVersionValue:" + contentVersionValue));
            contentVersion.setVersionValue(contentVersionValue);
        }
    }

    private String prepareAllRelations(String xml) throws Exception {
        StringBuffer newXML = new StringBuffer();
        logger.info((Object)("xml: " + xml));
        String after = xml;
        String before = "";
        String qualifyer = "";
        boolean changed = false;
        int startIndex = xml.indexOf("<qualifyer");
        while (startIndex > -1) {
            String newQualifyer;
            int stopIndex = xml.indexOf("</qualifyer>", startIndex);
            if (stopIndex > -1) {
                changed = true;
                before = xml.substring(0, startIndex);
                after = xml.substring(stopIndex + 12);
                newQualifyer = qualifyer = xml.substring(startIndex, stopIndex + 12);
                if (qualifyer.indexOf("entity='Content'") > 0) {
                    newQualifyer = qualifyer.replaceAll("<id>", "<id>oldContentId_");
                } else if (qualifyer.indexOf("entity='SiteNode'") > 0) {
                    newQualifyer = qualifyer.replaceAll("<id>", "<id>oldSiteNodeId_");
                }
            } else {
                throw new Exception("Error in xml - qualifyer tag broken in " + xml);
            }
            newXML.append(before);
            newXML.append(newQualifyer);
            xml = after;
            startIndex = xml.indexOf("<qualifyer");
        }
        newXML.append(after);
        if (changed) {
            logger.info((Object)("newXML:" + newXML));
        }
        return newXML.toString();
    }

    public String getOnlyLatestVersions() {
        return this.onlyLatestVersions;
    }

    public void setOnlyLatestVersions(String onlyLatestVersions) {
        this.onlyLatestVersions = onlyLatestVersions;
    }

    public Integer getParentContentId() {
        return this.parentContentId;
    }

    public void setParentContentId(Integer parentContentId) {
        this.parentContentId = parentContentId;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }
}

