/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import com.mullassery.imaging.Imaging;
import com.mullassery.imaging.ImagingFactory;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.applications.databeans.AssetKeyDefinition;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class ImageEditorAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ImageEditorAction.class.getName());
    private static final long serialVersionUID = 1L;
    private DigitalAssetVO digitalAssetVO = null;
    private String modifiedFileUrl = "";
    private int xpos1;
    private int ypos1;
    private int xpos2;
    private int ypos2 = 0;
    private int width;
    private int height;
    private String keepRatio = "false";
    private String bestFit = "true";
    private Integer contentVersionId = null;
    private Integer digitalAssetId = null;
    private String closeOnLoad;
    private ContentVersionVO contentVersionVO;
    private ContentTypeDefinitionVO contentTypeDefinitionVO;
    private String workingFileName;
    private String digitalAssetKey = null;
    private boolean isUpdated = false;
    private String reasonKey;
    private Integer contentTypeDefinitionId;
    private ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
    private Imaging imaging = ImagingFactory.createImagingInstance((int)4, (int)3);

    public String doExecute() throws Exception {
        this.ceb.throwIfNotEmpty();
        this.digitalAssetVO = DigitalAssetController.getDigitalAssetVOWithId(this.digitalAssetId);
        this.contentVersionVO = ContentVersionController.getContentVersionController().getContentVersionVOWithId(this.contentVersionId);
        this.contentTypeDefinitionVO = ContentController.getContentController().getContentTypeDefinition(this.contentVersionVO.getContentId());
        if (this.workingFileName == null) {
            String filePath = DigitalAssetController.getDigitalAssetFilePath(this.digitalAssetVO.getDigitalAssetId());
            BufferedImage original = ImageIO.read(new File(filePath));
            this.workingFileName = "imageEditorWK_" + System.currentTimeMillis() + "_" + this.getInfoGluePrincipal().getName().hashCode() + "_" + this.digitalAssetVO.getDigitalAssetId() + ".png";
            File outputFile = new File(String.valueOf(this.getImageEditorPath()) + File.separator + this.workingFileName);
            ImageIO.write((RenderedImage)original, "PNG", outputFile);
        }
        this.modifiedFileUrl = String.valueOf(this.getImageEditorBaseUrl()) + this.workingFileName;
        return "success";
    }

    public String doResize() throws Exception {
        this.ceb.throwIfNotEmpty();
        this.digitalAssetVO = DigitalAssetController.getDigitalAssetVOWithId(this.digitalAssetId);
        this.contentVersionVO = ContentVersionController.getContentVersionController().getContentVersionVOWithId(this.contentVersionId);
        this.contentTypeDefinitionVO = ContentController.getContentController().getContentTypeDefinition(this.contentVersionVO.getContentId());
        File file = new File(String.valueOf(this.getImageEditorPath()) + File.separator + this.workingFileName);
        BufferedImage original = ImageIO.read(file);
        int originalWidth = original.getWidth();
        int originalHeight = original.getHeight();
        float aspect = (float)originalWidth / (float)originalHeight;
        BufferedImage image = null;
        logger.info((Object)("originalWidth: " + originalWidth));
        logger.info((Object)("originalHeight: " + originalHeight));
        logger.info((Object)("height: " + this.height));
        logger.info((Object)("width: " + this.width));
        logger.info((Object)("keepRatio: " + this.keepRatio));
        logger.info((Object)("bestFit: " + this.bestFit));
        if (this.keepRatio.equalsIgnoreCase("true")) {
            aspect = this.height == -1 && this.width != -1 ? (float)this.width / (float)originalWidth : (this.width == -1 && this.height != -1 ? (float)this.height / (float)originalHeight : (float)this.width / (float)originalWidth);
            image = this.imaging.scale(original, aspect);
        } else {
            image = this.imaging.resize(original, this.width, this.height, false);
        }
        this.workingFileName = "imageEditorWK_" + System.currentTimeMillis() + "_" + this.getInfoGluePrincipal().getName().hashCode() + "_" + this.digitalAssetVO.getDigitalAssetId() + ".png";
        File outputFile = new File(String.valueOf(this.getImageEditorPath()) + File.separator + this.workingFileName);
        outputFile.mkdirs();
        ImageIO.write((RenderedImage)image, "PNG", outputFile);
        this.modifiedFileUrl = String.valueOf(this.getImageEditorBaseUrl()) + this.workingFileName;
        return "successResize";
    }

    public String doCrop() throws Exception {
        this.ceb.throwIfNotEmpty();
        this.digitalAssetVO = DigitalAssetController.getDigitalAssetVOWithId(this.digitalAssetId);
        this.contentVersionVO = ContentVersionController.getContentVersionController().getContentVersionVOWithId(this.contentVersionId);
        this.contentTypeDefinitionVO = ContentController.getContentController().getContentTypeDefinition(this.contentVersionVO.getContentId());
        File file = new File(String.valueOf(this.getImageEditorPath()) + File.separator + this.workingFileName);
        BufferedImage original = ImageIO.read(file);
        BufferedImage image = this.imaging.crop(original, (float)this.xpos1, (float)this.ypos1, (float)(this.xpos2 - this.xpos1), (float)(this.ypos2 - this.ypos1));
        this.workingFileName = "imageEditorWK_" + System.currentTimeMillis() + "_" + this.getInfoGluePrincipal().getName().hashCode() + "_" + this.digitalAssetVO.getDigitalAssetId() + ".png";
        File outputFile = new File(String.valueOf(this.getImageEditorPath()) + File.separator + this.workingFileName);
        ImageIO.write((RenderedImage)image, "PNG", outputFile);
        this.modifiedFileUrl = String.valueOf(this.getImageEditorBaseUrl()) + this.workingFileName;
        return "successCrop";
    }

    public String doSave() throws Exception {
        AssetKeyDefinition assetKeyDefinition;
        String toEncoding;
        this.ceb.throwIfNotEmpty();
        this.digitalAssetVO = DigitalAssetController.getDigitalAssetVOWithId(this.digitalAssetId);
        this.contentVersionVO = ContentVersionController.getContentVersionController().getContentVersionVOWithId(this.contentVersionId);
        this.contentTypeDefinitionVO = ContentController.getContentController().getContentTypeDefinition(this.contentVersionVO.getContentId());
        File file = new File(String.valueOf(this.getImageEditorPath()) + File.separator + this.workingFileName);
        String contentType = this.digitalAssetVO.getAssetContentType();
        String fromEncoding = CmsPropertyHandler.getUploadFromEncoding();
        if (fromEncoding == null) {
            fromEncoding = "iso-8859-1";
        }
        if ((toEncoding = CmsPropertyHandler.getUploadToEncoding()) == null) {
            toEncoding = "utf-8";
        }
        this.digitalAssetKey = new String(this.digitalAssetKey.getBytes(fromEncoding), toEncoding);
        DigitalAssetVO newAsset = new DigitalAssetVO();
        newAsset.setAssetContentType(contentType);
        newAsset.setAssetKey(this.digitalAssetKey);
        newAsset.setAssetFileName(this.digitalAssetVO.getAssetFileName());
        newAsset.setAssetFilePath(this.digitalAssetVO.getAssetFilePath());
        newAsset.setAssetFileSize(new Integer(new Long(file.length()).intValue()));
        FileInputStream is = new FileInputStream(file);
        if (this.contentTypeDefinitionId != null && this.digitalAssetKey != null && (assetKeyDefinition = ContentTypeDefinitionController.getController().getDefinedAssetKey(this.contentTypeDefinitionVO.getSchemaValue(), this.digitalAssetKey)) != null) {
            if (assetKeyDefinition.getMaximumSize() < new Long(file.length()).intValue()) {
                file.delete();
                this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnSizeText";
                return "uploadFailed";
            }
            if (assetKeyDefinition.getAllowedContentTypes().startsWith("image")) {
                if (!contentType.startsWith("image")) {
                    file.delete();
                    this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnTypeNotImageText";
                    return "uploadFailed";
                }
                BufferedImage image = ImageIO.read(file);
                int width = ((Image)image).getWidth(null);
                int height = ((Image)image).getHeight(null);
                String allowedWidth = assetKeyDefinition.getImageWidth();
                String allowedHeight = assetKeyDefinition.getImageHeight();
                if (!allowedWidth.equals("*")) {
                    Integer allowedWidthNumber = new Integer(allowedWidth.substring(1));
                    if (allowedWidth.startsWith("<") && width >= allowedWidthNumber) {
                        file.delete();
                        this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnImageToWideText";
                        return "uploadFailed";
                    }
                    if (allowedWidth.startsWith(">") && width <= allowedWidthNumber) {
                        file.delete();
                        this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnImageNotWideEnoughText";
                        return "uploadFailed";
                    }
                    if (!allowedWidth.startsWith(">") && !allowedWidth.startsWith("<") && width != new Integer(allowedWidth)) {
                        file.delete();
                        this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnImageWrongWidthText";
                        return "uploadFailed";
                    }
                }
                if (!allowedHeight.equals("*")) {
                    Integer allowedHeightNumber = new Integer(allowedHeight.substring(1));
                    if (allowedHeight.startsWith("<") && height >= allowedHeightNumber) {
                        file.delete();
                        this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnImageToHighText";
                        return "uploadFailed";
                    }
                    if (allowedHeight.startsWith(">") && height <= allowedHeightNumber) {
                        file.delete();
                        this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnImageNotHighEnoughText";
                        return "uploadFailed";
                    }
                    if (!allowedHeight.startsWith(">") && !allowedHeight.startsWith("<") && height != new Integer(allowedHeight)) {
                        file.delete();
                        this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnImageWrongHeightText";
                        return "uploadFailed";
                    }
                }
            }
        }
        if (this.contentVersionId != null) {
            this.digitalAssetVO = DigitalAssetController.create(newAsset, (InputStream)is, this.contentVersionId, this.getInfoGluePrincipal());
        }
        if (is != null) {
            ((InputStream)is).close();
        }
        this.workingFileName = "imageEditorWK_" + System.currentTimeMillis() + "_" + this.getInfoGluePrincipal().getName().hashCode() + "_" + this.digitalAssetVO.getDigitalAssetId() + ".png";
        if (CmsPropertyHandler.getEnableDiskAssets().equals("true") && file.exists()) {
            String folderName = "" + this.digitalAssetVO.getDigitalAssetId() / 1000;
            String assetFileName = this.digitalAssetVO.getAssetFilePath() + File.separator + folderName + File.separator + this.digitalAssetVO.getId() + "_" + this.digitalAssetVO.getAssetFileName();
            File finalAssetFile = new File(assetFileName);
            boolean moved = file.renameTo(finalAssetFile);
        } else {
            boolean bl = file.delete();
        }
        this.cleanOldWorkingFiles(true);
        this.closeOnLoad = "true";
        return "successSaveAndExit";
    }

    private void cleanOldWorkingFiles(boolean cleanAll) throws Exception {
        File workingAssetsDir = new File(this.getImageEditorPath());
        final String matchString = "_" + this.getInfoGluePrincipal().getName() + "_" + this.digitalAssetId;
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.indexOf(matchString) > -1;
            }
        };
        File[] files = workingAssetsDir.listFiles(filter);
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            boolean bl = file.delete();
            ++i;
        }
        File[] allFiles = workingAssetsDir.listFiles();
        int i2 = 0;
        while (i2 < allFiles.length) {
            File file = allFiles[i2];
            long modified = file.lastModified();
            long difference = System.currentTimeMillis() - modified;
            if (difference > 43200000L) {
                file.delete();
            }
            ++i2;
        }
    }

    private String getImageEditorPath() {
        String path = String.valueOf(CmsPropertyHandler.getDigitalAssetPath()) + File.separator + "imageEditor";
        File dir = new File(path);
        dir.mkdirs();
        return path;
    }

    private String getImageEditorBaseUrl() {
        return String.valueOf(CmsPropertyHandler.getWebServerAddress()) + "/" + CmsPropertyHandler.getDigitalAssetBaseUrl() + "/imageEditor/";
    }

    public void setDigitalAssetKey(String digitalAssetKey) {
        this.digitalAssetKey = digitalAssetKey;
    }

    public List getDefinedAssetKeys() {
        return ContentTypeDefinitionController.getController().getDefinedAssetKeys(this.contentTypeDefinitionVO.getSchemaValue());
    }

    public Integer getDigitalAssetId() {
        return this.digitalAssetId;
    }

    public void setDigitalAssetId(Integer digitalAssetId) {
        this.digitalAssetId = digitalAssetId;
    }

    public String getDigitalAssetKey() {
        return this.digitalAssetKey;
    }

    public boolean getIsUpdated() {
        return this.isUpdated;
    }

    public Integer getContentVersionId() {
        return this.contentVersionId;
    }

    public void setContentVersionId(Integer contentVersionId) {
        this.contentVersionId = contentVersionId;
    }

    public String getCloseOnLoad() {
        return this.closeOnLoad;
    }

    public void setCloseOnLoad(String closeOnLoad) {
        this.closeOnLoad = closeOnLoad;
    }

    public String getModifiedFileUrl() {
        return this.modifiedFileUrl;
    }

    public int getXpos1() {
        return this.xpos1;
    }

    public void setXpos1(int xpos1) {
        this.xpos1 = xpos1;
    }

    public int getXpos2() {
        return this.xpos2;
    }

    public void setXpos2(int xpos2) {
        this.xpos2 = xpos2;
    }

    public int getYpos1() {
        return this.ypos1;
    }

    public void setYpos1(int ypos1) {
        this.ypos1 = ypos1;
    }

    public int getYpos2() {
        return this.ypos2;
    }

    public void setYpos2(int ypos2) {
        this.ypos2 = ypos2;
    }

    public String getWorkingFileName() {
        return this.workingFileName;
    }

    public void setWorkingFileName(String workingFileName) {
        this.workingFileName = workingFileName;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setKeepRatio(String keepRatio) {
        this.keepRatio = keepRatio;
    }

    public void setBestFit(String bestFit) {
        this.bestFit = bestFit;
    }
}

