/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Marshaller;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.management.impl.simple.InfoGlueExportImpl;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.handlers.DigitalAssetBytesHandler;

public class ExportContentAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ExportContentAction.class.getName());
    private Integer repositoryId = null;
    private Integer contentId = null;
    private List contents = new ArrayList();
    private String fileUrl = "";
    private String fileName = "";
    private int assetMaxSize = -1;

    public String doInput() throws Exception {
        return "input";
    }

    protected String doExecute() throws Exception {
        if (!AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), "ContentTool.ImportExport", true)) {
            throw new SystemException("You are not allowed to export contents.");
        }
        Database db = CastorDatabaseService.getDatabase();
        try {
            try {
                Mapping map = new Mapping();
                String exportFormat = CmsPropertyHandler.getExportFormat();
                logger.info((Object)("MappingFile:" + CastorDatabaseService.class.getResource("/xml_mapping_content_2.5.xml").toString()));
                map.loadMapping(CastorDatabaseService.class.getResource("/xml_mapping_content_2.5.xml").toString());
                db.begin();
                ArrayList<Content> contents = new ArrayList<Content>();
                String[] contentIds = this.getRequest().getParameterValues("contentId");
                int i = 0;
                while (i < contentIds.length) {
                    Integer contentId = new Integer(contentIds[i]);
                    Content content = ContentController.getContentController().getContentWithId(contentId, db);
                    contents.add(content);
                    ++i;
                }
                List contentTypeDefinitions = ContentTypeDefinitionController.getController().getContentTypeDefinitionList(db);
                List categories = CategoryController.getController().findAllActiveCategories();
                InfoGlueExportImpl infoGlueExportImpl = new InfoGlueExportImpl();
                VisualFormatter visualFormatter = new VisualFormatter();
                String fileName = "Export_contents_" + visualFormatter.formatDate(new Date(), "yyyy-MM-dd") + ".xml";
                String filePath = CmsPropertyHandler.getDigitalAssetPath();
                String fileSystemName = String.valueOf(filePath) + File.separator + fileName;
                this.fileUrl = String.valueOf(CmsPropertyHandler.getWebServerAddress()) + "/" + CmsPropertyHandler.getDigitalAssetBaseUrl() + "/" + fileName;
                this.fileName = fileName;
                String encoding = "UTF-8";
                File file = new File(fileSystemName);
                FileOutputStream fos = new FileOutputStream(file);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, encoding);
                Marshaller marshaller = new Marshaller((Writer)osw);
                marshaller.setMapping(map);
                marshaller.setEncoding(encoding);
                DigitalAssetBytesHandler.setMaxSize(this.assetMaxSize);
                infoGlueExportImpl.getRootContent().addAll(contents);
                infoGlueExportImpl.setContentTypeDefinitions(contentTypeDefinitions);
                infoGlueExportImpl.setCategories(categories);
                marshaller.marshal((Object)infoGlueExportImpl);
                osw.flush();
                osw.close();
                db.rollback();
            }
            catch (Exception e) {
                logger.error((Object)("An error was found exporting a repository: " + e.getMessage()), (Throwable)e);
                db.rollback();
                db.close();
            }
        }
        finally {
            db.close();
        }
        return "success";
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public void setContentId(Integer contentId) {
        this.contentId = contentId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public Integer getContentId() {
        return this.contentId;
    }

    public List getContents() {
        return this.contents;
    }

    public int getAssetMaxSize() {
        return this.assetMaxSize;
    }

    public void setAssetMaxSize(int assetMaxSize) {
        this.assetMaxSize = assetMaxSize;
    }
}

