/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.InconsistenciesController;
import org.infoglue.cms.controllers.kernel.impl.simple.RegistryController;
import org.infoglue.cms.entities.content.ContentVO;

public class DeleteContentChildrenAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)DeleteContentChildrenAction.class.getName());
    private static final long serialVersionUID = 1L;
    private ContentVO contentVO;
    private Integer parentContentId;
    private Integer changeTypeId;
    private String[] registryId;
    private Integer siteNodeId;
    private List referenceBeanList = new ArrayList();

    public DeleteContentChildrenAction() {
        this(new ContentVO());
    }

    public DeleteContentChildrenAction(ContentVO contentVO) {
        this.contentVO = contentVO;
    }

    public String doExecute() throws Exception {
        List children = ContentController.getContentController().getContentChildrenVOList(this.contentVO.getContentId());
        for (ContentVO childContentVO : children) {
            this.referenceBeanList = RegistryController.getController().getReferencingObjectsForContent(childContentVO.getContentId());
            if (this.referenceBeanList != null && this.referenceBeanList.size() > 0) {
                return "showRelations";
            }
            try {
                this.parentContentId = ContentController.getParentContent(childContentVO.getContentId()).getContentId();
            }
            catch (Exception e) {
                logger.info((Object)"The content must have been a root-content because we could not find a parent.");
            }
            ContentControllerProxy.getController().acDelete(this.getInfoGluePrincipal(), childContentVO);
        }
        return "success";
    }

    public String doDeleteReference() throws Exception {
        int i = 0;
        while (i < this.registryId.length) {
            try {
                InconsistenciesController.getController().removeReferences(new Integer(this.registryId[i]), this.getInfoGluePrincipal());
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred when we tried to delete references: " + e.getMessage()));
            }
            try {
                RegistryController.getController().delete(new Integer(this.registryId[i]));
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred when we tried to delete references: " + e.getMessage()));
            }
            ++i;
        }
        return this.doExecute();
    }

    public String doFixPage() throws Exception {
        return "fixPage";
    }

    public String doFixPageHeader() throws Exception {
        return "fixPageHeader";
    }

    public void setContentId(Integer contentId) {
        this.contentVO.setContentId(contentId);
    }

    public void setParentContentId(Integer parentContentId) {
        this.parentContentId = parentContentId;
    }

    public void setChangeTypeId(Integer changeTypeId) {
        this.changeTypeId = changeTypeId;
    }

    public Integer getContentId() {
        return this.parentContentId;
    }

    public Integer getOriginalContentId() {
        return this.contentVO.getContentId();
    }

    public Integer getUnrefreshedContentId() {
        return this.parentContentId;
    }

    public Integer getChangeTypeId() {
        return this.changeTypeId;
    }

    public String getErrorKey() {
        return "ContentVersion.stateId";
    }

    public String getReturnAddress() {
        return "ViewContent.action?contentId=" + this.contentVO.getId() + "&repositoryId=" + this.contentVO.getRepositoryId();
    }

    public List getReferenceBeanList() {
        return this.referenceBeanList;
    }

    public Integer getSiteNodeId() {
        return this.siteNodeId;
    }

    public void setSiteNodeId(Integer siteNodeId) {
        this.siteNodeId = siteNodeId;
    }

    public String[] getRegistryId() {
        return this.registryId;
    }

    public void setRegistryId(String[] registryId) {
        this.registryId = registryId;
    }
}

