/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import com.mullassery.imaging.Imaging;
import com.mullassery.imaging.ImagingFactory;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.contenttool.actions.ViewDigitalAssetAction;
import org.infoglue.cms.applications.databeans.AssetKeyDefinition;
import org.infoglue.cms.applications.databeans.SessionInfoBean;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupPropertiesController;
import org.infoglue.cms.controllers.kernel.impl.simple.RolePropertiesController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserPropertiesController;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.GroupProperties;
import org.infoglue.cms.entities.management.RoleProperties;
import org.infoglue.cms.entities.management.UserProperties;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.CmsSessionContextListener;
import org.infoglue.cms.util.dom.DOMBuilder;
import webwork.action.ActionContext;

public class CreateDigitalAssetAction
extends ViewDigitalAssetAction {
    private static final Logger logger = Logger.getLogger((String)CreateDigitalAssetAction.class.getName());
    private static final long serialVersionUID = 1L;
    private String entity;
    private Integer entityId;
    private Integer contentVersionId = null;
    private String digitalAssetKey = "";
    private Integer uploadedFilesCounter = new Integer(0);
    private ContentVersionVO contentVersionVO;
    private ContentTypeDefinitionVO contentTypeDefinitionVO;
    private String reasonKey;
    private String uploadMaxSize;
    private DigitalAssetVO digitalAssetVO = null;
    private String closeOnLoad;
    private Integer contentTypeDefinitionId;
    private String returnAddress = "";
    private InfoGluePrincipal principal = null;
    private boolean useFileNameAsContentTypeBase = false;
    private VisualFormatter formatter = new VisualFormatter();
    private Imaging imaging = ImagingFactory.createImagingInstance((int)4, (int)3);

    public void setContentVersionId(Integer contentVersionId) {
        this.contentVersionId = contentVersionId;
    }

    public Integer getContentVersionId() {
        return this.contentVersionId;
    }

    public void setDigitalAssetKey(String digitalAssetKey) {
        this.digitalAssetKey = digitalAssetKey;
    }

    public String getDigitalAssetKey() {
        return this.digitalAssetKey;
    }

    public void setUploadedFilesCounter(Integer uploadedFilesCounter) {
        this.uploadedFilesCounter = uploadedFilesCounter;
    }

    public Integer getUploadedFilesCounter() {
        return this.uploadedFilesCounter;
    }

    public List getDefinedAssetKeys() {
        return ContentTypeDefinitionController.getController().getDefinedAssetKeys(this.contentTypeDefinitionVO.getSchemaValue());
    }

    public String doMultiple() throws Exception {
        logger.info((Object)"Uploading file....");
        this.principal = this.getInfoGluePrincipal();
        logger.info((Object)("QueryString:" + this.getRequest().getQueryString()));
        String requestSessionId = this.getRequest().getParameter("JSESSIONID");
        logger.info((Object)("JSESSIONID:" + requestSessionId));
        boolean allowedSessionId = false;
        List activeSessionBeanList = CmsSessionContextListener.getSessionInfoBeanList();
        Iterator activeSessionsIterator = activeSessionBeanList.iterator();
        logger.info((Object)("activeSessionBeanList:" + activeSessionBeanList.size()));
        while (activeSessionsIterator.hasNext()) {
            SessionInfoBean sessionBean = (SessionInfoBean)activeSessionsIterator.next();
            logger.info((Object)("sessionBean:" + sessionBean.getId() + "=" + sessionBean.getPrincipal().getName()));
            if (!sessionBean.getId().equals(requestSessionId)) continue;
            logger.info((Object)"Found a matching sessionId");
            allowedSessionId = true;
            this.principal = sessionBean.getPrincipal();
            break;
        }
        if (!allowedSessionId) {
            return "uploadFailed";
        }
        this.useFileNameAsContentTypeBase = true;
        String result = this.doExecute();
        if (result.equals("success")) {
            String assetUrl = this.getDigitalAssetUrl();
            logger.info((Object)("assetUrl:" + assetUrl));
            String assetThumbnailUrl = this.getAssetThumbnailUrl();
            logger.info((Object)("assetThumbnailUrl:" + assetThumbnailUrl));
            this.getResponse().setContentType("text/plain");
            this.getResponse().getWriter().println(String.valueOf(assetThumbnailUrl) + ":" + this.digitalAssetKey);
            return "none";
        }
        this.getResponse().setContentType("text/plain");
        HttpServletResponse httpServletResponse = this.getResponse();
        this.getResponse();
        httpServletResponse.setStatus(500);
        this.getResponse().getWriter().println("Error uploading to " + this.digitalAssetKey);
        return "none";
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String doExecute() throws IOException {
        block61: {
            CreateDigitalAssetAction.logger.info((Object)"Uploading file....");
            if (this.principal == null) {
                this.principal = this.getInfoGluePrincipal();
            }
            try {
                block59: {
                    block57: {
                        mpr = ActionContext.getMultiPartRequest();
                        if (mpr == null) {
                            this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnSizeText";
                            this.uploadMaxSize = "(Max " + this.formatter.formatFileSize(this.getUploadMaxSize()) + " - system wide)";
                            return "uploadFailed";
                        }
                        if (this.contentVersionId != null) {
                            this.contentVersionVO = ContentVersionController.getContentVersionController().getContentVersionVOWithId(this.contentVersionId);
                            this.contentTypeDefinitionVO = ContentController.getContentController().getContentTypeDefinition(this.contentVersionVO.getContentId());
                        } else if (this.entity.equalsIgnoreCase(UserProperties.class.getName())) {
                            userPropertiesVO = UserPropertiesController.getController().getUserPropertiesVOWithId(this.entityId);
                            this.contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithId(userPropertiesVO.getContentTypeDefinitionId());
                        } else if (this.entity.equalsIgnoreCase(RoleProperties.class.getName())) {
                            rolePropertiesVO = RolePropertiesController.getController().getRolePropertiesVOWithId(this.entityId);
                            this.contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithId(rolePropertiesVO.getContentTypeDefinitionId());
                        } else if (this.entity.equalsIgnoreCase(GroupProperties.class.getName())) {
                            groupPropertiesVO = GroupPropertiesController.getController().getGroupPropertiesVOWithId(this.entityId);
                            this.contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithId(groupPropertiesVO.getContentTypeDefinitionId());
                        }
                        is = null;
                        file = null;
                        if (mpr == null) break block57;
                        names = mpr.getFileNames();
                        while (names.hasMoreElements()) {
                            name = (String)names.nextElement();
                            contentType = mpr.getContentType(name);
                            fileSystemName = mpr.getFilesystemName(name);
                            fromEncoding = CmsPropertyHandler.getUploadFromEncoding();
                            if (fromEncoding == null) {
                                fromEncoding = "iso-8859-1";
                            }
                            if ((toEncoding = CmsPropertyHandler.getUploadToEncoding()) == null) {
                                toEncoding = "utf-8";
                            }
                            this.digitalAssetKey = new String(this.digitalAssetKey.getBytes(fromEncoding), toEncoding);
                            CreateDigitalAssetAction.logger.info((Object)("digitalAssetKey:" + this.digitalAssetKey));
                            CreateDigitalAssetAction.logger.info((Object)("name:" + name));
                            CreateDigitalAssetAction.logger.info((Object)("contentType:" + contentType));
                            CreateDigitalAssetAction.logger.info((Object)("fileSystemName:" + fileSystemName));
                            if (this.digitalAssetKey == null || this.digitalAssetKey.equals("")) {
                                if (fileSystemName.lastIndexOf(".") > -1) {
                                    this.digitalAssetKey = fileSystemName.substring(0, fileSystemName.lastIndexOf("."));
                                }
                                this.digitalAssetKey = this.formatter.replaceNonAscii(this.digitalAssetKey, '_');
                            }
                            CreateDigitalAssetAction.logger.info((Object)("digitalAssetKey:" + this.digitalAssetKey));
                            if (this.useFileNameAsContentTypeBase && fileSystemName.lastIndexOf(".") > -1) {
                                extension = fileSystemName.substring(fileSystemName.lastIndexOf(".") + 1);
                                CreateDigitalAssetAction.logger.info((Object)("extension:" + extension));
                                if (extension.equalsIgnoreCase("gif")) {
                                    contentType = "image/gif";
                                } else if (extension.equalsIgnoreCase("jpg")) {
                                    contentType = "image/jpg";
                                } else if (extension.equalsIgnoreCase("png")) {
                                    contentType = "image/png";
                                } else if (extension.equalsIgnoreCase("pdf")) {
                                    contentType = "application/pdf";
                                } else if (extension.equalsIgnoreCase("doc")) {
                                    contentType = "application/msword";
                                } else if (extension.equalsIgnoreCase("xls")) {
                                    contentType = "application/vnd.ms-excel";
                                } else if (extension.equalsIgnoreCase("ppt")) {
                                    contentType = "application/vnd.ms-powerpoint";
                                } else if (extension.equalsIgnoreCase("zip")) {
                                    contentType = "application/zip";
                                } else if (extension.equalsIgnoreCase("xml")) {
                                    contentType = "text/xml";
                                }
                            }
                            CreateDigitalAssetAction.logger.info((Object)("contentType:" + contentType));
                            file = mpr.getFile(name);
                            fileName = fileSystemName;
                            CreateDigitalAssetAction.logger.info((Object)("fileSystemName:" + fileSystemName));
                            fileName = new VisualFormatter().replaceNonAscii(fileName, '_');
                            tempFileName = "tmp_" + System.currentTimeMillis() + "_" + fileName;
                            filePath = CmsPropertyHandler.getDigitalAssetPath();
                            fileSystemName = String.valueOf(filePath) + File.separator + tempFileName;
                            newAsset = new DigitalAssetVO();
                            newAsset.setAssetContentType(contentType);
                            newAsset.setAssetKey(this.digitalAssetKey);
                            newAsset.setAssetFileName(fileName);
                            newAsset.setAssetFilePath(filePath);
                            newAsset.setAssetFileSize(new Integer(new Long(file.length()).intValue()));
                            if (CmsPropertyHandler.getEnableDiskAssets().equals("false")) {
                                is = new FileInputStream(file);
                            }
                            existingAssetVOList = DigitalAssetController.getDigitalAssetVOList(this.contentVersionId);
                            existingAssetVOListIterator = existingAssetVOList.iterator();
                            break block58;
                            while (true) {
                                existingDigitalAssetVO = (DigitalAssetVO)existingAssetVOListIterator.next();
                                if (!existingDigitalAssetVO.getAssetKey().equalsIgnoreCase(this.digitalAssetKey)) break block58;
                                file.delete();
                                this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnAssetKeyExistingText";
                                this.uploadMaxSize = "\"" + this.digitalAssetKey + "\"";
                                this.getResponse().setContentType("text/html; charset=UTF-8");
                                CreateDigitalAssetAction.logger.info((Object)("this.getResponse():" + this.getResponse()));
                                this.getResponse().setHeader("sendIGError", "true");
                                break;
                            }
                        }
                        break block59;
lbl-1000:
                        // 10 sources

                        {
                            block62: {
                                block69: {
                                    block68: {
                                        block65: {
                                            block67: {
                                                block66: {
                                                    block64: {
                                                        block63: {
                                                            block60: {
                                                                block58: {
                                                                    while (true) {
                                                                        try {
                                                                            if (CmsPropertyHandler.getEnableDiskAssets().equals("false") == false) return "uploadFailed";
                                                                            is.close();
                                                                            file.delete();
                                                                            return "uploadFailed";
                                                                        }
                                                                        catch (Throwable e) {
                                                                            CreateDigitalAssetAction.logger.error((Object)("An error occurred when we tried to close the fileinput stream and delete the file:" + e.getMessage()), e);
                                                                        }
                                                                        return "uploadFailed";
                                                                    }
                                                                }
                                                                try {
                                                                    try {
                                                                        if (existingAssetVOListIterator.hasNext()) ** continue;
                                                                        fileUploadMaximumSize = this.getPrincipalPropertyValue(this.principal, "fileUploadMaximumSize", false, true);
                                                                        CreateDigitalAssetAction.logger.info((Object)("fileUploadMaximumSize in create:" + fileUploadMaximumSize));
                                                                        if (fileUploadMaximumSize.equalsIgnoreCase("-1") || new Integer(fileUploadMaximumSize) >= new Long(file.length()).intValue()) break block60;
                                                                        file.delete();
                                                                        this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnSizeText";
                                                                        this.uploadMaxSize = "(Max " + this.formatter.formatFileSize(fileUploadMaximumSize) + ")";
                                                                        ** GOTO lbl-1000
                                                                    }
                                                                    catch (Throwable e) {
                                                                        CreateDigitalAssetAction.logger.error((Object)("An error occurred when we tried to upload a new asset:" + e.getMessage()), e);
                                                                        try {
                                                                            if (CmsPropertyHandler.getEnableDiskAssets().equals("false")) {
                                                                                is.close();
                                                                                file.delete();
                                                                            }
                                                                            break block61;
                                                                        }
                                                                        catch (Throwable e) {
                                                                            CreateDigitalAssetAction.logger.error((Object)("An error occurred when we tried to close the fileinput stream and delete the file:" + e.getMessage()), e);
                                                                        }
                                                                        break block61;
                                                                    }
                                                                }
                                                                catch (Throwable var24_33) {
                                                                    try {
                                                                        if (CmsPropertyHandler.getEnableDiskAssets().equals("false") == false) throw var24_33;
                                                                        is.close();
                                                                        file.delete();
                                                                        throw var24_33;
                                                                    }
                                                                    catch (Throwable e) {
                                                                        CreateDigitalAssetAction.logger.error((Object)("An error occurred when we tried to close the fileinput stream and delete the file:" + e.getMessage()), e);
                                                                    }
                                                                    throw var24_33;
                                                                }
                                                            }
                                                            if (this.contentTypeDefinitionId == null || this.digitalAssetKey == null) break block62;
                                                            this.contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithId(this.contentTypeDefinitionId);
                                                            assetKeyDefinition = ContentTypeDefinitionController.getController().getDefinedAssetKey(this.contentTypeDefinitionVO.getSchemaValue(), this.digitalAssetKey);
                                                            if (assetKeyDefinition == null) break block62;
                                                            if (assetKeyDefinition.getMaximumSize() >= new Long(file.length()).intValue()) break block63;
                                                            file.delete();
                                                            this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnSizeText";
                                                            this.uploadMaxSize = "(Max " + this.formatter.formatFileSize(assetKeyDefinition.getMaximumSize()) + ")";
                                                            ** GOTO lbl-1000
                                                        }
                                                        if (!assetKeyDefinition.getAllowedContentTypes().startsWith("image")) break block62;
                                                        if (contentType.startsWith("image")) break block64;
                                                        file.delete();
                                                        this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnTypeNotImageText";
                                                        ** GOTO lbl-1000
                                                    }
                                                    image = ImageIO.read(file);
                                                    width = image.getWidth(null);
                                                    height = image.getHeight(null);
                                                    allowedWidth = assetKeyDefinition.getImageWidth();
                                                    allowedHeight = assetKeyDefinition.getImageHeight();
                                                    if (allowedWidth.equals("*")) break block65;
                                                    allowedWidthNumber = new Integer(allowedWidth.substring(1));
                                                    if (!allowedWidth.startsWith("<") || width < allowedWidthNumber) break block66;
                                                    file.delete();
                                                    this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnImageToWideText";
                                                    ** GOTO lbl-1000
                                                }
                                                if (!allowedWidth.startsWith(">") || width > allowedWidthNumber) break block67;
                                                file.delete();
                                                this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnImageNotWideEnoughText";
                                                ** GOTO lbl-1000
                                            }
                                            if (allowedWidth.startsWith(">") || allowedWidth.startsWith("<") || width == new Integer(allowedWidth)) break block65;
                                            file.delete();
                                            this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnImageWrongWidthText";
                                            ** GOTO lbl-1000
                                        }
                                        if (allowedHeight.equals("*")) break block62;
                                        allowedHeightNumber = new Integer(allowedHeight.substring(1));
                                        if (!allowedHeight.startsWith("<") || height < allowedHeightNumber) break block68;
                                        file.delete();
                                        this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnImageToHighText";
                                        ** GOTO lbl-1000
                                    }
                                    if (!allowedHeight.startsWith(">") || height > allowedHeightNumber) break block69;
                                    file.delete();
                                    this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnImageNotHighEnoughText";
                                    ** GOTO lbl-1000
                                }
                                if (!allowedHeight.startsWith(">") && !allowedHeight.startsWith("<") && height != new Integer(allowedHeight)) {
                                    file.delete();
                                    this.reasonKey = "tool.contenttool.fileUpload.fileUploadFailedOnImageWrongHeightText";
                                    ** continue;
                                }
                            }
                            keepOriginal = true;
                            if (this.contentVersionId != null) {
                                assetKeyDefinition = ContentTypeDefinitionController.getController().getDefinedAssetKey(this.contentTypeDefinitionVO.getSchemaValue(), this.digitalAssetKey);
                                keepOriginal = this.handleTransformations(newAsset, file, contentType, assetKeyDefinition);
                                if (keepOriginal) {
                                    this.digitalAssetVO = DigitalAssetController.create(newAsset, is, this.contentVersionId, this.getInfoGluePrincipal());
                                }
                            } else {
                                this.digitalAssetVO = DigitalAssetController.create(newAsset, is, this.entity, this.entityId);
                            }
                            if (CmsPropertyHandler.getEnableDiskAssets().equals("true") && keepOriginal) {
                                folderName = "" + this.digitalAssetVO.getDigitalAssetId() / 1000;
                                assetFileName = this.digitalAssetVO.getAssetFilePath() + File.separator + folderName + File.separator + this.digitalAssetVO.getId() + "_" + this.digitalAssetVO.getAssetFileName();
                                assetFile = new File(assetFileName);
                                file.renameTo(assetFile);
                            }
                            this.uploadedFilesCounter = new Integer(this.uploadedFilesCounter + 1);
                            continue;
                            break;
                        }
                    }
                    CreateDigitalAssetAction.logger.error((Object)"File upload failed for some reason.");
                }
                try {
                    if (CmsPropertyHandler.getEnableDiskAssets().equals("false")) {
                        is.close();
                        file.delete();
                    }
                }
                catch (Throwable e) {
                    CreateDigitalAssetAction.logger.error((Object)("An error occurred when we tried to close the fileinput stream and delete the file:" + e.getMessage()), e);
                }
            }
            catch (Throwable e) {
                CreateDigitalAssetAction.logger.error((Object)("An error occurred when we tried to upload a new asset:" + e.getMessage()), e);
            }
        }
        if (this.returnAddress == null) return "success";
        if (this.returnAddress.equals("") != false) return "success";
        this.getResponse().sendRedirect(this.returnAddress);
        return "none";
    }

    private boolean handleTransformations(DigitalAssetVO originalAssetVO, File file, String contentType, AssetKeyDefinition assetKeyDefinition) {
        boolean keepOriginal = true;
        try {
            String transformationsXML = null;
            if (assetKeyDefinition != null) {
                transformationsXML = assetKeyDefinition.getAssetUploadTransformationsSettings();
            }
            if (transformationsXML == null || transformationsXML.equals("")) {
                transformationsXML = CmsPropertyHandler.getAssetUploadTransformationsSettings();
            }
            if (transformationsXML == null || transformationsXML.equals("") || transformationsXML.equals("none")) {
                return keepOriginal;
            }
            DOMBuilder domBuilder = new DOMBuilder();
            Document document = domBuilder.getDocument(transformationsXML);
            Element rootElement = document.getRootElement();
            String transformationXPath = "//transformation";
            List transformationElements = rootElement.selectNodes(transformationXPath);
            logger.info((Object)("transformationElements:" + transformationElements.size()));
            for (Element transformationElement : transformationElements) {
                String assetKeyPattern = transformationElement.attributeValue("assetKeyPattern");
                String inputFilePattern = transformationElement.attributeValue("inputFilePattern");
                logger.info((Object)("inputFilePattern: " + inputFilePattern));
                boolean assetKeyMatch = false;
                if (assetKeyPattern == null || assetKeyPattern.equals("")) {
                    assetKeyMatch = true;
                } else if (originalAssetVO.getAssetKey().matches(assetKeyPattern)) {
                    assetKeyMatch = true;
                }
                if (assetKeyMatch && contentType.matches(inputFilePattern)) {
                    logger.info((Object)("We got a match on contentType:" + contentType + " : " + inputFilePattern));
                    String keepOriginalAsset = transformationElement.attributeValue("keepOriginal");
                    if (keepOriginalAsset != null && keepOriginalAsset.equalsIgnoreCase("false")) {
                        keepOriginal = false;
                    }
                    logger.info((Object)("keepOriginal:" + keepOriginal));
                    List tranformResultElements = transformationElement.elements("tranformResult");
                    for (Element tranformResultElement : tranformResultElements) {
                        String type = tranformResultElement.attributeValue("type");
                        String width = tranformResultElement.attributeValue("width");
                        String height = tranformResultElement.attributeValue("height");
                        String outputFormat = tranformResultElement.attributeValue("outputFormat");
                        String assetSuffix = tranformResultElement.attributeValue("assetSuffix");
                        logger.info((Object)("type: " + type));
                        logger.info((Object)("width: " + width));
                        logger.info((Object)("height: " + height));
                        logger.info((Object)("outputFormat: " + outputFormat));
                        logger.info((Object)("assetSuffix: " + assetSuffix));
                        if (!type.equalsIgnoreCase("scaleImage")) continue;
                        this.scaleAndSaveImage(originalAssetVO, file, Integer.parseInt(width), Integer.parseInt(height), outputFormat, assetSuffix);
                    }
                    continue;
                }
                logger.info((Object)("NOOOO match on contentType:" + contentType + " : " + inputFilePattern));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return keepOriginal;
    }

    private void scaleAndSaveImage(DigitalAssetVO originalAssetVO, File file, int width, int height, String outputFormat, String assetSuffix) throws Exception {
        logger.info((Object)("Scaling image to new format:" + originalAssetVO + ":" + outputFormat));
        BufferedImage original = ImageIO.read(file);
        int originalWidth = original.getWidth();
        int originalHeight = original.getHeight();
        float aspect = (float)originalWidth / (float)originalHeight;
        BufferedImage image = null;
        aspect = height == -1 && width != -1 ? (float)width / (float)originalWidth : (width == -1 && height != -1 ? (float)height / (float)originalHeight : (float)width / (float)originalWidth);
        logger.info((Object)("aspect:" + aspect));
        image = this.imaging.scale(original, aspect);
        String workingFileName = originalAssetVO.getDigitalAssetId() + "_" + assetSuffix + "." + outputFormat.toLowerCase();
        long timeStamp = System.currentTimeMillis();
        if (originalAssetVO.getDigitalAssetId() == null) {
            workingFileName = timeStamp + "_" + assetSuffix + "." + outputFormat.toLowerCase();
        }
        File outputFile = new File(String.valueOf(CmsPropertyHandler.getDigitalAssetPath()) + File.separator + File.separator + workingFileName);
        ImageIO.write((RenderedImage)image, outputFormat, outputFile);
        String assetContentType = "image/png";
        if (outputFormat.equalsIgnoreCase("gif")) {
            assetContentType = "image/gif";
        }
        if (outputFormat.equalsIgnoreCase("jpg")) {
            assetContentType = "image/jpeg";
        }
        DigitalAssetVO digitalAssetVO = new DigitalAssetVO();
        digitalAssetVO.setAssetContentType(assetContentType);
        digitalAssetVO.setAssetFileName(outputFile.getName());
        digitalAssetVO.setAssetFilePath(outputFile.getPath());
        digitalAssetVO.setAssetFileSize(new Integer((int)outputFile.length()));
        digitalAssetVO.setAssetKey(String.valueOf(originalAssetVO.getAssetKey()) + "_" + assetSuffix);
        FileInputStream is = new FileInputStream(outputFile);
        this.digitalAssetVO = DigitalAssetController.create(digitalAssetVO, (InputStream)is, this.contentVersionId, this.getInfoGluePrincipal());
        ((InputStream)is).close();
        String folderName = "" + this.digitalAssetVO.getId() / 1000;
        String newWorkingFileName = this.digitalAssetVO.getId() + "_" + timeStamp + "_" + assetSuffix + "." + outputFormat.toLowerCase();
        File finalOutputFile = new File(String.valueOf(CmsPropertyHandler.getDigitalAssetPath()) + File.separator + folderName + File.separator + newWorkingFileName);
        outputFile.renameTo(finalOutputFile);
    }

    public String getDigitalAssetUrl() throws Exception {
        String imageHref = null;
        try {
            imageHref = DigitalAssetController.getDigitalAssetUrl(this.digitalAssetVO.getDigitalAssetId());
        }
        catch (Exception e) {
            logger.warn((Object)("We could not get the url of the digitalAsset: " + e.getMessage()), (Throwable)e);
        }
        return imageHref;
    }

    public String getAssetThumbnailUrl() {
        String imageHref = null;
        try {
            imageHref = DigitalAssetController.getDigitalAssetThumbnailUrl(this.digitalAssetVO.getDigitalAssetId());
        }
        catch (Exception e) {
            logger.warn((Object)("We could not get the url of the thumbnail: " + e.getMessage()), (Throwable)e);
        }
        return imageHref;
    }

    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public Integer getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Integer entityId) {
        this.entityId = entityId;
    }

    public String getReasonKey() {
        return this.reasonKey;
    }

    public String getCloseOnLoad() {
        return this.closeOnLoad;
    }

    public void setCloseOnLoad(String closeOnLoad) {
        this.closeOnLoad = closeOnLoad;
    }

    public Integer getContentTypeDefinitionId() {
        return this.contentTypeDefinitionId;
    }

    public void setContentTypeDefinitionId(Integer contentTypeDefinitionId) {
        this.contentTypeDefinitionId = contentTypeDefinitionId;
    }

    public ContentTypeDefinitionVO getContentTypeDefinitionVO() {
        return this.contentTypeDefinitionVO;
    }

    public void setReturnAddress(String returnAddress) {
        this.returnAddress = returnAddress;
    }

    public String getUploadErrorMaxSize() {
        return this.uploadMaxSize;
    }
}

