/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.exception.AccessConstraintException;
import org.infoglue.cms.util.AccessConstraintExceptionBuffer;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.sorters.ReflectionComparator;

public class CreateContentAction
extends InfoGlueAbstractAction {
    private static final long serialVersionUID = 1L;
    private Integer parentContentId;
    private Integer contentTypeDefinitionId;
    private Integer repositoryId;
    private ConstraintExceptionBuffer ceb;
    private ContentVO contentVO;
    private ContentVO newContentVO;
    private String defaultFolderContentTypeName;
    private String allowedContentTypeNames;
    private String defaultContentTypeName;

    public CreateContentAction() {
        this(new ContentVO());
    }

    public CreateContentAction(ContentVO contentVO) {
        this.contentVO = contentVO;
        this.ceb = new ConstraintExceptionBuffer();
    }

    public void setParentContentId(Integer parentContentId) {
        this.parentContentId = parentContentId;
    }

    public Integer getParentContentId() {
        return this.parentContentId;
    }

    public void setRepositoryId(Integer repositoryId) {
        this.repositoryId = repositoryId;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public void setContentTypeDefinitionId(Integer contentTypeDefinitionId) {
        this.contentTypeDefinitionId = contentTypeDefinitionId;
    }

    public Integer getContentTypeDefinitionId() {
        return this.contentTypeDefinitionId;
    }

    public String getName() {
        return this.contentVO.getName();
    }

    public String getPublishDateTime() {
        return new VisualFormatter().formatDate(this.contentVO.getPublishDateTime(), "yyyy-MM-dd HH:mm");
    }

    public String getExpireDateTime() {
        return new VisualFormatter().formatDate(this.contentVO.getExpireDateTime(), "yyyy-MM-dd HH:mm");
    }

    public long getPublishDateTimeAsLong() {
        return this.contentVO.getPublishDateTime().getTime();
    }

    public long getExpireDateTimeAsLong() {
        return this.contentVO.getExpireDateTime().getTime();
    }

    public Boolean getIsBranch() {
        return this.contentVO.getIsBranch();
    }

    public void setName(String name) {
        this.contentVO.setName(name);
    }

    public void setPublishDateTime(String publishDateTime) {
        this.contentVO.setPublishDateTime(new VisualFormatter().parseDate(publishDateTime, "yyyy-MM-dd HH:mm"));
    }

    public void setExpireDateTime(String expireDateTime) {
        this.contentVO.setExpireDateTime(new VisualFormatter().parseDate(expireDateTime, "yyyy-MM-dd HH:mm"));
    }

    public void setIsBranch(Boolean isBranch) {
        this.contentVO.setIsBranch(isBranch);
    }

    public Integer getContentId() {
        return this.newContentVO.getContentId();
    }

    public String getDefaultFolderContentTypeName() {
        return this.defaultFolderContentTypeName;
    }

    public List getContentTypeDefinitions() throws Exception {
        List contentTypeVOList = null;
        String protectContentTypes = CmsPropertyHandler.getProtectContentTypes();
        contentTypeVOList = protectContentTypes != null && protectContentTypes.equalsIgnoreCase("true") ? ContentTypeDefinitionController.getController().getAuthorizedContentTypeDefinitionVOList(this.getInfoGluePrincipal()) : ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList();
        Collections.sort(contentTypeVOList, new ReflectionComparator("name"));
        return contentTypeVOList;
    }

    public String doExecute() throws Exception {
        this.contentVO.setCreatorName(this.getInfoGluePrincipal().getName());
        this.ceb = this.contentVO.validate();
        this.ceb.throwIfNotEmpty();
        this.newContentVO = ContentControllerProxy.getController().acCreate(this.getInfoGluePrincipal(), this.parentContentId, this.contentTypeDefinitionId, this.repositoryId, this.contentVO);
        if (this.newContentVO.getIsBranch().booleanValue()) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("globalKey", "infoglue");
            PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
            String allowedContentTypeNames = ps.getString("content_" + this.getParentContentId() + "_allowedContentTypeNames");
            String defaultContentTypeName = ps.getString("content_" + this.getParentContentId() + "_defaultContentTypeName");
            String initialLanguageId = ps.getString("content_" + this.getParentContentId() + "_initialLanguageId");
            if (allowedContentTypeNames != null) {
                ps.setString("content_" + this.getContentId() + "_allowedContentTypeNames", allowedContentTypeNames);
            }
            if (defaultContentTypeName != null) {
                ps.setString("content_" + this.getContentId() + "_defaultContentTypeName", defaultContentTypeName);
            }
            if (initialLanguageId != null) {
                ps.setString("content_" + this.getContentId() + "_initialLanguageId", initialLanguageId);
            }
        }
        return "success";
    }

    public String doBindingView() throws Exception {
        this.doExecute();
        return "bindingView";
    }

    public String doTreeView() throws Exception {
        this.doExecute();
        return "treeView";
    }

    public String doInput() throws Exception {
        AccessConstraintExceptionBuffer ceb = new AccessConstraintExceptionBuffer();
        Integer protectedContentId = ContentControllerProxy.getController().getProtectedContentId(this.parentContentId);
        if (protectedContentId != null && !AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), "Content.Create", protectedContentId.toString())) {
            ceb.add(new AccessConstraintException("Content.contentId", "1002"));
        }
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
        if (this.getIsBranch().booleanValue()) {
            this.defaultFolderContentTypeName = ps.getString("repository_" + this.getRepositoryId() + "_defaultFolderContentTypeName");
        } else {
            this.defaultContentTypeName = ps.getString("content_" + this.parentContentId + "_defaultContentTypeName");
        }
        if (ps.exists("content_" + this.parentContentId + "_allowedContentTypeNames")) {
            this.allowedContentTypeNames = ps.getString("content_" + this.parentContentId + "_allowedContentTypeNames");
        }
        ceb.throwIfNotEmpty();
        return "input";
    }

    public String getAllowedContentTypeNames() {
        return this.allowedContentTypeNames;
    }

    public String getDefaultContentTypeName() {
        return this.defaultContentTypeName;
    }
}

