/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.contenttool.actions;

import com.frovi.ss.Tree.BaseNode;
import com.frovi.ss.Tree.INodeSupplier;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.TransactionHistoryController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.impl.simple.ContentVersionImpl;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.RepositoryVO;
import org.infoglue.cms.entities.management.TransactionHistoryVO;
import org.infoglue.cms.entities.management.impl.simple.ContentTypeDefinitionImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.treeservice.ss.ContentNodeSupplier;

public class ContentTreeXMLAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)ContentTreeXMLAction.class.getName());
    private static final long serialVersionUID = 3321168219082615063L;
    private static String TYPE_FOLDER = "ContentFolder";
    private static String TYPE_ITEM = "ContentItem";
    private static String TYPE_REPOSITORY = "Repository";
    private String showLeafs = "yes";
    private Integer parent = null;
    private Integer repositoryId = null;
    private String urlArgSeparator = "&";
    private String action = "";
    private boolean createAction = false;
    private boolean useTemplate = false;
    private String[] allowedContentTypeIds = null;

    public INodeSupplier getNodeSupplier() throws SystemException {
        return new ContentNodeSupplier(this.getRepositoryId(), this.getInfoGluePrincipal());
    }

    public List getContentTypeDefinitions() throws Exception {
        return ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList();
    }

    private String makeAction(BaseNode node) throws UnsupportedEncodingException {
        String action = "javascript:onTreeItemClick(this,";
        action = String.valueOf(action) + "'" + node.getId() + "','" + this.repositoryId + "','" + URLEncoder.encode(node.getTitle(), "UTF-8") + "');";
        return action;
    }

    private String getFormattedDocument(Document doc) {
        return this.getFormattedDocument(doc, true);
    }

    private String getFormattedDocument(Document doc, boolean compact) {
        OutputFormat format = compact ? OutputFormat.createCompactFormat() : OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        format.setExpandEmptyElements(false);
        StringWriter stringWriter = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)stringWriter, format);
        try {
            writer.write(doc);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringWriter.toString();
    }

    public String doDigitalAssets() throws Exception {
        return null;
    }

    public String doLanguage() throws Exception {
        return null;
    }

    public ContentVersionVO getLatestContentVersionVO(Integer contentId, Integer languageId) {
        ContentVersionVO contentVersionVO = null;
        try {
            contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentId, languageId);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to get the latest version for the content:" + e.getMessage()), (Throwable)e);
        }
        return contentVersionVO;
    }

    public Element getContentVersionElement(Integer contentVersionId) throws SystemException, Bug, UnsupportedEncodingException {
        ContentVersionController contentVersionController = ContentVersionController.getContentVersionController();
        ContentVersionVO vo = contentVersionController.getContentVersionVOWithId(contentVersionId);
        return this.getContentVersionElement(vo);
    }

    public Element getContentVersionElement(ContentVersionVO vo) throws SystemException, Bug, UnsupportedEncodingException {
        Element element = DocumentHelper.createElement((String)"contentVersion");
        Element head = DocumentHelper.createElement((String)"head");
        Element value = DocumentHelper.createElement((String)"value");
        head.addAttribute("id", "" + vo.getContentVersionId());
        head.addAttribute("languageId", "" + vo.getLanguageId());
        head.addAttribute("languageName", vo.getLanguageName());
        head.addAttribute("isActive", "" + vo.getIsActive());
        TransactionHistoryController transactionHistoryController = TransactionHistoryController.getController();
        TransactionHistoryVO transactionHistoryVO = transactionHistoryController.getLatestTransactionHistoryVOForEntity(ContentVersionImpl.class, vo.getContentVersionId());
        if (transactionHistoryVO != null) {
            head.addAttribute("mod", this.formatDate(transactionHistoryVO.getTransactionDateTime()));
        }
        value.addCDATA(URLEncoder.encode(vo.getVersionValue(), "UTF-8"));
        element.add(head);
        element.add(value);
        return element;
    }

    public String doContentVersion() throws Exception {
        Document doc = DocumentHelper.createDocument();
        doc.add(this.getContentVersionElement(this.parent));
        return this.out(this.getFormattedDocument(doc));
    }

    public String doContentVersions() throws Exception {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("contentVersions");
        List availableLanguages = ContentController.getContentController().getRepositoryLanguages(this.parent);
        for (LanguageVO lvo : availableLanguages) {
            ContentVersionVO vo = this.getLatestContentVersionVO(this.parent, lvo.getLanguageId());
            if (vo == null) continue;
            root.add(this.getContentVersionElement(vo));
        }
        ContentVersionController contentVersionController = ContentVersionController.getContentVersionController();
        return this.out(this.getFormattedDocument(doc));
    }

    public String doContentTypeDefinitions() throws Exception {
        List contentTypeDefinitions = this.getContentTypeDefinitions();
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("definitions");
        TransactionHistoryController transactionHistoryController = TransactionHistoryController.getController();
        for (ContentTypeDefinitionVO vo : contentTypeDefinitions) {
            if (vo.getType().compareTo(ContentTypeDefinitionVO.CONTENT) != 0) continue;
            TransactionHistoryVO transactionHistoryVO = transactionHistoryController.getLatestTransactionHistoryVOForEntity(ContentTypeDefinitionImpl.class, vo.getContentTypeDefinitionId());
            Element definition = DocumentHelper.createElement((String)"definition");
            definition.addAttribute("id", "" + vo.getContentTypeDefinitionId()).addAttribute("type", "" + vo.getType()).addAttribute("name", vo.getName());
            if (transactionHistoryVO != null) {
                definition.addAttribute("mod", this.formatDate(transactionHistoryVO.getTransactionDateTime()));
            }
            Element schemaValue = definition.addElement("schemaValue");
            schemaValue.addCDATA(vo.getSchemaValue());
            root.add(definition);
        }
        return this.out(this.getFormattedDocument(doc));
    }

    private String formatDate(Date date) {
        return "" + date;
    }

    public String doExecute() throws Exception {
        if (this.useTemplate) {
            return "success";
        }
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("tree");
        if (this.repositoryId == null) {
            List repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), false);
            for (RepositoryVO r : repositories) {
                String allowedContentTypeIdsUrlEncodedString;
                ContentVO contentVO = ContentControllerProxy.getController().getRootContentVO(r.getId(), this.getInfoGluePrincipal().getName());
                String src = String.valueOf(this.action) + "?repositoryId=" + r.getId() + this.urlArgSeparator + "parent=" + contentVO.getId();
                if (this.createAction && src.length() > 0) {
                    src = String.valueOf(src) + this.urlArgSeparator + "createAction=true";
                }
                if (this.action.length() > 0 && src.length() > 0) {
                    src = String.valueOf(src) + this.urlArgSeparator + "action=" + this.action;
                }
                if ((allowedContentTypeIdsUrlEncodedString = this.getAllowedContentTypeIdsAsUrlEncodedString()).length() > 0 && src.length() > 0) {
                    src = String.valueOf(src) + this.urlArgSeparator + allowedContentTypeIdsUrlEncodedString;
                }
                String text = r.getName();
                Element element = root.addElement("tree");
                element.addAttribute("id", "" + r.getId()).addAttribute("repositoryId", "" + r.getId()).addAttribute("text", text).addAttribute("src", src).addAttribute("type", TYPE_REPOSITORY);
            }
            this.out(this.getFormattedDocument(doc));
            return null;
        }
        INodeSupplier sup = this.getNodeSupplier();
        ((ContentNodeSupplier)sup).setShowLeafs(this.showLeafs.compareTo("yes") == 0);
        ((ContentNodeSupplier)sup).setAllowedContentTypeIds(this.allowedContentTypeIds);
        if (this.parent == null) {
            String allowedContentTypeIdsUrlEncodedString;
            BaseNode node = sup.getRootNode();
            String text = node.getTitle();
            String type = TYPE_FOLDER;
            String src = String.valueOf(this.action) + "?repositoryId=" + this.repositoryId + this.urlArgSeparator + "parent=" + node.getId();
            if (this.createAction && src.length() > 0) {
                src = String.valueOf(src) + this.urlArgSeparator + "createAction=true";
            }
            if (this.action.length() > 0 && src.length() > 0) {
                src = String.valueOf(src) + this.urlArgSeparator + "action=" + this.action;
            }
            if ((allowedContentTypeIdsUrlEncodedString = this.getAllowedContentTypeIdsAsUrlEncodedString()).length() > 0 && src.length() > 0) {
                src = String.valueOf(src) + this.urlArgSeparator + allowedContentTypeIdsUrlEncodedString;
            }
            Element elm = root.addElement("tree");
            elm.addAttribute("id", "" + node.getId()).addAttribute("repositoryId", "" + this.repositoryId).addAttribute("text", text).addAttribute("src", src).addAttribute("type", type);
            this.out(this.getFormattedDocument(doc));
            return null;
        }
        if (this.parent > -1) {
            Collection containerNodes = sup.getChildContainerNodes(this.parent);
            Collection childNodes = sup.getChildLeafNodes(this.parent);
            ContentController contentController = ContentController.getContentController();
            ContentVersionController contentVersionController = ContentVersionController.getContentVersionController();
            for (BaseNode theNode : containerNodes) {
                String allowedContentTypeIdsUrlEncodedString;
                String src;
                if (theNode.isContainer() && sup.hasChildren()) {
                    theNode.setChildren(sup.hasChildren(theNode.getId()));
                }
                String string = src = theNode.hasChildren() ? String.valueOf(this.action) + "?repositoryId=" + this.repositoryId + this.urlArgSeparator + "parent=" + theNode.getId() : "";
                if (this.createAction && src.length() > 0) {
                    src = String.valueOf(src) + this.urlArgSeparator + "createAction=true";
                }
                if (this.createAction && src.length() > 0) {
                    src = String.valueOf(src) + this.urlArgSeparator + "showLeafs=" + this.showLeafs;
                }
                if (this.action.length() > 0 && src.length() > 0) {
                    src = String.valueOf(src) + this.urlArgSeparator + "action=" + this.action;
                }
                if ((allowedContentTypeIdsUrlEncodedString = this.getAllowedContentTypeIdsAsUrlEncodedString()).length() > 0 && src.length() > 0) {
                    src = String.valueOf(src) + this.urlArgSeparator + allowedContentTypeIdsUrlEncodedString;
                }
                Element elm = root.addElement("tree");
                elm.addAttribute("id", "" + theNode.getId()).addAttribute("parent", "" + this.parent).addAttribute("repositoryId", "" + this.repositoryId).addAttribute("text", theNode.getTitle()).addAttribute("src", src).addAttribute("type", TYPE_FOLDER);
                if (!this.createAction) continue;
                elm.addAttribute("action", this.makeAction(theNode));
            }
            for (BaseNode theNode : childNodes) {
                String text = theNode.getTitle();
                String action = this.makeAction(theNode);
                String type = TYPE_ITEM;
                Element elm = root.addElement("tree");
                elm.addAttribute("id", "" + theNode.getId()).addAttribute("parent", "" + this.parent).addAttribute("repositoryId", "" + this.repositoryId).addAttribute("text", text).addAttribute("type", type);
                if (this.createAction) {
                    elm.addAttribute("action", action);
                } else {
                    ContentVersionVO activeVersion = contentVersionController.getLatestActiveContentVersionVO(theNode.getId(), LanguageController.getController().getMasterLanguage(this.repositoryId).getLanguageId());
                    if (activeVersion != null && !this.useTemplate) {
                        elm.addAttribute("activeVersion", "" + activeVersion.getContentVersionId());
                    }
                }
                if (this.useTemplate) continue;
                elm.addAttribute("contentTypeId", "" + contentController.getContentTypeDefinition(theNode.getId()).getContentTypeDefinitionId());
            }
            this.out(this.getFormattedDocument(doc));
            return null;
        }
        return null;
    }

    private String out(String string) throws IOException {
        this.getResponse().setContentType("text/xml");
        this.getResponse().setContentLength(string.length());
        PrintWriter out = this.getResponse().getWriter();
        out.println(string);
        return null;
    }

    public Integer getParent() {
        return this.parent;
    }

    public void setParent(Integer integer) {
        this.parent = integer;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(Integer integer) {
        this.repositoryId = integer;
    }

    public boolean isCreateAction() {
        return this.createAction;
    }

    public void setCreateAction(boolean createAction) {
        this.createAction = createAction;
    }

    public boolean isUseTemplate() {
        return this.useTemplate;
    }

    public void setUseTemplate(boolean useTemplate) {
        this.useTemplate = useTemplate;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getShowLeafs() {
        return this.showLeafs;
    }

    public void setShowLeafs(String showLeafs) {
        this.showLeafs = showLeafs;
    }

    public String[] getAllowedContentTypeIds() {
        return this.allowedContentTypeIds;
    }

    public void setAllowedContentTypeIds(String[] allowedContentTypeIds) {
        this.allowedContentTypeIds = allowedContentTypeIds;
    }

    public String getAllowedContentTypeIdsAsUrlEncodedString() throws Exception {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.allowedContentTypeIds.length) {
            if (i > 0) {
                sb.append("&");
            }
            sb.append("allowedContentTypeIds=" + URLEncoder.encode(this.allowedContentTypeIds[i], "UTF-8"));
            ++i;
        }
        return sb.toString();
    }
}

