/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.common.actions;

import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.Session;
import org.infoglue.cms.applications.common.actions.Error;
import org.infoglue.cms.applications.common.actions.Errors;
import org.infoglue.cms.exception.AccessConstraintException;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConfigurationError;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.ChangeNotificationController;
import org.infoglue.cms.util.StringManager;
import org.infoglue.cms.util.StringManagerFactory;
import org.infoglue.deliver.util.BrowserBean;
import webwork.action.Action;
import webwork.action.CommandDriven;
import webwork.action.ResultException;
import webwork.action.ServletRequestAware;
import webwork.action.ServletResponseAware;

public abstract class WebworkAbstractAction
implements Action,
ServletRequestAware,
ServletResponseAware,
CommandDriven {
    private static final Logger logger = Logger.getLogger((String)WebworkAbstractAction.class.getName());
    private final String ACCESS_DENIED = "accessDenied";
    private Error error;
    private Errors errors = new Errors();
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String commandName;

    public Error getError() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Fetching error from error-template:" + this.error));
        }
        return this.error;
    }

    public Errors getErrors() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Errors:" + this.errors));
        }
        return this.errors;
    }

    public String doDefault() throws Exception {
        return "input";
    }

    public String execute() throws Exception {
        String result = "";
        try {
            result = this.isCommand() ? this.invokeCommand() : this.doExecute();
        }
        catch (ResultException e) {
            logger.error((Object)("ResultException " + (Object)((Object)e)), (Throwable)e);
            result = e.getResult();
        }
        catch (AccessConstraintException e) {
            logger.info((Object)("AccessConstraintException " + e), (Throwable)e);
            this.setErrors(e);
            result = "accessDenied";
        }
        catch (ConstraintException e) {
            logger.info((Object)("ConstraintException " + e), (Throwable)e);
            this.setErrors(e);
            result = "input";
        }
        catch (Bug e) {
            logger.error((Object)("Bug " + e));
            this.setError(e, e.getCause());
            result = "error";
        }
        catch (ConfigurationError e) {
            logger.error((Object)("ConfigurationError " + e));
            this.setError(e, e.getCause());
            result = "error";
        }
        catch (SystemException e) {
            logger.error((Object)("SystemException " + e), (Throwable)e);
            this.setError(e, e.getCause());
            result = "error";
        }
        catch (Throwable e) {
            logger.error((Object)("Throwable " + e), (Throwable)new Exception(e));
            Bug bug = new Bug("Uncaught exception!", e);
            this.setError(bug, bug.getCause());
            result = "error";
        }
        try {
            ChangeNotificationController.notifyListeners();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getCurrentUrl() throws Exception {
        String urlBase = this.getRequest().getRequestURL().toString();
        String urlParameters = this.getRequest().getQueryString();
        return URLEncoder.encode(String.valueOf(urlBase) + "?" + urlParameters, "UTF-8");
    }

    public void setCommand(String commandName) {
        this.commandName = commandName;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setError(Throwable throwable, Throwable cause) {
        this.error = new Error(throwable, cause);
    }

    private void setErrors(ConstraintException exception) {
        Locale locale = this.getSession().getLocale();
        ConstraintException ce = exception;
        while (ce != null) {
            String fieldName = ce.getFieldName();
            String errorCode = ce.getErrorCode();
            String extraInformation = ce.getExtraInformation();
            String localizedErrorMessage = this.getLocalizedErrorMessage(locale, errorCode);
            this.getErrors().addError(fieldName, String.valueOf(localizedErrorMessage) + (extraInformation.length() > 0 ? " (" + extraInformation + ")" : ""));
            ce = ce.getChainedException();
        }
        logger.debug((Object)this.getErrors().toString());
    }

    private String getLocalizedErrorMessage(Locale locale, String errorCode) {
        StringManager stringManager = StringManagerFactory.getPresentationStringManager("org.infoglue.cms.entities", locale);
        return stringManager.getString(errorCode);
    }

    public String getLocalizedString(Locale locale, String key) {
        StringManager stringManager = StringManagerFactory.getPresentationStringManager("org.infoglue.cms.applications", locale);
        return stringManager.getString(key);
    }

    public String getLocalizedString(Locale locale, String key, Object arg1) {
        StringManager stringManager = StringManagerFactory.getPresentationStringManager("org.infoglue.cms.applications", locale);
        return stringManager.getString(key, arg1);
    }

    private boolean isCommand() {
        return this.commandName != null && this.commandName.trim().length() > 0 && this instanceof CommandDriven;
    }

    private String invokeCommand() throws Exception {
        StringBuffer methodName = new StringBuffer("do" + this.commandName);
        methodName.setCharAt(2, Character.toUpperCase(methodName.charAt(2)));
        String result = "";
        try {
            Method method = this.getClass().getMethod(methodName.toString(), new Class[0]);
            result = (String)method.invoke((Object)this, new Object[0]);
        }
        catch (Exception ie) {
            if (ie.getMessage() != null) {
                logger.error((Object)("Exception in top action:" + ie.getMessage()), (Throwable)ie);
            }
            try {
                throw ie.getCause();
            }
            catch (ResultException e) {
                logger.error((Object)("ResultException " + (Object)((Object)e)), (Throwable)e);
                result = e.getResult();
            }
            catch (AccessConstraintException e) {
                logger.info((Object)("AccessConstraintException " + e), (Throwable)e);
                this.setErrors(e);
                result = "accessDenied";
            }
            catch (ConstraintException e) {
                logger.info((Object)("ConstraintException " + e), (Throwable)e);
                this.setErrors(e);
                result = e.getResult() != null ? e.getResult() : "input";
            }
            catch (Bug e) {
                logger.error((Object)("Bug " + e));
                this.setError(e, e.getCause());
                result = "error";
            }
            catch (ConfigurationError e) {
                logger.error((Object)("ConfigurationError " + e));
                this.setError(e, e.getCause());
                result = "error";
            }
            catch (SystemException e) {
                logger.error((Object)("SystemException " + e), (Throwable)e);
                this.setError(e, e.getCause());
                result = "error";
            }
            catch (Throwable e) {
                logger.error((Object)("Throwable " + e));
                Bug bug = new Bug("Uncaught exception!", e);
                this.setError(bug, bug.getCause());
                result = "error";
            }
        }
        try {
            ChangeNotificationController.notifyListeners();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public final String getRoot() {
        return this.request.getContextPath();
    }

    public final InfoGluePrincipal getInfoGluePrincipal() {
        return this.getSession().getInfoGluePrincipal();
    }

    protected abstract String doExecute() throws Exception;

    public final BrowserBean getBrowserBean() {
        BrowserBean browserBean = new BrowserBean();
        browserBean.setRequest(this.request);
        return browserBean;
    }

    protected final HttpServletRequest getRequest() {
        return this.request;
    }

    protected final HttpServletResponse getResponse() {
        return this.response;
    }

    protected final HttpSession getHttpSession() {
        return this.getRequest().getSession();
    }

    public final Session getSession() {
        return new Session(this.getHttpSession());
    }

    public final String getSessionId() {
        return this.getHttpSession().getId();
    }
}

