/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.common.actions;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.infoglue.cms.applications.common.Session;
import org.infoglue.cms.applications.common.ValueConverter;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.exception.ConfigurationError;
import org.infoglue.cms.util.StringManager;
import org.infoglue.cms.util.StringManagerFactory;
import webwork.view.velocity.WebWorkVelocityServlet;

public class VelocityServlet
extends WebWorkVelocityServlet {
    private static final long serialVersionUID = 408929363112264207L;
    private static final String PACKAGE_NAMES_INIT_PARAM = "packageNames";
    private String[] packageNames;

    public void init(ServletConfig configuration) throws ServletException {
        super.init(configuration);
        this.initializePackageNames(configuration.getInitParameter(PACKAGE_NAMES_INIT_PARAM));
    }

    private void initializePackageNames(String commaSeparatedPackageNames) {
        if (commaSeparatedPackageNames == null) {
            throw new ConfigurationError("web.xml not properly configured, did not contain the packageNames init param for the VelocityServlet.");
        }
        StringTokenizer st = new StringTokenizer(commaSeparatedPackageNames, ",");
        this.packageNames = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            this.packageNames[i] = st.nextToken();
            ++i;
        }
    }

    private StringManager getStringManagerChain(Locale locale) {
        return StringManagerFactory.getPresentationStringManager(this.packageNames, locale);
    }

    protected Template handleRequest(HttpServletRequest request, HttpServletResponse response, Context context) throws Exception {
        HttpSession httpSession = request.getSession();
        Session session = new Session(httpSession);
        if (session.getLocale() == null || session.getLocale().getLanguage() == null || session.getLocale().getLanguage().equalsIgnoreCase("")) {
            session.setLocale(Locale.ENGLISH);
        } else {
            try {
                ResourceBundle sk = ResourceBundle.getBundle("org.infoglue.cms.applications.PresentationStrings", session.getLocale());
                if (!sk.getLocale().equals(session.getLocale())) {
                    session.setLocale(Locale.ENGLISH);
                }
            }
            catch (Throwable e) {
                System.out.println("Error:" + e.getMessage() + " - setting locale to english");
                session.setLocale(Locale.ENGLISH);
            }
        }
        if (session.getLocale() == null || session.getLocale().getLanguage() == null || session.getLocale().getLanguage().equalsIgnoreCase("")) {
            context.put("ui", (Object)this.getStringManagerChain(Locale.ENGLISH));
        } else {
            context.put("ui", (Object)this.getStringManagerChain(session.getLocale()));
        }
        context.put("formatter", (Object)new VisualFormatter());
        context.put("converter", (Object)new ValueConverter());
        request.setCharacterEncoding("UTF-8");
        response.setContentType("text/html; charset=UTF-8");
        return super.handleRequest(request, response, context);
    }

    private String getPreferredLanguageCode(HttpServletRequest request) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
        return ps.getString("principal_" + request.getRemoteUser() + "_languageCode");
    }

    private String getPreferredToolId(HttpServletRequest request) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
        return ps.getString("principal_" + request.getRemoteUser() + "_defaultToolId");
    }

    private String getPreferredRepositoryId(HttpServletRequest request) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
        return ps.getString("principal_" + request.getRemoteUser() + "_defaultRepositoryId");
    }
}

