/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.common.actions;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.InterceptionPointController;
import org.infoglue.cms.controllers.kernel.impl.simple.SubscriptionController;
import org.infoglue.cms.entities.management.CategoryVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.InterceptionPointVO;
import org.infoglue.cms.entities.management.SubscriptionFilterVO;
import org.infoglue.cms.entities.management.SubscriptionVO;

public class SubscriptionsAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)SubscriptionsAction.class.getName());
    private static final long serialVersionUID = 1L;
    private Integer interceptionPointId = null;
    private String interceptionPointName = null;
    private String[] interceptionPointCategory = null;
    private String[] explicitInterceptionPointNames = null;
    private String entityName = null;
    private String entityId = null;
    private String extraParameters = "";
    private String returnAddress;
    private Integer[] subscribedInterceptionPointId = null;
    private Map interceptionPointsGroupsMap = new HashMap();
    private Map subscriptions = new HashMap();
    private String interceptionPointIdString = "";
    private Collection subscriptionVOList = null;
    private String name;
    private Integer subscriptionId;
    private List interceptionPointVOList;
    private List contentTypeDefintionVOList;
    private List categoryVOList;
    private String userSessionKey;
    private static SubscriptionController subscriptionsController = SubscriptionController.getController();

    public String doInput() throws Exception {
        if (this.explicitInterceptionPointNames != null && this.explicitInterceptionPointNames.length > 0) {
            int i = 0;
            while (i < this.explicitInterceptionPointNames.length) {
                String interceptionPointName = this.explicitInterceptionPointNames[i];
                InterceptionPointVO interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName(interceptionPointName);
                this.interceptionPointIdString = String.valueOf(this.interceptionPointIdString) + interceptionPointVO.getId() + ",";
                List<SubscriptionVO> subscriptionVOList = subscriptionsController.getSubscriptionVOList(interceptionPointVO.getId(), null, null, this.entityName, this.entityId, this.getInfoGluePrincipal().getName(), null);
                if (subscriptionVOList != null && subscriptionVOList.size() > 0) {
                    this.subscriptions.put(interceptionPointVO.getId(), true);
                } else {
                    this.subscriptions.put(interceptionPointVO.getId(), false);
                }
                ArrayList<InterceptionPointVO> interceptionPointVOList = (ArrayList<InterceptionPointVO>)this.interceptionPointsGroupsMap.get(interceptionPointVO.getCategory());
                if (interceptionPointVOList != null) {
                    interceptionPointVOList.add(interceptionPointVO);
                } else {
                    interceptionPointVOList = new ArrayList<InterceptionPointVO>();
                    interceptionPointVOList.add(interceptionPointVO);
                    this.interceptionPointsGroupsMap.put(interceptionPointVO.getCategory(), interceptionPointVOList);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.interceptionPointCategory.length) {
                String interceptionPointCategoryName = this.interceptionPointCategory[i];
                List interceptionPointVOList = InterceptionPointController.getController().getInterceptionPointVOList(interceptionPointCategoryName);
                for (InterceptionPointVO interceptionPointVO : interceptionPointVOList) {
                    this.interceptionPointIdString = String.valueOf(this.interceptionPointIdString) + interceptionPointVO.getId() + ",";
                    List<SubscriptionVO> subscriptionVOList = subscriptionsController.getSubscriptionVOList(interceptionPointVO.getId(), null, null, this.entityName, this.entityId, this.getInfoGluePrincipal().getName(), null);
                    if (subscriptionVOList != null && subscriptionVOList.size() > 0) {
                        this.subscriptions.put(interceptionPointVO.getId(), true);
                        continue;
                    }
                    this.subscriptions.put(interceptionPointVO.getId(), false);
                }
                this.interceptionPointsGroupsMap.put(interceptionPointCategoryName, interceptionPointVOList);
                ++i;
            }
        }
        return "input";
    }

    public String doExecute() throws Exception {
        String[] interceptionPointIds = this.interceptionPointIdString.split(",");
        int i = 0;
        while (i < interceptionPointIds.length) {
            String key = "subscription_" + interceptionPointIds[i] + "_" + this.extraParameters;
            List<SubscriptionVO> subscriptionVOList = subscriptionsController.getSubscriptionVOList(this.interceptionPointId, null, null, this.entityName, this.entityId, this.getInfoGluePrincipal().getName(), null);
            for (SubscriptionVO subscriptionVO : subscriptionVOList) {
                subscriptionsController.delete(subscriptionVO);
            }
            ++i;
        }
        i = 0;
        while (i < this.subscribedInterceptionPointId.length) {
            Integer interceptionPointId = this.subscribedInterceptionPointId[i];
            SubscriptionVO subscriptionVO = new SubscriptionVO();
            subscriptionVO.setInterceptionPointId(interceptionPointId);
            subscriptionVO.setName(this.name);
            subscriptionVO.setIsGlobal(false);
            subscriptionVO.setEntityName(this.entityName);
            subscriptionVO.setEntityId(this.entityId);
            subscriptionVO.setUserName(this.getInfoGluePrincipal().getName());
            subscriptionsController.create(subscriptionVO);
            ++i;
        }
        if (this.returnAddress != null && !this.returnAddress.equals("")) {
            String arguments = "userSessionKey=" + this.userSessionKey + "&isAutomaticRedirect=false";
            String messageUrl = String.valueOf(this.returnAddress) + (this.returnAddress.indexOf("?") > -1 ? "&" : "?") + arguments;
            this.getResponse().sendRedirect(messageUrl);
            return "none";
        }
        return "success";
    }

    public String doInputGlobalSubscriptions() throws Exception {
        this.subscriptionVOList = subscriptionsController.getSubscriptionVOList(null, null, new Boolean(true), null, null, this.getInfoGluePrincipal().getName(), null);
        this.contentTypeDefintionVOList = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList();
        this.categoryVOList = CategoryController.getController().findAllActiveCategories();
        this.interceptionPointVOList = new ArrayList();
        List allInterceptionPointVOList = InterceptionPointController.getController().getInterceptionPointVOList();
        for (InterceptionPointVO interceptionPointVO : allInterceptionPointVOList) {
            String name = interceptionPointVO.getName();
            if (!name.equals("ContentVersion.Publish") && !name.equals("SiteNodeVersion.Publish") && !name.equals("Content.ExpireDateComingUp") && !name.equals("SiteNode.ExpireDateComingUp")) continue;
            this.interceptionPointVOList.add(interceptionPointVO);
        }
        return "inputGlobalSubscriptions";
    }

    public String doGlobalSubscriptions() throws Exception {
        SubscriptionVO subscriptionVO = new SubscriptionVO();
        subscriptionVO.setIsGlobal(true);
        subscriptionVO.setInterceptionPointId(this.interceptionPointId);
        subscriptionVO.setName(this.name);
        subscriptionVO.setUserName(this.getInfoGluePrincipal().getName());
        ArrayList<SubscriptionFilterVO> subscriptionFilterVOList = new ArrayList<SubscriptionFilterVO>();
        int i = 0;
        String filterType = this.getRequest().getParameter("filterType_" + i);
        while (filterType != null && !filterType.equals("") && filterType != "-1") {
            String[] filterConditions = this.getRequest().getParameterValues("filterCondition_" + i);
            StringBuffer filterConditionStringBuffer = new StringBuffer();
            int j = 0;
            while (j < filterConditions.length) {
                if (j > 0) {
                    filterConditionStringBuffer.append(",");
                }
                filterConditionStringBuffer.append(URLEncoder.encode(filterConditions[j], "utf-8"));
                ++j;
            }
            String andParagraph = this.getRequest().getParameter("andParagraph_" + i);
            if (andParagraph == null || andParagraph.equals("")) {
                andParagraph = "true";
            }
            SubscriptionFilterVO subscriptionFilterVO = new SubscriptionFilterVO();
            subscriptionFilterVO.setFilterType(filterType);
            subscriptionFilterVO.setFilterCondition(filterConditionStringBuffer.toString());
            subscriptionFilterVO.setIsAndCondition(new Boolean(andParagraph));
            subscriptionFilterVOList.add(subscriptionFilterVO);
            filterType = this.getRequest().getParameter("filterType_" + ++i);
        }
        subscriptionsController.create(subscriptionVO, subscriptionFilterVOList);
        return "successGlobalSubscriptions";
    }

    public String doUpdateGlobalSubscription() throws Exception {
        SubscriptionVO subscriptionVO = subscriptionsController.getSubscriptionVOWithId(this.subscriptionId);
        subscriptionVO.setIsGlobal(true);
        subscriptionVO.setInterceptionPointId(this.interceptionPointId);
        subscriptionVO.setName(this.name);
        ArrayList<SubscriptionFilterVO> subscriptionFilterVOList = new ArrayList<SubscriptionFilterVO>();
        int i = 0;
        String filterType = this.getRequest().getParameter("filterType_" + i);
        logger.info((Object)("filterType[" + i + "]:" + filterType));
        while (filterType != null && !filterType.equals("") && filterType != "-1") {
            String[] filterConditions = this.getRequest().getParameterValues("filterCondition_" + i);
            StringBuffer filterConditionStringBuffer = new StringBuffer();
            int j = 0;
            while (j < filterConditions.length) {
                if (j > 0) {
                    filterConditionStringBuffer.append(",");
                }
                filterConditionStringBuffer.append(URLEncoder.encode(filterConditions[j], "utf-8"));
                ++j;
            }
            String andParagraph = this.getRequest().getParameter("andParagraph_" + i);
            if (andParagraph == null || andParagraph.equals("")) {
                andParagraph = "true";
            }
            SubscriptionFilterVO subscriptionFilterVO = new SubscriptionFilterVO();
            subscriptionFilterVO.setFilterType(filterType);
            subscriptionFilterVO.setFilterCondition(filterConditionStringBuffer.toString());
            subscriptionFilterVO.setIsAndCondition(new Boolean(andParagraph));
            subscriptionFilterVOList.add(subscriptionFilterVO);
            filterType = this.getRequest().getParameter("filterType_" + ++i);
            logger.info((Object)("filterType[" + i + "]:" + filterType));
        }
        subscriptionsController.update(subscriptionVO, subscriptionFilterVOList);
        return "successGlobalSubscriptions";
    }

    public String doDeleteGlobalSubscription() throws Exception {
        subscriptionsController.delete(this.subscriptionId);
        return "successGlobalSubscriptions";
    }

    public String doGetSubscriptionForm() throws Exception {
        SubscriptionVO subscriptionVO = subscriptionsController.getSubscriptionVOWithId(this.subscriptionId);
        StringBuffer sb = new StringBuffer();
        sb.append("<form action=\"Subscriptions!updateGlobalSubscription.action\" name=\"inputForm\" method=\"post\">");
        sb.append("<input type=\"hidden\" name=\"subscriptionId\" value=\"" + subscriptionVO.getId() + "\" style=\"border: 0px;\"/>");
        sb.append("<fieldset style=\"width: 90%; border: 0px solid red; margin: 0px; padding-left: 10px;\">");
        sb.append("\t<h3>" + this.getLocalizedString(this.getLocale(), "tool.common.subscriptionBasics.label") + "</h3>");
        sb.append("\t<p style=\"clear: both;\">");
        sb.append("\t<label for=\"name\">" + this.getLocalizedString(this.getLocale(), "tool.common.subscriptionName.label") + "</label>");
        sb.append("\t<input type=\"text\" name=\"name\" value=\"" + subscriptionVO.getName() + "\"/>");
        sb.append("\t</p>");
        sb.append("\t<p style=\"clear: both;\">");
        sb.append("\t<label for=\"interceptionPointId\">" + this.getLocalizedString(this.getLocale(), "tool.common.subscriptionType.label") + "</label>");
        sb.append("\t<select name=\"interceptionPointId\">");
        sb.append("\t\t<option value=\"33\" " + (subscriptionVO.getInterceptionPointId() == 33 ? "selected='selected'" : "") + ">Content.Published</option>");
        sb.append("\t\t<option value=\"22\" " + (subscriptionVO.getInterceptionPointId() == 22 ? "selected='selected'" : "") + ">Content.Delete</option>");
        sb.append("\t</select>");
        sb.append("\t</p>");
        sb.append("\t<div style=\"clear: both;\"></div>");
        sb.append("\t<h4 style=\"border-bottom: 1px solid #bbb;\">" + this.getLocalizedString(this.getLocale(), "tool.common.subscriptionsFilters.label") + "</h4>");
        this.contentTypeDefintionVOList = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList();
        this.categoryVOList = CategoryController.getController().findAllActiveCategories();
        int i = 0;
        int size = subscriptionVO.getSubscriptionFilterVOList().size();
        for (SubscriptionFilterVO subscriptionFilterVO : subscriptionVO.getSubscriptionFilterVOList()) {
            sb.append("\t<div id=\"filterRow_" + i + "\" class=\"formRow\" style=\"min-height: 50px; border: 0px solid red; border-bottom: 1px solid #bbb;\">");
            sb.append("\t\t<label for=\"filterType_" + i + "\">" + this.getLocalizedString(this.getLocale(), "tool.common.subscriptionFilterType.label") + "</label>");
            sb.append("\t\t<select id=\"filterType_" + i + "\" name=\"filterType_" + i + "\" onchange=\"updateConditionInput(" + i + ");\">");
            sb.append("\t\t\t<option value=\"0\"" + (subscriptionFilterVO.getFilterType().equals("0") ? "selected='selected'" : "") + ">Content types</option>");
            sb.append("\t\t\t<option value=\"1\"" + (subscriptionFilterVO.getFilterType().equals("1") ? "selected='selected'" : "") + ">Categories</option>");
            sb.append("\t\t</select>");
            sb.append("\t\t<label for=\"filterCondition_" + i + "\">" + this.getLocalizedString(this.getLocale(), "tool.common.subscriptionFilterCondition.label") + "</label>");
            sb.append("\t\t<select id=\"filterCondition_" + i + "\" name=\"filterCondition_" + i + "\" multiple=\"multiple\" size=\"3\">");
            if (subscriptionFilterVO.getFilterType().equals("0")) {
                for (ContentTypeDefinitionVO ctd : this.contentTypeDefintionVOList) {
                    sb.append("<option value=\"" + ctd.getId() + "\"" + (this.hasValue(subscriptionFilterVO.getFilterCondition(), ctd.getId().toString()) ? "selected='selected'" : "") + ">" + ctd.getName() + "</option>");
                }
            } else if (subscriptionFilterVO.getFilterType().equals("1")) {
                for (CategoryVO categoryVO : this.categoryVOList) {
                    sb.append("<option value=\"" + categoryVO.getId() + "\"" + (this.hasValue(subscriptionFilterVO.getFilterCondition(), categoryVO.getId().toString()) ? "selected='selected'" : "") + ">" + categoryVO.getName() + "</option>");
                }
            }
            sb.append("\t\t</select>");
            sb.append("\t\t&nbsp; <a id=\"removeFilterRowLink" + i + "\" href=\"javascript:removeFilterRow(" + i + ");\">" + this.getLocalizedString(this.getLocale(), "tool.common.deleteFilter.label") + "</a>");
            if (size - 1 > i) {
                sb.append("\t\t<p id=\"andParagraph_" + i + "\" style=\"padding: 30px; display: block;\">");
            } else {
                sb.append("\t\t<p id=\"andParagraph_" + i + "\" style=\"padding: 30px; display: none;\">");
            }
            sb.append("\t\t\t<label for=\"isAndCondition_" + i + "\">" + this.getLocalizedString(this.getLocale(), "tool.common.subscriptionFilterIsAndCondition.label") + "</label>");
            sb.append("\t\t\t<select id=\"isAndCondition_" + i + "\" name=\"isAndCondition_0\">';");
            sb.append("\t\t\t\t<option value=\"true\"" + (subscriptionFilterVO.getIsAndCondition() != false ? "selected='selected'" : "") + ">AND</option>';");
            sb.append("\t\t\t\t<option value=\"false\"" + (subscriptionFilterVO.getIsAndCondition() == false ? "selected='selected'" : "") + ">OR</option>';");
            sb.append("\t\t\t</select>");
            sb.append("\t\t</p>");
            sb.append("\t</div>");
            sb.append("\t<div id=\"break_" + i + "\" style=\"clear:both\"></div>");
            ++i;
        }
        sb.append("\t<br/>");
        sb.append("\t<a href=\"javascript:addFilterRow();\">" + this.getLocalizedString(this.getLocale(), "tool.common.addFilter.label") + "</a>");
        sb.append("\t<br/>");
        sb.append("\t<br/>");
        sb.append("\t<input type=\"submit\" value=\"Save\"/>");
        sb.append("</fieldset>");
        sb.append("</form>");
        sb.append("<script type='text/javascript'>i=" + i + ";</script>");
        this.getResponse().setContentType("text/plain");
        this.getResponse().getWriter().println(sb.toString());
        return "none";
    }

    private boolean hasValue(String setValuesAsCommaseperatedString, String value) {
        String[] setValues = setValuesAsCommaseperatedString.split(",");
        int i = 0;
        while (i < setValues.length) {
            String setValue = setValues[i];
            if (setValue.equals(value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getReturnAddress() {
        return this.returnAddress;
    }

    public void setReturnAddress(String returnAddress) {
        this.returnAddress = returnAddress;
    }

    public Integer getInterceptionPointId() {
        return this.interceptionPointId;
    }

    public void setInterceptionPointId(Integer interceptionPointId) {
        this.interceptionPointId = interceptionPointId;
    }

    public String getExtraParameters() {
        return this.extraParameters;
    }

    public String getInterceptionPointName() {
        return this.interceptionPointName;
    }

    public void setExtraParameters(String extraParameters) {
        this.extraParameters = extraParameters;
    }

    public void setInterceptionPointName(String interceptionPointName) {
        this.interceptionPointName = interceptionPointName;
    }

    public String[] getInterceptionPointCategory() {
        return this.interceptionPointCategory;
    }

    public void setInterceptionPointCategory(String[] interceptionPointCategory) {
        this.interceptionPointCategory = interceptionPointCategory;
    }

    public Map getInterceptionPointsGroupsMap() {
        return this.interceptionPointsGroupsMap;
    }

    public String[] getExplicitInterceptionPointNames() {
        return this.explicitInterceptionPointNames;
    }

    public void setExplicitInterceptionPointNames(String[] explicitInterceptionPointNames) {
        this.explicitInterceptionPointNames = explicitInterceptionPointNames;
    }

    public Map getSubscriptions() {
        return this.subscriptions;
    }

    public Integer[] getSubscribedInterceptionPointId() {
        return this.subscribedInterceptionPointId;
    }

    public void setSubscribedInterceptionPointId(Integer[] subscribedInterceptionPointId) {
        this.subscribedInterceptionPointId = subscribedInterceptionPointId;
    }

    public String getInterceptionPointIdString() {
        return this.interceptionPointIdString;
    }

    public void setInterceptionPointIdString(String interceptionPointIdString) {
        this.interceptionPointIdString = interceptionPointIdString;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public Collection getSubscriptionVOList() {
        return this.subscriptionVOList;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List getContentTypeDefintionVOList() {
        return this.contentTypeDefintionVOList;
    }

    public List getCategoryVOList() {
        return this.categoryVOList;
    }

    public Integer getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(Integer subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public List getInterceptionPointVOList() {
        return this.interceptionPointVOList;
    }
}

