/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.common.actions;

import com.frovi.ss.Tree.BaseNode;
import com.frovi.ss.Tree.INodeSupplier;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.TransactionHistoryController;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.RepositoryVO;
import org.infoglue.cms.entities.management.TransactionHistoryVO;
import org.infoglue.cms.entities.management.impl.simple.ContentTypeDefinitionImpl;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.ChangeNotificationController;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.XMLNotificationWriter;

public abstract class SimpleXmlServiceAction
extends InfoGlueAbstractAction {
    private static final Logger logger = Logger.getLogger((String)SimpleXmlServiceAction.class.getName());
    private static final String protectedPropertyFragments = "password,administrator,authorizer,authenticator,masterserver,slaveserver,log";
    protected static final String SERVICEREVISION = "$Revision: 1.23 $";
    protected static String ENCODING = "UTF-8";
    protected static String TYPE_FOLDER = "Folder";
    protected static String TYPE_ITEM = "Item";
    protected static String TYPE_REPOSITORY = "Repository";
    protected String showLeafs = "yes";
    protected Integer parent = null;
    protected Integer repositoryId = null;
    protected String urlArgSeparator = "&";
    protected String action = "";
    protected boolean createAction = false;
    protected boolean useTemplate = false;
    protected VisualFormatter formatter = new VisualFormatter();
    protected String[] allowedContentTypeIds = null;
    protected static Map changeNotificationBuffer = new HashMap();

    public abstract INodeSupplier getNodeSupplier() throws SystemException;

    protected abstract BaseEntityVO getRootEntityVO(Integer var1, InfoGluePrincipal var2) throws ConstraintException, SystemException;

    public List getContentTypeDefinitions() throws Exception {
        return ContentTypeDefinitionController.getController().getContentTypeDefinitionVOList();
    }

    public String encode(String text) {
        return text;
    }

    protected String makeAction(BaseNode node) throws UnsupportedEncodingException {
        String action = "javascript:onTreeItemClick(this,";
        action = String.valueOf(action) + "'" + node.getId() + "','" + this.repositoryId + "','" + new VisualFormatter().escapeForAdvancedJavascripts(node.getTitle()) + "');";
        return action;
    }

    protected String getFormattedDocument(Document doc) {
        return this.getFormattedDocument(doc, true, false);
    }

    protected String getFormattedDocument(Document doc, boolean compact, boolean supressDecl) {
        OutputFormat format = compact ? OutputFormat.createCompactFormat() : OutputFormat.createPrettyPrint();
        format.setSuppressDeclaration(supressDecl);
        format.setEncoding(ENCODING);
        format.setExpandEmptyElements(false);
        StringWriter stringWriter = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)stringWriter, format);
        try {
            writer.write(doc);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringWriter.toString();
    }

    protected String out(String string) throws IOException {
        this.getResponse().setContentType("text/xml; charset=" + ENCODING);
        this.getResponse().setHeader("Cache-Control", "no-cache");
        this.getResponse().setHeader("Pragma", "no-cache");
        this.getResponse().setDateHeader("Expires", 0L);
        PrintWriter out = this.getResponse().getWriter();
        out.println(string);
        return null;
    }

    public String doLanguage() throws Exception {
        return null;
    }

    public String doApplicationSettings() throws Exception {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("applicationSettings");
        Properties props = CmsPropertyHandler.getProperties();
        Iterator<Object> i = props.keySet().iterator();
        while (i.hasNext()) {
            String key;
            String elmKey = key = (String)i.next();
            if (key.matches("^\\d.*")) {
                elmKey = "_" + key;
            }
            String value = (String)props.get(key);
            if (this.isProtectedProperty(key)) continue;
            root.addElement(elmKey).setText(value);
        }
        root.addElement("serviceRevision").setText(SERVICEREVISION);
        return this.out(this.getFormattedDocument(doc));
    }

    private boolean isProtectedProperty(String key) {
        String[] fragments = protectedPropertyFragments.split(",");
        int i = 0;
        while (i < fragments.length) {
            if (key.toLowerCase().indexOf(fragments[i].toLowerCase()) > -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String doContentTypeDefinitions() throws Exception {
        List contentTypeDefinitions = this.getContentTypeDefinitions();
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("definitions");
        TransactionHistoryController transactionHistoryController = TransactionHistoryController.getController();
        for (ContentTypeDefinitionVO vo : contentTypeDefinitions) {
            if (vo.getType().compareTo(ContentTypeDefinitionVO.CONTENT) != 0) continue;
            TransactionHistoryVO transactionHistoryVO = transactionHistoryController.getLatestTransactionHistoryVOForEntity(ContentTypeDefinitionImpl.class, vo.getContentTypeDefinitionId());
            Element definition = DocumentHelper.createElement((String)"definition");
            definition.addAttribute("id", "" + vo.getContentTypeDefinitionId()).addAttribute("type", "" + vo.getType()).addAttribute("name", vo.getName());
            if (transactionHistoryVO != null) {
                definition.addAttribute("mod", this.formatDate(transactionHistoryVO.getTransactionDateTime()));
            }
            Element schemaValue = definition.addElement("schemaValue");
            schemaValue.addCDATA(vo.getSchemaValue());
            root.add(definition);
        }
        return this.out(this.getFormattedDocument(doc));
    }

    public String doGetChangeNotifications() throws IOException {
        String id = this.getRequest().getSession().getId();
        StringWriter buffer = (StringWriter)changeNotificationBuffer.get(id);
        if (buffer == null) {
            buffer = new StringWriter();
            buffer.write("<changeNotifications>");
            changeNotificationBuffer.put(id, buffer);
            XMLNotificationWriter streamWriter = new XMLNotificationWriter(buffer, ENCODING, "", null, true, true);
            ChangeNotificationController.getInstance().registerListener(streamWriter);
        }
        buffer.write("</changeNotifications>");
        try {
            this.out(this.getFormattedDocument(DocumentHelper.parseText((String)buffer.toString())));
        }
        catch (Exception e) {
            this.out("<exception/>");
        }
        buffer.getBuffer().delete(0, buffer.getBuffer().length());
        buffer.write("<changeNotifications>");
        return null;
    }

    public String doGetChangeNotificationsStream() throws IOException {
        boolean open = true;
        String remoteId = String.valueOf(this.getRequest().getRemoteAddr()) + " / " + this.getInfoGluePrincipal().getName();
        String boundary = this.getRequest().getParameter("boundary");
        if (boundary == null) {
            boundary = "-----------------infoglue-multipart-1d4faa3ac353573";
        }
        this.getResponse().setHeader("boundary", boundary);
        this.getResponse().setBufferSize(0);
        this.getResponse().setContentType("text/plain; charset=" + ENCODING);
        this.getResponse().flushBuffer();
        Thread thread = Thread.currentThread();
        ServletOutputStream out = this.getResponse().getOutputStream();
        ServletInputStream in = this.getRequest().getInputStream();
        XMLNotificationWriter streamWriter = new XMLNotificationWriter(new OutputStreamWriter((OutputStream)out), ENCODING, boundary, thread, true, false);
        logger.info((Object)("Notification stream listen started from:" + remoteId));
        ChangeNotificationController.getInstance().registerListener(streamWriter);
        while (open) {
            try {
                Thread.sleep(Long.MAX_VALUE);
                out.flush();
            }
            catch (Exception e) {
                open = false;
            }
        }
        ChangeNotificationController.getInstance().unregisterListener(streamWriter);
        logger.info((Object)("Notification stream listen ended from:" + remoteId));
        return null;
    }

    protected String formatDate(Date date) {
        return "" + date;
    }

    public String doExecute() throws Exception {
        if (this.useTemplate) {
            return "success";
        }
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("tree");
        if (this.repositoryId == null) {
            List repositories = RepositoryController.getController().getAuthorizedRepositoryVOList(this.getInfoGluePrincipal(), false);
            for (RepositoryVO r : repositories) {
                BaseEntityVO entityVO = this.getRootEntityVO(r.getId(), this.getInfoGluePrincipal());
                String src = String.valueOf(this.action) + "?repositoryId=" + r.getId() + this.urlArgSeparator + "parent=" + entityVO.getId();
                if (this.createAction && src.length() > 0) {
                    src = String.valueOf(src) + this.urlArgSeparator + "createAction=true";
                }
                if (this.action.length() > 0 && src.length() > 0) {
                    src = String.valueOf(src) + this.urlArgSeparator + "action=" + this.action;
                }
                String allowedContentTypeIdsUrlEncodedString = this.getAllowedContentTypeIdsAsUrlEncodedString();
                logger.info((Object)("allowedContentTypeIdsUrlEncodedString1:" + allowedContentTypeIdsUrlEncodedString));
                if (allowedContentTypeIdsUrlEncodedString.length() > 0 && src.length() > 0) {
                    src = String.valueOf(src) + this.urlArgSeparator + allowedContentTypeIdsUrlEncodedString;
                }
                logger.info((Object)("src:" + src));
                String text = r.getName();
                Element element = root.addElement("tree");
                element.addAttribute("id", "" + r.getId()).addAttribute("repositoryId", "" + r.getId()).addAttribute("text", this.encode(text)).addAttribute("src", src).addAttribute("hasChildren", "true").addAttribute("type", TYPE_REPOSITORY);
            }
            this.out(this.getFormattedDocument(doc));
            return null;
        }
        INodeSupplier sup = this.getNodeSupplier();
        if (this.parent == null) {
            BaseNode node = sup.getRootNode();
            String text = node.getTitle();
            String type = TYPE_FOLDER;
            String src = String.valueOf(this.action) + "?repositoryId=" + this.repositoryId + this.urlArgSeparator + "parent=" + node.getId();
            if (this.createAction && src.length() > 0) {
                src = String.valueOf(src) + this.urlArgSeparator + "createAction=true";
            }
            if (this.action.length() > 0 && src.length() > 0) {
                src = String.valueOf(src) + this.urlArgSeparator + "action=" + this.action;
            }
            String allowedContentTypeIdsUrlEncodedString = this.getAllowedContentTypeIdsAsUrlEncodedString();
            logger.info((Object)("allowedContentTypeIdsUrlEncodedString2:" + allowedContentTypeIdsUrlEncodedString));
            if (allowedContentTypeIdsUrlEncodedString.length() > 0 && src.length() > 0) {
                src = String.valueOf(src) + this.urlArgSeparator + allowedContentTypeIdsUrlEncodedString;
            }
            Element elm = root.addElement("tree");
            elm.addAttribute("id", "" + node.getId()).addAttribute("repositoryId", "" + this.repositoryId).addAttribute("text", this.encode(text)).addAttribute("src", src).addAttribute("isHidden", (String)node.getParameters().get("isHidden")).addAttribute("hasChildren", "true").addAttribute("type", type);
            if (node.getParameters().containsKey("contentTypeDefinitionId")) {
                elm.addAttribute("contentTypeDefinitionId", (String)node.getParameters().get("contentTypeDefinitionId"));
            }
            if (node.getParameters().containsKey("isProtected")) {
                elm.addAttribute("isProtected", (String)node.getParameters().get("isProtected"));
            }
            if (node.getParameters().containsKey("stateId")) {
                elm.addAttribute("stateId", (String)node.getParameters().get("stateId"));
            }
            this.out(this.getFormattedDocument(doc));
            return null;
        }
        if (this.parent > -1) {
            Collection containerNodes = sup.getChildContainerNodes(this.parent);
            Collection childNodes = sup.getChildLeafNodes(this.parent);
            ContentController contentController = ContentController.getContentController();
            ContentVersionController contentVersionController = ContentVersionController.getContentVersionController();
            for (BaseNode theNode : containerNodes) {
                String allowedContentTypeIdsUrlEncodedString;
                if (theNode.isContainer() && sup.hasChildren()) {
                    theNode.setChildren(sup.hasChildren(theNode.getId()));
                }
                String src = String.valueOf(this.action) + "?repositoryId=" + this.repositoryId + this.urlArgSeparator + "parent=" + theNode.getId();
                if (this.createAction && src.length() > 0) {
                    src = String.valueOf(src) + this.urlArgSeparator + "createAction=true";
                }
                if (this.createAction && src.length() > 0) {
                    src = String.valueOf(src) + this.urlArgSeparator + "showLeafs=" + this.showLeafs;
                }
                if (this.action.length() > 0 && src.length() > 0) {
                    src = String.valueOf(src) + this.urlArgSeparator + "action=" + this.action;
                }
                if ((allowedContentTypeIdsUrlEncodedString = this.getAllowedContentTypeIdsAsUrlEncodedString()).length() > 0 && src.length() > 0) {
                    src = String.valueOf(src) + this.urlArgSeparator + allowedContentTypeIdsUrlEncodedString;
                }
                Element elm = root.addElement("tree");
                elm.addAttribute("id", "" + theNode.getId()).addAttribute("parent", "" + this.parent).addAttribute("repositoryId", "" + this.repositoryId).addAttribute("text", this.encode(theNode.getTitle())).addAttribute("src", src).addAttribute("isHidden", (String)theNode.getParameters().get("isHidden")).addAttribute("type", TYPE_FOLDER).addAttribute("hasChildren", "" + theNode.hasChildren());
                if (theNode.getParameters().containsKey("contentTypeDefinitionId")) {
                    elm.addAttribute("contentTypeDefinitionId", "" + theNode.getParameters().get("contentTypeDefinitionId"));
                }
                if (theNode.getParameters().containsKey("isProtected")) {
                    elm.addAttribute("isProtected", (String)theNode.getParameters().get("isProtected"));
                }
                if (theNode.getParameters().containsKey("stateId")) {
                    elm.addAttribute("stateId", (String)theNode.getParameters().get("stateId"));
                }
                if (!this.createAction) continue;
                elm.addAttribute("action", this.makeAction(theNode));
            }
            for (BaseNode theNode : childNodes) {
                ContentTypeDefinitionVO contentTypeDefinitionVO;
                String text = theNode.getTitle();
                String action = this.makeAction(theNode);
                String type = TYPE_ITEM;
                Element elm = root.addElement("tree");
                elm.addAttribute("id", "" + theNode.getId()).addAttribute("parent", "" + this.parent).addAttribute("repositoryId", "" + this.repositoryId).addAttribute("text", this.encode(text)).addAttribute("type", type);
                if (theNode.getParameters().containsKey("contentTypeDefinitionId")) {
                    elm.addAttribute("contentTypeDefinitionId", "" + theNode.getParameters().get("contentTypeDefinitionId"));
                }
                if (theNode.getParameters().containsKey("isProtected")) {
                    elm.addAttribute("isProtected", (String)theNode.getParameters().get("isProtected"));
                }
                if (theNode.getParameters().containsKey("stateId")) {
                    elm.addAttribute("stateId", (String)theNode.getParameters().get("stateId"));
                }
                if (this.createAction) {
                    elm.addAttribute("action", action);
                } else {
                    ContentVersionVO activeVersion = contentVersionController.getLatestActiveContentVersionVO(theNode.getId(), LanguageController.getController().getMasterLanguage(this.repositoryId).getLanguageId());
                    if (activeVersion != null && !this.useTemplate) {
                        elm.addAttribute("activeVersion", "" + activeVersion.getContentVersionId());
                        elm.addAttribute("activeVersionStateId", "" + activeVersion.getStateId());
                        elm.addAttribute("activeVersionModifier", activeVersion.getVersionModifier());
                    }
                }
                if (this.useTemplate || sup.getClass().getName().indexOf("Content") <= -1 || (contentTypeDefinitionVO = contentController.getContentTypeDefinition(theNode.getId())) == null) continue;
                elm.addAttribute("contentTypeId", "" + contentTypeDefinitionVO.getContentTypeDefinitionId());
            }
            this.out(this.getFormattedDocument(doc));
            return null;
        }
        return null;
    }

    public Integer getParent() {
        return this.parent;
    }

    public void setParent(Integer integer) {
        this.parent = integer;
    }

    public Integer getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(Integer integer) {
        this.repositoryId = integer;
    }

    public boolean isCreateAction() {
        return this.createAction;
    }

    public void setCreateAction(boolean createAction) {
        this.createAction = createAction;
    }

    public boolean isUseTemplate() {
        return this.useTemplate;
    }

    public void setUseTemplate(boolean useTemplate) {
        this.useTemplate = useTemplate;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getShowLeafs() {
        return this.showLeafs;
    }

    public void setShowLeafs(String showLeafs) {
        this.showLeafs = showLeafs;
    }

    public String[] getAllowedContentTypeIds() {
        return this.allowedContentTypeIds;
    }

    public void setAllowedContentTypeIds(String[] allowedContentTypeIds) {
        this.allowedContentTypeIds = allowedContentTypeIds;
    }

    public String getAllowedContentTypeIdsAsUrlEncodedString() throws Exception {
        if (this.allowedContentTypeIds == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.allowedContentTypeIds.length) {
            if (i > 0) {
                sb.append("&");
            }
            sb.append("allowedContentTypeIds=" + URLEncoder.encode(this.allowedContentTypeIds[i], "UTF-8"));
            ++i;
        }
        return sb.toString();
    }
}

