/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.common.actions;

import java.security.Principal;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.controllers.usecases.common.LoginUCC;
import org.infoglue.cms.controllers.usecases.common.LoginUCCFactory;
import org.infoglue.cms.security.AuthenticationModule;
import org.infoglue.deliver.util.HttpHelper;
import webwork.action.ActionContext;

public class LoginAction
extends InfoGlueAbstractAction {
    private static final long serialVersionUID = 35668814570153876L;
    private String userName = null;
    private String password = null;
    private String errorMessage = "";
    private String referringUrl = null;
    private HttpHelper httpHelper = new HttpHelper();

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String doExecute() throws Exception {
        if (this.getRequest().getRemoteUser() != null) {
            return "redirect";
        }
        return "success";
    }

    public String doInvalidLogin() throws Exception {
        if (this.getRequest().getRemoteUser() != null) {
            return "redirect";
        }
        return "invalidLogin";
    }

    public String doLogonUser() throws Exception {
        LoginUCC loginController = LoginUCCFactory.newLoginUCC();
        boolean isAccepted = loginController.authorizeSystemUser(this.userName, this.password);
        if (isAccepted) {
            return "userAccepted";
        }
        this.errorMessage = "The logon information given was incorrect, please verify and try again.";
        return "invalidLogin";
    }

    public String doLogout() throws Exception {
        AuthenticationModule authenticationModule;
        boolean redirected;
        this.getHttpSession().invalidate();
        String encodedUserNameCookie = this.httpHelper.getCookie(this.getRequest(), "iguserid");
        if (encodedUserNameCookie != null) {
            ActionContext.getServletContext().removeAttribute(encodedUserNameCookie);
        }
        if (redirected = (authenticationModule = AuthenticationModule.getAuthenticationModule(null, null)).logoutUser(this.getRequest(), this.getResponse())) {
            return "none";
        }
        return "logout";
    }

    public String getPrincipal() {
        Principal principal = this.getRequest().getUserPrincipal();
        return "Principal:" + principal.getName();
    }

    public String getReferringUrl() {
        return this.referringUrl;
    }

    public void setReferringUrl(String string) {
        this.referringUrl = string;
    }
}

