/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.common.actions;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.applications.common.actions.WebworkAbstractAction;
import org.infoglue.cms.applications.databeans.LinkBean;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.InfoGluePrincipalControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.ToolbarController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.AuthenticationModule;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.controllers.kernel.impl.simple.ExtranetController;
import org.infoglue.deliver.util.CacheController;
import webwork.action.ActionContext;
import webwork.config.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InfoGlueAbstractAction
extends WebworkAbstractAction {
    private static final Logger logger = Logger.getLogger((String)InfoGlueAbstractAction.class.getName());
    protected String colorScheme = null;

    public InfoGlueAbstractAction getThis() {
        return this;
    }

    public String getLogoutURL() throws Exception {
        AuthenticationModule authenticationModule = AuthenticationModule.getAuthenticationModule(null, null);
        return authenticationModule.getLogoutUrl();
    }

    public String getURLBase() {
        return this.getRequest().getContextPath();
    }

    public String getCurrentURL() {
        return this.getRequest().getRequestURL() + (this.getRequest().getQueryString() == null ? "" : "?" + this.getRequest().getQueryString());
    }

    public String getOriginalFullURL() {
        String originalQueryString;
        String originalRequestURL = this.getRequest().getParameter("originalRequestURL");
        if (originalRequestURL == null || originalRequestURL.length() == 0) {
            originalRequestURL = this.getRequest().getRequestURL().toString();
        }
        if ((originalQueryString = this.getRequest().getParameter("originalQueryString")) == null || originalQueryString.length() == 0) {
            originalQueryString = this.getRequest().getQueryString();
        }
        return String.valueOf(originalRequestURL) + (originalQueryString == null ? "" : "?" + originalQueryString);
    }

    public int getSessionTimeout() {
        return this.getHttpSession().getMaxInactiveInterval();
    }

    public List getToolLocales() {
        return CmsPropertyHandler.getToolLocales();
    }

    public List getToolbarButtons(String toolbarKey, String primaryKey, String extraParameters) {
        ToolbarController toolbarController = new ToolbarController();
        return toolbarController.getToolbarButtons(toolbarKey, this.getInfoGluePrincipal(), this.getLocale(), primaryKey, extraParameters);
    }

    public List getRightToolbarButtons(String toolbarKey, String primaryKey, String extraParameters, boolean disableCloseButton) {
        ToolbarController toolbarController = new ToolbarController();
        return toolbarController.getRightToolbarButtons(toolbarKey, this.getInfoGluePrincipal(), this.getLocale(), primaryKey, extraParameters, disableCloseButton);
    }

    public List getFooterToolbarButtons(String toolbarKey, String primaryKey, String extraParameters, boolean disableCloseButton) {
        ToolbarController toolbarController = new ToolbarController();
        return toolbarController.getFooterToolbarButtons(toolbarKey, this.getInfoGluePrincipal(), this.getLocale(), primaryKey, extraParameters, disableCloseButton);
    }

    public String getPrincipalPropertyValue(String propertyName, boolean escapeSpecialCharacters) {
        return this.getPrincipalPropertyValue(propertyName, escapeSpecialCharacters, false);
    }

    public String getPrincipalPropertyValue(InfoGluePrincipal infoGluePrincipal, String propertyName, boolean escapeSpecialCharacters, boolean findLargestValue) {
        logger.info((Object)("propertyName: " + propertyName));
        logger.info((Object)("escapeSpecialCharacters: " + escapeSpecialCharacters));
        logger.info((Object)("findLargestValue: " + findLargestValue));
        String value = "";
        try {
            LanguageVO languageVO = (LanguageVO)LanguageController.getController().getLanguageVOList().get(0);
            value = InfoGluePrincipalControllerProxy.getController().getPrincipalPropertyValue(infoGluePrincipal, propertyName, languageVO.getId(), null, false, escapeSpecialCharacters, findLargestValue);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get property " + propertyName + " from infoGluePrincipal:" + e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public String getPrincipalPropertyValue(String propertyName, boolean escapeSpecialCharacters, boolean findLargestValue) {
        logger.info((Object)("propertyName: " + propertyName));
        logger.info((Object)("escapeSpecialCharacters: " + escapeSpecialCharacters));
        logger.info((Object)("findLargestValue: " + findLargestValue));
        String value = "";
        try {
            InfoGluePrincipal infoGluePrincipal = this.getInfoGluePrincipal();
            LanguageVO languageVO = (LanguageVO)LanguageController.getController().getLanguageVOList().get(0);
            value = InfoGluePrincipalControllerProxy.getController().getPrincipalPropertyValue(infoGluePrincipal, propertyName, languageVO.getId(), null, false, escapeSpecialCharacters, findLargestValue);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get property " + propertyName + " from infoGluePrincipal:" + e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public Map getPrincipalPropertyHashValues(String propertyName, boolean escapeSpecialCharacters) {
        Map value = new HashMap();
        try {
            InfoGluePrincipal infoGluePrincipal = this.getInfoGluePrincipal();
            LanguageVO languageVO = (LanguageVO)LanguageController.getController().getLanguageVOList().get(0);
            value = InfoGluePrincipalControllerProxy.getController().getPrincipalPropertyHashValues(infoGluePrincipal, propertyName, languageVO.getId(), null, false, escapeSpecialCharacters);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get property " + propertyName + " from infoGluePrincipal:" + e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public Principal getAnonymousPrincipal() throws SystemException {
        Principal principal = null;
        try {
            principal = (Principal)CacheController.getCachedObject("userCache", "anonymous");
            if (principal == null) {
                HashMap<String, Object> arguments = new HashMap<String, Object>();
                arguments.put("j_username", CmsPropertyHandler.getAnonymousUser());
                arguments.put("j_password", CmsPropertyHandler.getAnonymousPassword());
                arguments.put("ticket", this.getHttpSession().getAttribute("ticket"));
                principal = ExtranetController.getController().getAuthenticatedPrincipal(arguments);
                if (principal != null) {
                    CacheController.cacheObject("userCache", "anonymous", principal);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)"There was no anonymous user found in the system. There must be - add the user anonymous/anonymous and try again.", (Throwable)e);
            throw new SystemException("There was no anonymous user found in the system. There must be - add the user anonymous/anonymous and try again.", e);
        }
        return principal;
    }

    public Principal getInfoGluePrincipal(String userName) throws SystemException {
        Principal principal = null;
        try {
            principal = (Principal)CacheController.getCachedObject("userCache", userName);
            if (principal == null && (principal = UserControllerProxy.getController().getUser(userName)) != null) {
                CacheController.cacheObject("userCache", "anonymous", principal);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"There was no anonymous user found in the system. There must be - add the user anonymous/anonymous and try again.", (Throwable)e);
            throw new SystemException("There was no anonymous user found in the system. There must be - add the user anonymous/anonymous and try again.", e);
        }
        return principal;
    }

    public boolean hasAccessTo(String interceptionPointName) {
        logger.info((Object)("Checking if " + this.getUserName() + " has access to " + interceptionPointName));
        try {
            return AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), interceptionPointName);
        }
        catch (SystemException e) {
            logger.warn((Object)"Error checking access rights", (Throwable)e);
            return false;
        }
    }

    public boolean hasAccessTo(String interceptionPointName, boolean returnSuccessIfInterceptionPointNotDefined) {
        logger.info((Object)("Checking if " + this.getUserName() + " has access to " + interceptionPointName));
        try {
            return AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), interceptionPointName, returnSuccessIfInterceptionPointNotDefined);
        }
        catch (SystemException e) {
            logger.warn((Object)"Error checking access rights", (Throwable)e);
            return false;
        }
    }

    public boolean hasAccessTo(String interceptionPointName, String extraParameter) {
        logger.info((Object)("Checking if " + this.getUserName() + " has access to " + interceptionPointName + " with extraParameter " + extraParameter));
        try {
            return AccessRightController.getController().getIsPrincipalAuthorized(this.getInfoGluePrincipal(), interceptionPointName, extraParameter);
        }
        catch (SystemException e) {
            logger.warn((Object)"Error checking access rights", (Throwable)e);
            return false;
        }
    }

    public String getUserName() {
        return this.getInfoGluePrincipal().getName();
    }

    protected final String getSingleParameter(String parameterName) {
        return (String)ActionContext.getSingleValueParameters().get(parameterName);
    }

    protected final String getParameter(String parameterName) {
        return (String)ActionContext.getParameters().get(parameterName);
    }

    public final Integer getUserUploadMaxSize() {
        String userUploadMaxSize = this.getPrincipalPropertyValue("fileUploadMaximumSize", false, true);
        if (userUploadMaxSize != null && !userUploadMaxSize.equals("") && !userUploadMaxSize.equals("-1")) {
            try {
                Integer userUploadMaxSizeInteger = new Integer(userUploadMaxSize);
                return userUploadMaxSizeInteger;
            }
            catch (Exception e) {
                return this.getUploadMaxSize();
            }
        }
        return this.getUploadMaxSize();
    }

    public static InfoGluePrincipal getSessionInfoGluePrincipal() {
        InfoGluePrincipal infoGluePrincipal = null;
        try {
            infoGluePrincipal = (InfoGluePrincipal)ActionContext.getRequest().getSession().getAttribute("org.infoglue.cms.security.user");
        }
        catch (Exception e) {
            logger.warn((Object)("Problem getting principal from session:" + e.getMessage()));
        }
        return infoGluePrincipal;
    }

    public final Integer getUploadMaxSize() {
        Integer maxSize = new Integer(Integer.MAX_VALUE);
        try {
            String maxSizeStr = Configuration.getString((String)"webwork.multipart.maxSize");
            if (maxSizeStr != null) {
                maxSize = new Integer(maxSizeStr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return maxSize;
    }

    public String getColorScheme() {
        return this.colorScheme;
    }

    public void setColorScheme(String colorScheme) {
        this.colorScheme = colorScheme;
    }

    public String encode(String value) {
        return this.getResponse().encodeUrl(value);
    }

    public String getComponentRendererUrl() {
        return CmsPropertyHandler.getComponentRendererUrl();
    }

    public String getComponentRendererAction() {
        return CmsPropertyHandler.getComponentRendererAction();
    }

    public String getCMSBaseUrl() {
        return CmsPropertyHandler.getCmsBaseUrl();
    }

    public String getDisableImageEditor() {
        return CmsPropertyHandler.getDisableImageEditor();
    }

    public String getDisableCustomIcons() {
        return CmsPropertyHandler.getDisableCustomIcons();
    }

    public String getWorkingStyleInformation() {
        return CmsPropertyHandler.getWorkingStyleInformation();
    }

    public String getFinalStyleInformation() {
        return CmsPropertyHandler.getFinalStyleInformation();
    }

    public String getPublishStyleInformation() {
        return CmsPropertyHandler.getPublishStyleInformation();
    }

    public String getPublishedStyleInformation() {
        return CmsPropertyHandler.getPublishedStyleInformation();
    }

    public Map getCustomContentTypeIcons() {
        return CmsPropertyHandler.getCustomContentTypeIcons();
    }

    public String getEnableDateTimeDirectEditing() {
        return CmsPropertyHandler.getEnableDateTimeDirectEditing();
    }

    public String getAllowPublicationEventFilter() {
        return CmsPropertyHandler.getAllowPublicationEventFilter();
    }

    public Locale getLocale() {
        return this.getSession().getLocale();
    }

    public Integer getToolId() {
        return this.getSession().getToolId();
    }

    public String getLanguageCode() {
        return this.getSession().getLocale().getLanguage();
    }

    public void setLanguageCode(String languageCode) {
        this.getSession().setLocale(new Locale(languageCode));
    }

    public void setToolId(Integer toolId) {
        this.getSession().setToolId(toolId);
    }

    public void beginTransaction(Database db) throws SystemException {
        try {
            db.begin();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("An error occurred when we tried to begin an transaction. Reason:" + e.getMessage(), e);
        }
    }

    public void closeTransaction(Database db) throws SystemException {
        this.rollbackTransaction(db);
    }

    public void commitTransaction(Database db) throws SystemException {
        try {
            try {
                if (db.isActive()) {
                    db.commit();
                }
            }
            catch (Exception e) {
                throw new SystemException("An error occurred when we tried to commit an transaction. Reason:" + e.getMessage(), e);
            }
        }
        finally {
            this.closeDatabase(db);
        }
    }

    public void rollbackTransaction(Database db) throws SystemException {
        try {
            try {
                if (db.isActive()) {
                    db.rollback();
                }
            }
            catch (Exception e) {
                logger.warn((Object)("An error occurred when we tried to rollback an transaction. Reason:" + e.getMessage()));
                this.closeDatabase(db);
            }
        }
        finally {
            this.closeDatabase(db);
        }
    }

    public void closeDatabase(Database db) throws SystemException {
        try {
            db.close();
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred when we closed the database. Reason:" + e.getMessage()));
            throw new SystemException("An error occurred when we tried to close a database. Reason:" + e.getMessage(), e);
        }
    }

    public List<LinkBean> getActionLinks(String aUserSessionKey) {
        String key = String.valueOf(aUserSessionKey) + "_actionLinks";
        return (List)this.getRequest().getSession().getAttribute(key);
    }

    public void setActionLinks(String aUserSessionKey, List<LinkBean> actionLinks) {
        String key = String.valueOf(aUserSessionKey) + "_actionLinks";
        this.getRequest().getSession().setAttribute(key, actionLinks);
    }

    public void addActionLink(String aUserSessionKey, LinkBean aLinkBean) {
        List<LinkBean> actionLinks = this.getActionLinks(aUserSessionKey);
        if (actionLinks == null) {
            actionLinks = new ArrayList<LinkBean>();
        }
        actionLinks.add(aLinkBean);
        this.setActionLinks(aUserSessionKey, actionLinks);
    }

    public void setActionMessage(String aUserSessionKey, String actionMessage) {
        String key = String.valueOf(aUserSessionKey) + "_actionMessage";
        this.getRequest().getSession().setAttribute(key, (Object)actionMessage);
    }

    public String getActionMessage(String aUserSessionKey) {
        String key = String.valueOf(aUserSessionKey) + "_actionMessage";
        return (String)this.getRequest().getSession().getAttribute(key);
    }

    public boolean getDisableCloseButton() {
        String disableCloseButton = this.getRequest().getParameter("disableCloseButton");
        if (disableCloseButton != null && !disableCloseButton.equals("")) {
            return Boolean.parseBoolean(disableCloseButton);
        }
        return false;
    }
}

