/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.common.actions;

import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.exception.ConfigurationError;
import webwork.util.ServletValueStack;

public class ExtendedRedirect
extends InfoGlueAbstractAction {
    private static final long serialVersionUID = -8254805372363786462L;
    private static final String UNPARSED_PARAMETER_DELIMITER = "#";
    private String unparsedURL;

    public void setUrl(String unparsedURL) {
        this.unparsedURL = unparsedURL;
    }

    public String doExecute() throws Exception {
        this.validateUnparsedURL();
        this.redirect();
        return "none";
    }

    private void validateUnparsedURL() {
        if (this.unparsedURL == null || this.unparsedURL.trim().length() == 0) {
            throw new ConfigurationError("No url/empty url specified for ExtendedRedirect.action");
        }
    }

    private void redirect() throws Exception {
        String url = this.getResponse().encodeRedirectURL(this.parse(this.unparsedURL));
        this.getResponse().sendRedirect(url);
    }

    private String parse(String unparsedURL) {
        StringTokenizer st = new StringTokenizer(unparsedURL.trim(), UNPARSED_PARAMETER_DELIMITER);
        StringBuffer sb = new StringBuffer(st.nextToken());
        sb.append(st.hasMoreTokens() ? "?" : "");
        while (st.hasMoreTokens()) {
            sb.append(this.createParameterString(st.nextToken()));
            sb.append(st.hasMoreTokens() ? "&" : "");
        }
        return sb.toString();
    }

    private String createParameterString(String name) {
        return String.valueOf(name) + "=" + this.getValueFromCallingAction(name);
    }

    private String getValueFromCallingAction(String fieldName) {
        Object value = ServletValueStack.getStack((ServletRequest)this.getRequest()).findValue(fieldName);
        if (value == null) {
            value = this.getRequest().getParameter(fieldName);
        }
        if (value == null) {
            throw new ConfigurationError("Unable to find the value for the parameter [" + fieldName + "].");
        }
        return value.toString();
    }
}

