/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.common.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class Errors {
    private final Map errors = new HashMap();

    public final boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public final boolean hasErrors(String fieldName) {
        return this.errors.containsKey(fieldName);
    }

    public final Collection getErrors(String fieldName) {
        return (Collection)this.errors.get(fieldName);
    }

    public final Collection getAllErrors() {
        return this.errors.values();
    }

    public final void addError(String fieldName, String errorMessage) {
        if (this.getErrors(fieldName) == null) {
            this.errors.put(fieldName, new ArrayList());
        }
        this.getErrors(fieldName).add(errorMessage);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("<Errors>[ ");
        Iterator fieldNames = this.errors.keySet().iterator();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            Iterator errorMessages = this.getErrors(fieldName).iterator();
            sb.append(String.valueOf(fieldName) + "=> { ");
            sb.append(this.toString(errorMessages));
            sb.append("}" + (fieldNames.hasNext() ? ", " : " "));
        }
        sb.append("]");
        return sb.toString();
    }

    private String toString(Iterator errorMessages) {
        StringBuffer sb = new StringBuffer();
        while (errorMessages.hasNext()) {
            String errorMessage = (String)errorMessages.next();
            sb.append("\"" + errorMessage + "\"" + (errorMessages.hasNext() ? ", " : " "));
        }
        return sb.toString();
    }
}

