/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.common.actions;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;

public final class Error {
    private Throwable throwable;
    private Throwable cause;

    public Error(Throwable throwable, Throwable cause) {
        this.throwable = throwable;
        this.cause = cause;
    }

    public String getName() {
        String fullyQualifiedName = this.throwable.getClass().getName();
        int index = fullyQualifiedName.lastIndexOf(".") == -1 ? 0 : fullyQualifiedName.lastIndexOf(".") + 1;
        return fullyQualifiedName.substring(index);
    }

    public String getMessage() {
        return this.throwable.getMessage();
    }

    public String getStackTrace() {
        return this.getStackTrace(this.throwable);
    }

    public boolean hasCause() {
        return this.cause != null;
    }

    public String getCauseMessage() {
        return this.hasCause() ? this.cause.getMessage() : "";
    }

    public String getCauseStackTrace() {
        return this.hasCause() ? this.getStackTrace(this.cause) : "";
    }

    private String getStackTrace(Throwable throwable) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(this.stackTraceToString(throwable), "\n");
        while (st.hasMoreTokens()) {
            sb.append(String.valueOf(st.nextToken()) + "<br/>");
        }
        return sb.toString();
    }

    private String stackTraceToString(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }
}

