/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.common.actions;

import javax.servlet.ServletRequest;
import org.infoglue.cms.applications.common.actions.InfoGlueAbstractAction;
import org.infoglue.cms.exception.ConfigurationError;
import webwork.util.ServletValueStack;

public class ConfirmRedirect
extends InfoGlueAbstractAction {
    private static final long serialVersionUID = 8512298644737456785L;
    private String unparsedURL;

    public void setUrl(String unparsedURL) {
        this.unparsedURL = unparsedURL;
    }

    public String doExecute() throws Exception {
        this.validateUnparsedURL();
        this.redirect();
        return "success";
    }

    private void validateUnparsedURL() {
        if (this.unparsedURL == null || this.unparsedURL.trim().length() == 0) {
            throw new ConfigurationError("No url/empty url specified for ExtendedRedirect.action");
        }
    }

    private void redirect() throws Exception {
        String url = this.getValueFromCallingAction(this.unparsedURL);
        this.getResponse().sendRedirect(url);
    }

    private String getValueFromCallingAction(String fieldName) {
        Object value = ServletValueStack.getStack((ServletRequest)this.getRequest()).findValue(fieldName);
        if (value == null) {
            value = this.getRequest().getParameter(fieldName);
        }
        if (value == null) {
            throw new ConfigurationError("Unable to find the value for the parameter [" + fieldName + "].");
        }
        return value.toString();
    }
}

