/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.common.actions;

import java.util.Locale;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.actions.AbstractAction;
import org.infoglue.cms.applications.common.actions.Errors;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.util.StringManager;
import org.infoglue.cms.util.StringManagerFactory;
import webwork.action.CommandDriven;

public abstract class AbstractFormAction
extends AbstractAction
implements CommandDriven {
    private static final Logger logger = Logger.getLogger((String)AbstractFormAction.class.getName());
    private Errors errors = new Errors();

    public Errors getErrors() {
        return this.errors;
    }

    public String execute() throws Exception {
        try {
            return super.execute();
        }
        catch (ConstraintException e) {
            this.setErrors(e);
            return "input";
        }
    }

    private void setErrors(ConstraintException exception) {
        Locale locale = this.getSession().getLocale();
        ConstraintException ce = exception;
        while (ce != null) {
            String fieldName = ce.getFieldName();
            String errorCode = ce.getErrorCode();
            String localizedErrorMessage = this.getLocalizedErrorMessage(locale, errorCode);
            this.getErrors().addError(fieldName, localizedErrorMessage);
            ce = ce.getChainedException();
        }
        logger.debug((Object)this.getErrors().toString());
    }

    private String getLocalizedErrorMessage(Locale locale, String errorCode) {
        StringManager stringManager = StringManagerFactory.getPresentationStringManager("org.infoglue.cms.entities", locale);
        return stringManager.getString(errorCode);
    }
}

