/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.common;

import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.util.CacheController;

public class VisualFormatter {
    private static final Logger logger = Logger.getLogger((String)VisualFormatter.class.getName());

    public String formatDate(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        String dateString = formatter.format(date);
        return dateString;
    }

    public String formatDate(Date date, Locale locale, String pattern) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, locale);
        String dateString = formatter.format(date);
        return dateString;
    }

    public Date parseDate(String dateString, String pattern) {
        if (dateString == null) {
            return new Date();
        }
        Date date = new Date();
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(pattern);
            date = formatter.parse(dateString);
        }
        catch (Exception e) {
            logger.info((Object)("Error parsing date:" + dateString));
        }
        return date;
    }

    public Date parseDate(String dateString, Locale locale, String pattern) {
        if (dateString == null) {
            return new Date();
        }
        Date date = new Date();
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(pattern, locale);
            date = formatter.parse(dateString);
        }
        catch (Exception e) {
            logger.info((Object)("Error parsing date:" + dateString));
        }
        return date;
    }

    public final String escapeHTML(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        int i = 0;
        while (i < n) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public final String escapeHTMLforXMLService(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        int i = 0;
        while (i < n) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '\u00e0': {
                    sb.append("&agrave;");
                    break;
                }
                case '\u00c0': {
                    sb.append("&Agrave;");
                    break;
                }
                case '\u00e2': {
                    sb.append("&acirc;");
                    break;
                }
                case '\u00c2': {
                    sb.append("&Acirc;");
                    break;
                }
                case '\u00e4': {
                    sb.append("&auml;");
                    break;
                }
                case '\u00c4': {
                    sb.append("&Auml;");
                    break;
                }
                case '\u00e5': {
                    sb.append("&aring;");
                    break;
                }
                case '\u00c5': {
                    sb.append("&Aring;");
                    break;
                }
                case '\u00e6': {
                    sb.append("&aelig;");
                    break;
                }
                case '\u00c6': {
                    sb.append("&AElig;");
                    break;
                }
                case '\u00e7': {
                    sb.append("&ccedil;");
                    break;
                }
                case '\u00c7': {
                    sb.append("&Ccedil;");
                    break;
                }
                case '\u00e9': {
                    sb.append("&eacute;");
                    break;
                }
                case '\u00c9': {
                    sb.append("&Eacute;");
                    break;
                }
                case '\u00e8': {
                    sb.append("&egrave;");
                    break;
                }
                case '\u00f2': {
                    sb.append("&ograve;");
                    break;
                }
                case '\u00c8': {
                    sb.append("&Egrave;");
                    break;
                }
                case '\u00ea': {
                    sb.append("&ecirc;");
                    break;
                }
                case '\u00ca': {
                    sb.append("&Ecirc;");
                    break;
                }
                case '\u00eb': {
                    sb.append("&euml;");
                    break;
                }
                case '\u00cb': {
                    sb.append("&Euml;");
                    break;
                }
                case '\u00ef': {
                    sb.append("&iuml;");
                    break;
                }
                case '\u00cf': {
                    sb.append("&Iuml;");
                    break;
                }
                case '\u00f4': {
                    sb.append("&ocirc;");
                    break;
                }
                case '\u00d4': {
                    sb.append("&Ocirc;");
                    break;
                }
                case '\u00f6': {
                    sb.append("&ouml;");
                    break;
                }
                case '\u00d6': {
                    sb.append("&Ouml;");
                    break;
                }
                case '\u00f8': {
                    sb.append("&oslash;");
                    break;
                }
                case '\u00d8': {
                    sb.append("&Oslash;");
                    break;
                }
                case '\u00df': {
                    sb.append("&szlig;");
                    break;
                }
                case '\u00f9': {
                    sb.append("&ugrave;");
                    break;
                }
                case '\u00d9': {
                    sb.append("&Ugrave;");
                    break;
                }
                case '\u00fb': {
                    sb.append("&ucirc;");
                    break;
                }
                case '\u00db': {
                    sb.append("&Ucirc;");
                    break;
                }
                case '\u00fc': {
                    sb.append("&uuml;");
                    break;
                }
                case '\u00dc': {
                    sb.append("&Uuml;");
                    break;
                }
                case '\u00ae': {
                    sb.append("&reg;");
                    break;
                }
                case '\u00a9': {
                    sb.append("&copy;");
                    break;
                }
                case '\u20ac': {
                    sb.append("&euro;");
                    break;
                }
                case '\'': {
                    sb.append("&#146;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public final String escapeExtendedHTML(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        int i = 0;
        while (i < n) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '\'': {
                    sb.append("&#146;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public final String escapeForJavascripts(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        int i = 0;
        while (i < n) {
            char c = s.charAt(i);
            if (c == '\'') {
                sb.append("\\'");
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public final String cleanForJavascriptStrings(String s) {
        if (s == null) {
            return null;
        }
        String lineSep = System.getProperty("line.separator");
        s = s.replaceAll(lineSep, "<br/>");
        s = s.replaceAll("\n", "<br/>");
        s = s.replaceAll("\r", "<br/>");
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        int i = 0;
        while (i < n) {
            char c = s.charAt(i);
            switch (c) {
                case '\'': {
                    sb.append("\\'");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public final String cleanForJavascriptStrings(String s, String lineReplaceString) {
        if (s == null) {
            return null;
        }
        String lineSep = System.getProperty("line.separator");
        if (lineSep != null) {
            s = s.replaceAll(lineSep, lineReplaceString);
        }
        s = s.replaceAll("\n", lineReplaceString);
        s = s.replaceAll("\r", lineReplaceString);
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        int i = 0;
        while (i < n) {
            char c = s.charAt(i);
            switch (c) {
                case '\'': {
                    sb.append("\\'");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public final String escapeForAdvancedJavascripts(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        int i = 0;
        while (i < n) {
            char c = s.charAt(i);
            switch (c) {
                case '\'': {
                    sb.append("\\'");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public final String replaceNonAscii(String s, char character) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        int i = 0;
        while (i < n) {
            char c = s.charAt(i);
            if (c < '\u0080' && c > ' ') {
                if (Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '.') {
                    sb.append(c);
                } else {
                    sb.append(character);
                }
            } else {
                sb.append(character);
            }
            ++i;
        }
        return sb.toString();
    }

    public final String replaceNiceURINonAsciiWithSpecifiedChars(String s, char defaultCharacter) {
        if (s == null) {
            return null;
        }
        boolean toLowerCase = CmsPropertyHandler.getNiceURIUseLowerCase();
        Properties properties = CmsPropertyHandler.getCharacterReplacingMapping();
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        int i = 0;
        while (i < n) {
            String replaceChar;
            char c = s.charAt(i);
            if (c < '\u0080' && c > ' ') {
                if (Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '.') {
                    sb.append(c);
                } else {
                    replaceChar = properties.getProperty("" + c);
                    if (replaceChar != null && !replaceChar.equals("")) {
                        sb.append(replaceChar);
                    } else {
                        sb.append(defaultCharacter);
                    }
                }
            } else {
                replaceChar = properties.getProperty("" + c);
                if (replaceChar != null && !replaceChar.equals("")) {
                    sb.append(replaceChar);
                } else {
                    sb.append(defaultCharacter);
                }
            }
            ++i;
        }
        return toLowerCase ? sb.toString().toLowerCase() : sb.toString();
    }

    public final String encode(String s) throws Exception {
        if (s == null) {
            return null;
        }
        String encodedString = (String)CacheController.getCachedObjectFromAdvancedCache("encodedStringsCache", s);
        if (encodedString == null) {
            encodedString = URLEncoder.encode(s, "UTF-8");
            CacheController.cacheObjectInAdvancedCache("encodedStringsCache", s, encodedString, null, false);
        }
        return encodedString;
    }

    public final String encodeURI(String s) throws Exception {
        if (s == null) {
            return null;
        }
        String encoding = CmsPropertyHandler.getURIEncoding();
        String encodedString = (String)CacheController.getCachedObjectFromAdvancedCache("encodedStringsCache", s);
        if (encodedString == null) {
            encodedString = URLEncoder.encode(s, encoding);
            CacheController.cacheObjectInAdvancedCache("encodedStringsCache", s, encodedString, null, false);
        }
        return encodedString;
    }

    public final String encodeURI(String s, String encoding) throws Exception {
        if (s == null) {
            return null;
        }
        String encodedString = (String)CacheController.getCachedObjectFromAdvancedCache("encodedStringsCache", s);
        if (encodedString == null) {
            encodedString = URLEncoder.encode(s, encoding);
            CacheController.cacheObjectInAdvancedCache("encodedStringsCache", s, encodedString, null, false);
        }
        return encodedString;
    }

    public String formatFileSize(Object fileSizeObject) {
        if (fileSizeObject == null) {
            return "";
        }
        String fileSizeString = "";
        Integer fileSize = null;
        if (fileSizeObject instanceof String) {
            fileSize = new Integer((String)fileSizeObject);
        } else if (fileSizeObject instanceof Integer) {
            fileSize = (Integer)fileSizeObject;
        }
        fileSizeString = fileSize >= 1000000000 ? fileSize / 1000000000 + " GB" : (fileSize >= 1000000 ? fileSize / 1000000 + " MB" : (fileSize >= 1000 ? fileSize / 1000 + " KB" : fileSize + " Bytes"));
        return fileSizeString;
    }
}

