/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.common;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.infoglue.cms.exception.ConstraintException;

public class ValueConverter {
    public static final boolean isDate(String value) {
        return ValueConverter.toDate(value) != null;
    }

    public static final Date toDate(String value) {
        return new Date();
    }

    public static final Date getDate(String dateString, String fieldName) throws ConstraintException {
        Date publishDate = null;
        try {
            publishDate = ValueConverter.toDate(dateString, "yyyy-MM-dd");
        }
        catch (Exception e) {
            throw new ConstraintException(fieldName, "305");
        }
        return publishDate;
    }

    public static final Date toDate(String dateString, String pattern) throws Exception {
        if (dateString == null || dateString.length() == 0) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        return formatter.parse(dateString);
    }

    public static final boolean isBoolean(String value) {
        return ValueConverter.toBoolean(value) != null;
    }

    public static final Boolean toBoolean(String value) {
        return Boolean.valueOf(value);
    }

    public static final boolean isNonNegativeInteger(String value) {
        return ValueConverter.toNonNegativeInteger(value) != null;
    }

    public static final Integer toNonNegativeInteger(String value) {
        try {
            int intValue = Integer.parseInt(value);
            return intValue < 0 ? null : new Integer(intValue);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static final boolean isNonNegativeFloat(String value) {
        return ValueConverter.toNonNegativeFloat(value) != null;
    }

    public static final Float toNonNegativeFloat(String value) {
        try {
            float floatValue = Float.parseFloat(value);
            return (double)floatValue < 0.0 ? null : new Float(floatValue);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public List getListFromArray(String[] strings) {
        return Arrays.asList(strings);
    }
}

