/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.common;

import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.infoglue.cms.entities.management.SystemUser;
import org.infoglue.cms.security.InfoGluePrincipal;
import webwork.action.ActionContext;
import webwork.action.factory.SessionMap;

public class Session {
    public static final String LOCALE = "locale";
    private static final String USER = "user";
    private static final String IG_PRINCIPAL = "org.infoglue.cms.security.user";
    public static final String TOOL_ID = "toolId";
    private Map sessionDelegate;

    public Session() {
        this(ActionContext.getSession());
    }

    public Session(Map session) {
        this.sessionDelegate = session;
    }

    public Session(HttpSession httpSession) {
        this.sessionDelegate = new SessionMap(httpSession);
    }

    public final Locale getLocale() {
        if (this.sessionDelegate.get(LOCALE) == null) {
            this.setLocale(Locale.ENGLISH);
        }
        return (Locale)this.sessionDelegate.get(LOCALE);
    }

    public final Integer getToolId() {
        if (this.sessionDelegate.get(TOOL_ID) == null) {
            this.setToolId(new Integer(0));
        }
        return (Integer)this.sessionDelegate.get(TOOL_ID);
    }

    public final void setLocale(Locale locale) {
        this.sessionDelegate.put(LOCALE, locale);
    }

    public final void setToolId(Integer toolId) {
        this.sessionDelegate.put(TOOL_ID, toolId);
    }

    public final SystemUser getUser() {
        return (SystemUser)this.sessionDelegate.get(USER);
    }

    public final void setSystemUser(SystemUser systemUser) {
        this.sessionDelegate.put(USER, systemUser);
    }

    public InfoGluePrincipal getInfoGluePrincipal() {
        return (InfoGluePrincipal)this.sessionDelegate.get(IG_PRINCIPAL);
    }

    public void setInfoGluePrincipal(InfoGluePrincipal p) {
        this.sessionDelegate.put(IG_PRINCIPAL, p);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("<Session>\n");
        sb.append("  locale=[" + this.getLocale() + "]\n");
        sb.append("    user=[" + this.getUser() + "]\n");
        return sb.toString();
    }
}

