/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.applications.common;

import org.infoglue.cms.applications.common.ValueConverter;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class Form {
    private static final String ERROR_CODE = "306";

    private void validateField(boolean isIllegalValue, String fieldName, ConstraintExceptionBuffer ceb) {
        if (isIllegalValue) {
            ceb.add(new ConstraintException(fieldName, ERROR_CODE));
        }
    }

    protected void validateDateField(String value, String fieldName, ConstraintExceptionBuffer ceb) {
        this.validateField(!ValueConverter.isDate(value), fieldName, ceb);
    }

    protected void validateNonNegativeFloatField(String value, String fieldName, ConstraintExceptionBuffer ceb) {
        this.validateField(!ValueConverter.isNonNegativeFloat(value), fieldName, ceb);
    }

    protected void validateNonNegativeIntegerField(String value, String fieldName, ConstraintExceptionBuffer ceb) {
        this.validateField(!ValueConverter.isNonNegativeInteger(value), fieldName, ceb);
    }
}

