/*
 * Decompiled with CFR 0.152.
 */
package com.frovi.ss.Tree;

import com.frovi.ss.Tree.BaseNode;
import com.frovi.ss.Tree.INodeSupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class MakeTree {
    private boolean showTreeLines = true;
    private ArrayList ret = new ArrayList();
    private INodeSupplier nodeSupplier;
    private boolean showRoot = true;
    private int startLevel = -1;
    private Vector intTreeLines = new Vector(50, 10);

    public MakeTree(INodeSupplier nodeSupplier) {
        this.setNodeSupplier(nodeSupplier);
    }

    public Collection makeNodeList() {
        return this.makeNodeList("");
    }

    public Collection makeNodeList(String expString) {
        BaseNode root = this.nodeSupplier.getRootNode();
        root.setIsRoot(true);
        if (this.showRoot) {
            this.addNodeToList(root, this.startLevel, this.makeKey(root.getId()), true, true);
        }
        return this.makeNodeList(root.getId(), expString);
    }

    public Collection makeNodeList(Integer parentNode, String expString) {
        this.intTreeLines.setSize(50);
        this.FillTree(parentNode, this.startLevel, expString, new String(""));
        return this.ret;
    }

    public Collection makeNodeList(BaseNode parentNode, String expString) {
        this.intTreeLines.setSize(50);
        this.FillTree(parentNode.getId(), this.startLevel, expString, new String(""));
        return this.ret;
    }

    public void setNodeSupplier(INodeSupplier nodeSupplier) {
        this.nodeSupplier = nodeSupplier;
    }

    private String makeKey(Integer id) {
        return "/" + String.valueOf(id).trim() + "/";
    }

    private void FillTree(Integer parent, int level, String expkey, String makekey) {
        BaseNode thisNode;
        Collection leafs = new ArrayList();
        Collection roots = new ArrayList();
        ++level;
        try {
            roots = this.nodeSupplier.getChildContainerNodes(parent);
            leafs = this.nodeSupplier.getChildLeafNodes(parent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean blnHasDocs = leafs.size() > 0;
        String parentKey = this.makeKey(parent);
        makekey = String.valueOf(makekey) + parentKey;
        Iterator rIter = roots.iterator();
        while (rIter.hasNext()) {
            thisNode = (BaseNode)rIter.next();
            String nodeKey = this.makeKey(thisNode.getId());
            if (this.showTreeLines) {
                this.intTreeLines.add(level, new Integer(3));
                if (!rIter.hasNext() && !blnHasDocs) {
                    this.intTreeLines.remove(level);
                    this.intTreeLines.add(level, new Integer(2));
                }
            }
            if (expkey.indexOf(nodeKey) != -1) {
                this.addNodeToList(thisNode, level, makekey, true, true);
                if (this.showTreeLines) {
                    if (!rIter.hasNext() && !blnHasDocs) {
                        this.intTreeLines.remove(level);
                        this.intTreeLines.add(level, new Integer(0));
                    }
                    if ((Integer)this.intTreeLines.get(level) == 3) {
                        this.intTreeLines.remove(level);
                        this.intTreeLines.add(level, new Integer(1));
                    }
                }
                this.FillTree(thisNode.getId(), level, expkey, makekey);
                continue;
            }
            this.addNodeToList(thisNode, level, makekey, false, true);
        }
        if (blnHasDocs) {
            rIter = leafs.iterator();
            while (rIter.hasNext()) {
                thisNode = (BaseNode)rIter.next();
                if (this.showTreeLines) {
                    this.intTreeLines.remove(level);
                    this.intTreeLines.add(level, new Integer(3));
                    if (!rIter.hasNext()) {
                        this.intTreeLines.remove(level);
                        this.intTreeLines.add(level, new Integer(2));
                    }
                }
                this.addNodeToList(thisNode, level, "", false, false);
            }
        }
        this.intTreeLines.remove(level);
        this.intTreeLines.add(level, new Integer(0));
    }

    private void addNodeToList(BaseNode thisNode, int level, String makekey, boolean isOpen, boolean isContainer) {
        String newKey = makekey;
        String thisKey = this.makeKey(thisNode.getId());
        int cnt = 0;
        Vector tree = null;
        if (level > -1) {
            tree = new Vector(level);
        }
        Iterator i = this.intTreeLines.iterator();
        while (i.hasNext() && cnt <= level) {
            tree.add(cnt++, i.next());
        }
        if (!isOpen) {
            newKey = String.valueOf(newKey) + thisKey;
        }
        thisNode.setTreeStuff(tree);
        thisNode.setOpen(isOpen);
        thisNode.setThisKey(thisKey);
        thisNode.setOpenCloseKey(newKey);
        thisNode.setLevel(level);
        thisNode.setContainer(isContainer);
        try {
            if (isContainer && this.nodeSupplier.hasChildren()) {
                thisNode.setChildren(this.nodeSupplier.hasChildren(thisNode.getId()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ret.add(thisNode);
    }

    public boolean getShowRoot() {
        return this.showRoot;
    }

    public void setShowRoot(boolean showRoot) {
        this.showRoot = showRoot;
    }
}

