/*
 * Decompiled with CFR 0.152.
 */
package com.frovi.ss.Tree;

import com.frovi.ss.Tree.BaseNode;
import com.frovi.ss.Tree.INodeSupplier;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeControllerProxy;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.deliver.controllers.kernel.impl.simple.ContentDeliveryController;

public abstract class BaseNodeSupplier
implements INodeSupplier {
    private static final Logger logger = Logger.getLogger((String)BaseNodeSupplier.class.getName());
    private BaseNode rootNode = null;

    public boolean hasChildren() {
        return true;
    }

    public boolean hasChildren(Integer nodeId) throws SystemException, Exception {
        Collection tmp = this.getChildContainerNodes(nodeId);
        Collection tmp2 = this.getChildLeafNodes(nodeId);
        return tmp.size() + tmp2.size() > 0;
    }

    protected void setRootNode(BaseNode rootNode) {
        this.rootNode = rootNode;
    }

    public BaseNode getRootNode() {
        return this.rootNode;
    }

    public boolean hasAccessTo(String interceptionPointName, InfoGluePrincipal infoGluePrincipal, boolean acceptIfNotDefined) {
        logger.info((Object)("Checking if " + infoGluePrincipal.getName() + " has access to " + interceptionPointName + ". If not the interception point is defined we return true."));
        try {
            return AccessRightController.getController().getIsPrincipalAuthorized(infoGluePrincipal, interceptionPointName, acceptIfNotDefined);
        }
        catch (SystemException e) {
            logger.warn((Object)"Error checking access rights", (Throwable)e);
            return false;
        }
    }

    public boolean getHasUserContentAccess(InfoGluePrincipal infoGluePrincipal, Integer contentId) {
        boolean hasUserContentAccess = true;
        try {
            Database db = CastorDatabaseService.getDatabase();
            try {
                Integer protectedContentId;
                this.beginTransaction(db);
                if (contentId != null && (protectedContentId = ContentDeliveryController.getContentDeliveryController().getProtectedContentId(db, contentId)) != null && !AccessRightController.getController().getIsPrincipalAuthorized(infoGluePrincipal, "Content.Read", protectedContentId.toString())) {
                    hasUserContentAccess = false;
                }
                this.commitTransaction(db);
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
                this.rollbackTransaction(db);
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
        }
        return hasUserContentAccess;
    }

    public boolean getHasUserPageAccess(InfoGluePrincipal infoGluePrincipal, Integer siteNodeId) {
        boolean hasUserPageAccess = true;
        try {
            Database db = CastorDatabaseService.getDatabase();
            try {
                this.beginTransaction(db);
                Integer protectedSiteNodeVersionId = SiteNodeControllerProxy.getController().getProtectedSiteNodeVersionId(siteNodeId);
                if (protectedSiteNodeVersionId != null && !AccessRightController.getController().getIsPrincipalAuthorized(infoGluePrincipal, "SiteNodeVersion.Read", protectedSiteNodeVersionId.toString())) {
                    hasUserPageAccess = false;
                }
                this.commitTransaction(db);
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
                this.rollbackTransaction(db);
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
        }
        return hasUserPageAccess;
    }

    protected void beginTransaction(Database db) throws SystemException {
        try {
            db.begin();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("An error occurred when we tried to begin an transaction. Reason:" + e.getMessage(), e);
        }
    }

    protected void commitTransaction(Database db) throws SystemException {
        try {
            db.commit();
            db.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("An error occurred when we tried to commit an transaction. Reason:" + e.getMessage(), e);
        }
    }

    protected void rollbackTransaction(Database db) throws SystemException {
        try {
            if (db.isActive()) {
                db.rollback();
                db.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("An error occurred when we tried to rollback an transaction. Reason:" + e.getMessage(), e);
        }
    }
}

