/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.invoker.impl;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.UnavailableException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.pluto.Constants;
import org.apache.pluto.PortletContainerServices;
import org.apache.pluto.core.CoreUtils;
import org.apache.pluto.core.InternalPortletRequest;
import org.apache.pluto.core.InternalPortletResponse;
import org.apache.pluto.invoker.PortletInvoker;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.om.servlet.ServletDefinition;
import org.apache.pluto.services.log.LogService;
import org.apache.pluto.services.log.Logger;

public class PortletInvokerImpl
implements PortletInvoker {
    private ServletConfig servletConfig;
    private PortletDefinition portletDefinition;
    private Logger log = null;
    static /* synthetic */ Class class$0;

    public PortletInvokerImpl(PortletDefinition portletDefinition, ServletConfig servletConfig) {
        this.portletDefinition = portletDefinition;
        this.servletConfig = servletConfig;
    }

    public void action(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        this.invoke((PortletRequest)request, (PortletResponse)response, Constants.METHOD_ACTION);
    }

    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.invoke((PortletRequest)request, (PortletResponse)response, Constants.METHOD_RENDER);
    }

    public void load(PortletRequest request, RenderResponse response) throws PortletException {
        try {
            this.invoke(request, (PortletResponse)response, Constants.METHOD_NOOP);
        }
        catch (IOException e) {
            this.getLog().error("PortletInvokerImpl.load() - Error while dispatching portlet.", e);
            throw new PortletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void invoke(PortletRequest portletRequest, PortletResponse portletResponse, Integer methodID) throws PortletException, IOException {
        InternalPortletRequest internalPortletRequest = CoreUtils.getInternalRequest(portletRequest);
        InternalPortletResponse internalPortletResponse = CoreUtils.getInternalResponse(portletResponse);
        ServletRequest servletRequest = ((HttpServletRequestWrapper)internalPortletRequest).getRequest();
        ServletResponse servletResponse = ((HttpServletResponseWrapper)internalPortletResponse).getResponse();
        ServletDefinition servletDefinition = this.portletDefinition.getServletDefinition();
        this.getLog().info("servletDefinition:" + servletDefinition);
        ServletContext servletContext = this.servletConfig.getServletContext();
        this.getLog().info("servletContext:" + servletContext);
        RequestDispatcher dispatcher = servletDefinition.getRequestDispatcher(servletContext);
        this.getLog().info("dispatcher:" + dispatcher);
        if (dispatcher == null) {
            this.getLog().error("PortletInvokerImpl.action() - Unable to find RequestDispatcher.");
            throw new PortletException("Unable to find dispatcher for context: " + servletContext.getServletContextName());
        }
        try {
            try {
                servletRequest.setAttribute("org.apache.pluto.core.method", (Object)methodID);
                servletRequest.setAttribute("javax.portlet.request", (Object)portletRequest);
                servletRequest.setAttribute("javax.portlet.response", (Object)portletResponse);
                dispatcher.include(servletRequest, servletResponse);
            }
            catch (javax.servlet.UnavailableException e) {
                this.getLog().error("PortletInvokerImpl.invoke() - Error while dispatching portlet.", e);
                if (!e.isPermanent()) throw new UnavailableException(e.getMessage(), e.getUnavailableSeconds());
                throw new UnavailableException(e.getMessage());
            }
            catch (ServletException e) {
                if (e.getRootCause() != null) {
                    this.getLog().error("PortletInvokerImpl.render() - Error while dispatching portlet.", e.getRootCause());
                    if (!(e.getRootCause() instanceof PortletException)) throw new PortletException(e.getRootCause());
                    throw (PortletException)e.getRootCause();
                }
                this.getLog().error("PortletInvokerImpl.invoke() - Error while dispatching portlet.", e);
                throw new PortletException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            servletRequest.removeAttribute("org.apache.pluto.core.method");
            servletRequest.removeAttribute("javax.portlet.request");
            servletRequest.removeAttribute("javax.portlet.response");
            throw throwable;
        }
        {
            Object var12_15 = null;
            servletRequest.removeAttribute("org.apache.pluto.core.method");
            servletRequest.removeAttribute("javax.portlet.request");
            servletRequest.removeAttribute("javax.portlet.response");
            return;
        }
    }

    private Logger getLog() {
        if (this.log == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.apache.pluto.services.log.LogService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.log = ((LogService)PortletContainerServices.get(clazz)).getLogger(this.getClass());
        }
        return this.log;
    }
}

