/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.PortletContainerServices;
import org.apache.pluto.core.InternalActionResponse;
import org.apache.pluto.factory.PortletObjectAccess;
import org.apache.pluto.invoker.PortletInvoker;
import org.apache.pluto.invoker.PortletInvokerAccess;
import org.apache.pluto.om.window.PortletWindow;
import org.apache.pluto.services.PortletContainerEnvironment;
import org.apache.pluto.services.information.DynamicInformationProvider;
import org.apache.pluto.services.information.InformationProviderAccess;
import org.apache.pluto.services.information.PortletURLProvider;
import org.apache.pluto.services.log.LogService;
import org.apache.pluto.services.log.Logger;

public class PortletContainerImpl
implements PortletContainer {
    private String uniqueContainerName;
    private boolean initialized;
    private static String CONTAINER_SUPPORTS_BUFFERING = "portletcontainer.supportsBuffering";
    private boolean supportsBuffering;
    private Logger log = null;
    static /* synthetic */ Class class$0;

    public void init(String uniqueContainerName, ServletConfig servletConfig, PortletContainerEnvironment environment, Properties properties) throws PortletContainerException {
        this.uniqueContainerName = uniqueContainerName;
        PortletContainerServices.createReference(uniqueContainerName, environment);
        this.initialized = true;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.pluto.services.log.LogService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = ((LogService)environment.getContainerService(clazz)).getLogger(this.getClass());
        Boolean b = (Boolean)properties.get(CONTAINER_SUPPORTS_BUFFERING);
        if (b == null) {
            this.log.warn("org.apache.pluto.PortletContainerImpl#init(): Couldn't retrieve parameter \"" + CONTAINER_SUPPORTS_BUFFERING + "\" from" + "passed properties object. Falling back to default value \"FALSE\"");
            this.supportsBuffering = false;
        } else {
            this.supportsBuffering = b;
        }
    }

    public void shutdown() throws PortletContainerException {
        PortletContainerServices.destroyReference(this.uniqueContainerName);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void renderPortlet(PortletWindow portletWindow, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws PortletException, IOException, PortletContainerException {
        PortletContainerServices.prepare(this.uniqueContainerName);
        PortletInvoker invoker = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("PortletContainerImpl.portletService(" + portletWindow.getId() + ") called.");
        }
        try {
            RenderRequest renderRequest = PortletObjectAccess.getRenderRequest(portletWindow, servletRequest, servletResponse);
            this.log.debug("renderRequest:" + renderRequest);
            RenderResponse renderResponse = PortletObjectAccess.getRenderResponse(portletWindow, servletRequest, servletResponse, this.supportsBuffering);
            this.log.debug("renderResponse:" + renderResponse);
            invoker = PortletInvokerAccess.getPortletInvoker(portletWindow.getPortletEntity().getPortletDefinition());
            this.log.debug("invoker:" + invoker);
            invoker.render(renderRequest, renderResponse);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            PortletInvokerAccess.releasePortletInvoker(invoker);
            PortletContainerServices.release();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        PortletInvokerAccess.releasePortletInvoker(invoker);
        PortletContainerServices.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void processPortletAction(PortletWindow portletWindow, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws PortletException, IOException, PortletContainerException {
        PortletContainerServices.prepare(this.uniqueContainerName);
        PortletInvoker invoker = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("PortletContainerImpl.performPortletAction(" + portletWindow.getId() + ") called.");
        }
        String location = null;
        InternalActionResponse _actionResponse = null;
        ActionRequest actionRequest = null;
        try {
            try {
                actionRequest = PortletObjectAccess.getActionRequest(portletWindow, servletRequest, servletResponse);
                ActionResponse actionResponse = PortletObjectAccess.getActionResponse(portletWindow, servletRequest, servletResponse);
                invoker = PortletInvokerAccess.getPortletInvoker(portletWindow.getPortletEntity().getPortletDefinition());
                _actionResponse = (InternalActionResponse)actionResponse;
                invoker.action(actionRequest, actionResponse);
                location = _actionResponse.getRedirectLocation();
            }
            catch (PortletException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            Object var9_14 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            try {
                this.redirect(location, portletWindow, servletRequest, servletResponse, _actionResponse);
                Object var11_18 = null;
            }
            catch (Throwable throwable2) {
                Object var11_17 = null;
                PortletInvokerAccess.releasePortletInvoker(invoker);
                PortletContainerServices.release();
                throw throwable2;
            }
            PortletInvokerAccess.releasePortletInvoker(invoker);
            PortletContainerServices.release();
            throw throwable;
        }
        try {}
        catch (Throwable throwable) {
            Object var11_19 = null;
            PortletInvokerAccess.releasePortletInvoker(invoker);
            PortletContainerServices.release();
            throw throwable;
        }
        this.redirect(location, portletWindow, servletRequest, servletResponse, _actionResponse);
        Object var11_20 = null;
        PortletInvokerAccess.releasePortletInvoker(invoker);
        PortletContainerServices.release();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void portletLoad(PortletWindow portletWindow, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws PortletException, PortletContainerException {
        PortletContainerServices.prepare(this.uniqueContainerName);
        PortletInvoker invoker = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("PortletContainerImpl.portletLoad(" + portletWindow.getId() + ") called.");
        }
        RenderRequest renderRequest = PortletObjectAccess.getRenderRequest(portletWindow, servletRequest, servletResponse);
        this.log.debug("renderRequest:" + renderRequest);
        RenderResponse renderResponse = PortletObjectAccess.getRenderResponse(portletWindow, servletRequest, servletResponse, this.supportsBuffering);
        this.log.debug("renderResponse:" + renderResponse);
        invoker = PortletInvokerAccess.getPortletInvoker(portletWindow.getPortletEntity().getPortletDefinition());
        this.log.debug("invoker:" + invoker);
        try {
            invoker.load((PortletRequest)renderRequest, renderResponse);
            this.log.debug("loaded:" + invoker);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            PortletInvokerAccess.releasePortletInvoker(invoker);
            PortletContainerServices.release();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        PortletInvokerAccess.releasePortletInvoker(invoker);
        PortletContainerServices.release();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected void redirect(String location, PortletWindow portletWindow, HttpServletRequest servletRequest, HttpServletResponse servletResponse, InternalActionResponse _actionResponse) throws IOException {
        if (location == null && _actionResponse != null) {
            DynamicInformationProvider provider = InformationProviderAccess.getDynamicProvider(servletRequest);
            PortletMode portletMode = provider.getPortletMode(portletWindow);
            WindowState windowState = provider.getWindowState(portletWindow);
            if (_actionResponse.getChangedPortletMode() != null) {
                portletMode = _actionResponse.getChangedPortletMode();
                InformationProviderAccess.getDynamicProvider(servletRequest).getPortletActionProvider(portletWindow).changePortletMode(portletMode);
            }
            if (_actionResponse.getChangedWindowState() != null) {
                windowState = _actionResponse.getChangedWindowState();
                InformationProviderAccess.getDynamicProvider(servletRequest).getPortletActionProvider(portletWindow).changePortletWindowState(windowState);
            }
            Map renderParameter = _actionResponse.getRenderParameters();
            PortletURLProvider redirectURL = provider.getPortletURLProvider(portletWindow);
            if (provider.getPortletMode(portletWindow) != null) {
                redirectURL.setPortletMode(portletMode);
            }
            if (provider.getWindowState(portletWindow) != null) {
                redirectURL.setWindowState(windowState);
            }
            if (servletRequest.isSecure()) {
                redirectURL.setSecure();
            }
            redirectURL.clearParameters();
            redirectURL.setParameters(renderParameter);
            location = servletResponse.encodeRedirectURL(redirectURL.toString());
        }
        HttpServletResponse redirectResponse = servletResponse;
        while (redirectResponse instanceof HttpServletResponseWrapper) {
            redirectResponse = (HttpServletResponse)((HttpServletResponseWrapper)redirectResponse).getResponse();
        }
        redirectResponse.sendRedirect(location);
    }
}

