/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portlet.admin.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.pluto.portlet.admin.PlutoAdminConstants;
import org.apache.pluto.portlet.admin.PlutoAdminException;
import org.apache.pluto.portlet.admin.PlutoAdminLogger;

public class PlutoAdminContext {
    private static final String CLASS_NAME = "PlutoAdminContext";
    private static String _containerHome;
    private static String _plutoHome;
    private static String _plutoContext;
    private static String _deploymentPath;
    private static Map _cache;
    private static PlutoAdminContext _instance;
    static /* synthetic */ Class class$org$apache$pluto$portlet$admin$util$PlutoAdminContext;

    private PlutoAdminContext() {
    }

    public static PlutoAdminContext getInstance() {
        return _instance;
    }

    public String getPageRegistryPath() {
        String path = this.getPlutoHome() + PlutoAdminConstants.FS + this.getRelDataDir() + PlutoAdminConstants.FS + PlutoAdminContext.getProperties().getProperty("pageregistry-file");
        return path;
    }

    public String getPortletEntityRegistryPath() {
        String path = this.getPlutoHome() + PlutoAdminConstants.FS + this.getRelDataDir() + PlutoAdminConstants.FS + PlutoAdminContext.getProperties().getProperty("portletentityregistry-file");
        return path;
    }

    public String getPlutoHome() {
        return _plutoHome;
    }

    public static Properties getProperties(String propFileName) {
        String METHOD_NAME = "getProperties(propFileName)";
        Properties props = null;
        props = (Properties)_cache.get(propFileName);
        if (props == null) {
            InputStream stream = (class$org$apache$pluto$portlet$admin$util$PlutoAdminContext == null ? (class$org$apache$pluto$portlet$admin$util$PlutoAdminContext = PlutoAdminContext.class$("org.apache.pluto.portlet.admin.util.PlutoAdminContext")) : class$org$apache$pluto$portlet$admin$util$PlutoAdminContext).getClassLoader().getResourceAsStream(propFileName);
            if (stream == null) {
                String logMsg = "Null InputStream. Please make sure the properties file exists and is in the classpath.";
                NullPointerException e = new NullPointerException(logMsg);
                PlutoAdminLogger.logError(CLASS_NAME, "getProperties(propFileName)", e);
                throw e;
            }
            props = new Properties();
            try {
                props.load(stream);
            }
            catch (IOException e) {
                PlutoAdminLogger.logError(CLASS_NAME, "getProperties(propFileName)", e);
                throw new PlutoAdminException(e);
            }
            _cache.put(propFileName, props);
        }
        return props;
    }

    public static Properties getProperties() {
        return PlutoAdminContext.getProperties("pluto-admin.properties");
    }

    private String getRelDataDir() {
        String dir = PlutoAdminContext.getProperties().getProperty("data-dir-relative-path");
        return dir;
    }

    public String getPortletContextsPath() {
        String path = this.getPlutoHome() + PlutoAdminConstants.FS + this.getRelDataDir() + PlutoAdminConstants.FS + PlutoAdminContext.getProperties().getProperty("portletcontexts-file");
        return path;
    }

    public static String getContainerHome() {
        return _containerHome;
    }

    public static void parseDeploymentPaths(String plutoHome) {
        String METHOD_NAME = "parseDeploymentPaths(plutoHome)";
        int lastSlash = 0;
        if (plutoHome == null) {
            _plutoHome = PlutoAdminContext.getProperties().getProperty("pluto-home");
            if (_plutoHome == null || _plutoHome.equals("")) {
                throw new PlutoAdminException("pluto-home needs to be set in pluto-admin.properties.");
            }
        } else if (plutoHome.lastIndexOf(PlutoAdminConstants.FS) == plutoHome.length() - 1) {
            lastSlash = plutoHome.lastIndexOf(PlutoAdminConstants.FS);
            _plutoHome = plutoHome.substring(0, lastSlash);
        } else {
            _plutoHome = plutoHome;
        }
        PlutoAdminLogger.logDebug(CLASS_NAME, "parseDeploymentPaths(plutoHome)", "Pluto home: " + _plutoHome);
        lastSlash = _plutoHome.lastIndexOf(PlutoAdminConstants.FS);
        _plutoContext = _plutoHome.substring(lastSlash + 1);
        PlutoAdminLogger.logDebug(CLASS_NAME, "parseDeploymentPaths(plutoHome)", "Pluto web context: " + _plutoContext);
        _deploymentPath = _plutoHome.substring(0, lastSlash);
        PlutoAdminLogger.logDebug(CLASS_NAME, "parseDeploymentPaths(plutoHome)", "Portlet deployment path: " + _deploymentPath);
        lastSlash = _deploymentPath.lastIndexOf(PlutoAdminConstants.FS);
        _containerHome = _deploymentPath.substring(0, lastSlash);
        PlutoAdminLogger.logDebug(CLASS_NAME, "parseDeploymentPaths(plutoHome)", "Container (Tomcat) home: " + _containerHome);
    }

    public static String getDeploymentPath() {
        return _deploymentPath;
    }

    public static String getPlutoWebContext() {
        return _plutoContext;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _cache = new HashMap();
        _instance = new PlutoAdminContext();
    }
}

