/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portlet.admin.taglib;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.pluto.portlet.admin.PlutoAdminConstants;
import org.apache.pluto.portlet.admin.bean.PortletMessage;
import org.apache.pluto.portlet.admin.bean.PortletMessageType;

public class MessageTag
extends TagSupport {
    private String message;
    private String messageType = "status";
    private String cssClass = "portlet-msg-info";
    public static final String MSG_ERROR_CSS_CLASS = "portlet-msg-error";
    public static final String MSG_INFO_CSS_CLASS = "portlet-msg-info";
    public static final String MSG_STATUS_CSS_CLASS = "portlet-msg-status";
    public static final String MSG_ALERT_CSS_CLASS = "portlet-msg-alert";
    public static final String MSG_SUCCESS_CSS_CLASS = "portlet-msg-success";

    public int doStartTag() throws JspException {
        PortletRequest request = (PortletRequest)this.pageContext.getRequest().getAttribute("javax.portlet.request");
        PortletSession session = request.getPortletSession();
        Throwable error = (Throwable)session.getAttribute("error");
        session.removeAttribute("error");
        PortletMessage oMsg = (PortletMessage)session.getAttribute("message");
        session.removeAttribute("message");
        try {
            JspWriter out = this.pageContext.getOut();
            if (this.message != null) {
                if (this.cssClass == null) {
                    this.cssClass = PortletMessageType.getTypeByName((String)this.messageType).CssClass;
                }
                out.print(this.wrapHtml(this.message, this.cssClass));
            } else if (oMsg != null) {
                out.print(this.wrapHtml(oMsg.getMessage(), oMsg.getType().CssClass));
            } else if (error != null) {
                StringBuffer sb = new StringBuffer();
                sb.append(error.getMessage());
                if (error.getCause() != null) {
                    sb.append("<br>Underlying Exception cause: ");
                    sb.append(error.getCause().getMessage());
                }
                out.print(this.wrapHtml(sb.toString(), MSG_ERROR_CSS_CLASS));
                out.println("<!-- " + PlutoAdminConstants.LS);
                PrintWriter writer = new PrintWriter((Writer)out, true);
                error.printStackTrace(writer);
                out.print(PlutoAdminConstants.LS + "-->");
            }
        }
        catch (IOException e) {
            throw new JspTagException("Error in tag MessageTag: " + e.toString());
        }
        return 0;
    }

    private String wrapHtml(String msg, String css) {
        StringBuffer sb = new StringBuffer();
        sb.append("<p class=\"" + css + "\">");
        sb.append(msg);
        sb.append("</p>");
        return sb.toString();
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }
}

