/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portlet.admin.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import org.apache.pluto.portalImpl.om.entity.impl.PortletApplicationEntityImpl;
import org.apache.pluto.portalImpl.om.entity.impl.PortletApplicationEntityListImpl;
import org.apache.pluto.portlet.admin.BaseAdminObject;
import org.apache.pluto.portlet.admin.PlutoAdminException;
import org.apache.pluto.portlet.admin.PlutoAdminLogger;
import org.apache.pluto.portlet.admin.model.PortletEntityRegistryXao;
import org.apache.pluto.portlet.admin.util.PortletApplicationEntityImplComparator;

public class PortletRegistryService
extends BaseAdminObject {
    private static final String CLASS_NAME = "PortletRegistryService";

    public PortletRegistryService() {
        super(CLASS_NAME);
    }

    public List getPageRegistryData(String prPath) {
        return null;
    }

    public List getPortletEntityRegistry(String perPath) {
        String METHOD_NAME = "getPortletEntityRegistry(perPath)";
        this.logMethodStart("getPortletEntityRegistry(perPath)");
        this.logParam("getPortletEntityRegistry(perPath)", "perPath", perPath);
        List alist = null;
        return alist;
    }

    public List getPortletPreferences(String perPath, String appId, String portletId) {
        String METHOD_NAME = "getPortletPreferences(perPath,appId,portletId)";
        this.logMethodStart("getPortletPreferences(perPath,appId,portletId)");
        List list = null;
        return list;
    }

    public List addPortletPreference(String perPath, String appId, String portletId) {
        String METHOD_NAME = "addPortletPreferences(perPath,appId,portletId)";
        this.logMethodStart("addPortletPreferences(perPath,appId,portletId)");
        List list = null;
        return list;
    }

    public static String getNextAppId() {
        Collection apps;
        String METHOD_NAME = "getNextAppId()";
        PlutoAdminLogger.logMethodStart(CLASS_NAME, "getNextAppId()");
        String appId = null;
        try {
            PortletEntityRegistryXao xao = new PortletEntityRegistryXao();
            apps = xao.getApplications();
        }
        catch (Exception e) {
            PlutoAdminLogger.logError(CLASS_NAME, "getNextAppId()", e);
            throw new PlutoAdminException(e);
        }
        ArrayList list = new ArrayList(apps);
        Iterator iter = list.iterator();
        int nNewId = 0;
        while (iter.hasNext()) {
            PortletApplicationEntityImpl app = (PortletApplicationEntityImpl)iter.next();
            String currAppId = app.getCastorId();
            int nCurrAppId = Integer.parseInt(currAppId);
            if (nNewId > nCurrAppId) continue;
            nNewId = nCurrAppId;
        }
        appId = Integer.toString(++nNewId);
        PlutoAdminLogger.logMethodEnd(CLASS_NAME, "getNextAppId()", appId);
        return appId;
    }

    public void getPortletEntityRegistry(RenderRequest request) {
        String METHOD_NAME = "getPortletEntityRegistry(request)";
        this.logMethodStart("getPortletEntityRegistry(request)");
        Collection alist = null;
        try {
            PortletEntityRegistryXao xao = new PortletEntityRegistryXao();
            PortletApplicationEntityListImpl registry = xao.load();
            alist = registry.getCastorApplications();
            this.logDebug("getPortletEntityRegistry(request)", "App list: " + alist);
        }
        catch (Exception e) {
            this.logError("getPortletEntityRegistry(request)", e);
            throw new PlutoAdminException(e);
        }
        ArrayList slist = new ArrayList(alist);
        Collections.sort(slist, new PortletApplicationEntityImplComparator());
        Iterator iter = slist.iterator();
        request.setAttribute("perlist", iter);
        this.logMethodEnd("getPortletEntityRegistry(request)", alist);
    }

    public void getPortletEntityRegistryApp(ActionRequest request) {
        PortletApplicationEntityImpl app;
        String METHOD_NAME = "getPortletEntityRegistryApp(request)";
        this.logMethodStart("getPortletEntityRegistryApp(request)");
        String appId = request.getParameter("appid");
        this.logDebug("getPortletEntityRegistryApp(request)", "AppId selected: " + appId);
        PortletSession session = request.getPortletSession();
        try {
            PortletEntityRegistryXao xao = new PortletEntityRegistryXao();
            app = xao.getApplication(appId);
        }
        catch (Exception e) {
            this.logError("getPortletEntityRegistryApp(request)", e);
            throw new PlutoAdminException(e);
        }
        session.setAttribute("app", (Object)app, 1);
        this.logMethodEnd("getPortletEntityRegistryApp(request)");
    }

    public void getPortletPreferences(ActionRequest request) {
        String METHOD_NAME = "getPortletPreferences(request)";
        this.logMethodStart(METHOD_NAME);
        String appId = request.getParameter("appId");
        this.logDebug(METHOD_NAME, "AppId selected: " + appId);
        String portletId = request.getParameter("portletId");
        this.logDebug(METHOD_NAME, "PortletId selected: " + portletId);
        ArrayList prefs = null;
        try {
            PortletEntityRegistryXao xao = new PortletEntityRegistryXao();
            Collection coll = xao.getPortletPreferences(appId, portletId);
            prefs = new ArrayList(coll);
        }
        catch (Exception e) {
            this.logError(METHOD_NAME, e);
            throw new PlutoAdminException(e);
        }
        PortletSession session = request.getPortletSession();
        HashMap map = (HashMap)session.getAttribute("preflist");
        if (map == null) {
            map = new HashMap();
        }
        map.put(portletId, prefs);
        session.setAttribute("preflist", map, 1);
        this.logMethodEnd(METHOD_NAME);
    }
}

