/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portlet.admin.services;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.pluto.portlet.admin.PlutoAdminException;
import org.apache.pluto.portlet.admin.PlutoAdminLogger;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PortletNameFinder {
    public static final String CLASS_NAME = "PortletNameFinder";

    PortletNameFinder() {
    }

    public static ArrayList getPortletNames(InputStream ios) throws Exception {
        String METHOD_NAME = "getPortletNames(InputStream)";
        ArrayList<String> nameList = new ArrayList<String>();
        boolean validation = false;
        boolean ignoreWhitespace = false;
        boolean ignoreComments = false;
        boolean putCDATAIntoText = false;
        boolean createEntityRefs = false;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(validation);
        dbf.setIgnoringComments(ignoreComments);
        dbf.setIgnoringElementContentWhitespace(ignoreWhitespace);
        dbf.setCoalescing(putCDATAIntoText);
        dbf.setExpandEntityReferences(!createEntityRefs);
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            PlutoAdminLogger.logError(CLASS_NAME, "getPortletNames(InputStream)", e);
            throw new PlutoAdminException(e);
        }
        OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, "UTF-8");
        db.setErrorHandler(new MyErrorHandler(new PrintWriter((Writer)errorWriter, true)));
        Document doc = null;
        try {
            doc = db.parse(ios);
        }
        catch (SAXException e) {
            PlutoAdminLogger.logError(CLASS_NAME, "getPortletNames(InputStream)", e);
            throw new PlutoAdminException(e);
        }
        catch (IOException e) {
            PlutoAdminLogger.logError(CLASS_NAME, "getPortletNames(InputStream)", e);
            throw new PlutoAdminException(e);
        }
        NodeList portletNames = doc.getElementsByTagName("portlet-name");
        if (null != portletNames) {
            for (int i = 0; i < portletNames.getLength(); ++i) {
                if (null == portletNames.item(i).getChildNodes().item(0)) continue;
                String portletName = portletNames.item(i).getChildNodes().item(0).getNodeValue();
                nameList.add(portletName);
            }
        }
        return nameList;
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private static final String INNER_CLASS_NAME = "MyErrorHandler";
        PrintWriter out = null;

        MyErrorHandler(PrintWriter p_out) {
            this.out = p_out;
        }

        private String getParseExceptionInfo(SAXParseException e) {
            String systemId = e.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + e.getLineNumber() + ": " + e.getMessage();
            return info;
        }

        public void warning(SAXParseException e) throws SAXException {
            String METHOD_NAME = "warning(e)";
            String msg = "Warning: " + this.getParseExceptionInfo(e);
            PlutoAdminLogger.logWarn(INNER_CLASS_NAME, METHOD_NAME, msg);
        }

        public void error(SAXParseException e) throws SAXException {
            String METHOD_NAME = "error(e)";
            String message = "Error: " + this.getParseExceptionInfo(e);
            PlutoAdminLogger.logError(INNER_CLASS_NAME, METHOD_NAME, message, e);
            throw new SAXException(message);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            String METHOD_NAME = "fatalError(e)";
            String message = "Fatal Error: " + this.getParseExceptionInfo(e);
            PlutoAdminLogger.logError(INNER_CLASS_NAME, METHOD_NAME, message, e);
            throw new SAXException(message);
        }
    }
}

