/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portlet.admin.services;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.pluto.descriptors.portlet.PortletDD;
import org.apache.pluto.portlet.admin.PlutoAdminException;
import org.apache.pluto.portlet.admin.PlutoAdminLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PortletConfigService {
    private Document _doc;
    private List portletDDList;
    public static final String CLASS_NAME = "PortletConfigService";

    private PortletConfigService() {
    }

    public PortletConfigService(InputStream ios) {
        this._doc = PortletConfigService.getDocument(ios);
        this.createPortletDDList();
    }

    private static Document getDocument(InputStream ios) {
        String METHOD_NAME = "getDocument(InputStream)";
        boolean validation = false;
        boolean ignoreWhitespace = false;
        boolean ignoreComments = false;
        boolean putCDATAIntoText = false;
        boolean createEntityRefs = false;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(validation);
        dbf.setIgnoringComments(ignoreComments);
        dbf.setIgnoringElementContentWhitespace(ignoreWhitespace);
        dbf.setCoalescing(putCDATAIntoText);
        dbf.setExpandEntityReferences(!createEntityRefs);
        DocumentBuilder db = null;
        Document doc = null;
        try {
            db = dbf.newDocumentBuilder();
            OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, "UTF-8");
            db.setErrorHandler(new MyErrorHandler(new PrintWriter((Writer)errorWriter, true)));
            doc = db.parse(ios);
        }
        catch (ParserConfigurationException e) {
            PlutoAdminLogger.logError(CLASS_NAME, "getDocument(InputStream)", e);
            throw new PlutoAdminException(e);
        }
        catch (SAXException e) {
            PlutoAdminLogger.logError(CLASS_NAME, "getDocument(InputStream)", e);
            throw new PlutoAdminException(e);
        }
        catch (IOException e) {
            PlutoAdminLogger.logError(CLASS_NAME, "getDocument(InputStream)", e);
            throw new PlutoAdminException(e);
        }
        return doc;
    }

    private void createPortletDDList() {
        String METHOD_NAME = "createPortletDDList";
        this.portletDDList = new ArrayList();
        NodeList portlets = this._doc.getElementsByTagName("portlet");
        Element portlet = null;
        PortletDD portletDD = null;
        NodeList roleRefs = null;
        ArrayList<RoleRef> refList = null;
        String name = null;
        String className = null;
        Element ref = null;
        String refName = null;
        String refLink = null;
        if (portlets != null) {
            for (int i = 0; i < portlets.getLength(); ++i) {
                portletDD = new PortletDD();
                portlet = (Element)portlets.item(i);
                name = portlet.getElementsByTagName("portlet-name").item(0).getChildNodes().item(0).getNodeValue();
                if (name == null) {
                    IllegalStateException e = new IllegalStateException("The portlet-name element is required in portlet.xml");
                    PlutoAdminLogger.logError(CLASS_NAME, "createPortletDDList", e);
                    throw e;
                }
                portletDD.setPortletName(name);
                className = portlet.getElementsByTagName("portlet-class").item(0).getChildNodes().item(0).getNodeValue();
                if (className == null) {
                    IllegalStateException e = new IllegalStateException("The portlet-class element is required in portlet.xml");
                    PlutoAdminLogger.logError(CLASS_NAME, "createPortletDDList", e);
                    throw e;
                }
                portletDD.setPortletClass(className);
                roleRefs = portlet.getElementsByTagName("security-role-ref");
                refList = new ArrayList<RoleRef>();
                if (roleRefs != null && roleRefs.getLength() != 0) {
                    for (int j = 0; j < roleRefs.getLength(); ++j) {
                        ref = (Element)roleRefs.item(j);
                        refName = ref.getElementsByTagName("role-name").item(0).getChildNodes().item(0).getNodeValue();
                        if (ref.getElementsByTagName("role-link").item(0) != null) {
                            refLink = ref.getElementsByTagName("role-link").item(0).getChildNodes().item(0).getNodeValue();
                        }
                        refList.add(new RoleRef(refName, refLink));
                    }
                }
                portletDD.setSecurityRoleRefs(refList);
                this.portletDDList.add(portletDD);
            }
        } else {
            IllegalStateException e = new IllegalStateException("The portlet.xml file does not contain portlet elements.");
            PlutoAdminLogger.logError(CLASS_NAME, "createPortletDDList", e);
            throw e;
        }
    }

    public List getPortletDDList() {
        return this.portletDDList;
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private static final String INNER_CLASS_NAME = "MyErrorHandler";
        PrintWriter out = null;

        MyErrorHandler(PrintWriter p_out) {
            this.out = p_out;
        }

        private String getParseExceptionInfo(SAXParseException e) {
            String systemId = e.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + e.getLineNumber() + ": " + e.getMessage();
            return info;
        }

        public void warning(SAXParseException e) throws SAXException {
            String METHOD_NAME = "warning(e)";
            String msg = "Warning: " + this.getParseExceptionInfo(e);
            PlutoAdminLogger.logWarn(INNER_CLASS_NAME, METHOD_NAME, msg);
        }

        public void error(SAXParseException e) throws SAXException {
            String METHOD_NAME = "error(e)";
            String message = "Error: " + this.getParseExceptionInfo(e);
            PlutoAdminLogger.logError(INNER_CLASS_NAME, METHOD_NAME, message, e);
            throw new SAXException(message);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            String METHOD_NAME = "fatalError(e)";
            String message = "Fatal Error: " + this.getParseExceptionInfo(e);
            PlutoAdminLogger.logError(INNER_CLASS_NAME, METHOD_NAME, message, e);
            throw new SAXException(message);
        }
    }

    public class RoleRef {
        public String roleName = null;
        public String roleLink = null;

        private RoleRef() {
        }

        public RoleRef(String p_roleName, String p_roleLink) {
            this.roleName = p_roleName;
            this.roleLink = p_roleLink;
        }
    }
}

