/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portlet.admin.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.RenderRequest;
import org.apache.pluto.portalImpl.om.page.impl.FragmentImpl;
import org.apache.pluto.portalImpl.om.page.impl.PortalImpl;
import org.apache.pluto.portlet.admin.BaseAdminObject;
import org.apache.pluto.portlet.admin.PlutoAdminException;
import org.apache.pluto.portlet.admin.bean.PageTO;
import org.apache.pluto.portlet.admin.bean.PortletTO;
import org.apache.pluto.portlet.admin.model.PageRegistryXao;

public class PageRegistryService
extends BaseAdminObject {
    private static final String CLASS_NAME = "PageRegistryService";

    public PageRegistryService() {
        super(CLASS_NAME);
    }

    public Iterator getPageRegistry() {
        PortalImpl portal;
        String METHOD_NAME = "getPageRegistry()";
        ArrayList<PageTO> pages = new ArrayList<PageTO>();
        try {
            PageRegistryXao xao = new PageRegistryXao();
            portal = xao.load();
        }
        catch (Exception e) {
            PlutoAdminException pae = new PlutoAdminException(e);
            this.logError(CLASS_NAME, "getPageRegistry()", e);
            throw pae;
        }
        Collection prpages = portal.getFragments();
        Iterator iter = prpages.iterator();
        while (iter.hasNext()) {
            FragmentImpl frag = (FragmentImpl)iter.next();
            if (frag.getName().equals("navigation")) continue;
            PageTO page = new PageTO();
            page.setName(frag.getName());
            Collection rfrags = frag.getFragments();
            page.setTitle(frag.getNavigation().getTitle());
            page.setDescription(frag.getNavigation().getDescription());
            int rows = rfrags.size();
            page.setRows(rows);
            if (rows > 0) {
                FragmentImpl row = (FragmentImpl)rfrags.iterator().next();
                Collection cfrags = row.getFragments();
                FragmentImpl col = (FragmentImpl)cfrags.iterator().next();
                int cols = col.getFragments().size();
                page.setCols(cols);
            }
            pages.add(page);
        }
        this.logDebug("getPageRegistry()", "Page count: " + pages.size());
        return pages.iterator();
    }

    public PageTO getPageVO(String name) {
        String METHOD_NAME = "getPageVO(name)";
        this.logMethodStart("getPageVO(name)");
        PageTO page = null;
        Iterator iter = this.getPageRegistry();
        while (iter.hasNext()) {
            PageTO element = (PageTO)iter.next();
            if (!element.getName().equals(name)) continue;
            page = element;
            break;
        }
        this.logMethodEnd("getPageVO(name)", page);
        return page;
    }

    public void getAllPages(RenderRequest req) {
        Iterator iter = this.getPageRegistry();
        req.setAttribute("pagelist", (Object)iter);
    }

    public void getPage(ActionRequest req) {
        String pageName = req.getParameter("pageName");
        PageTO page = this.getPageVO(pageName);
        req.getPortletSession().setAttribute("page", (Object)page);
    }

    public void modifyPageAttributes(ActionRequest req) {
        String METHOD_NAME = "modifyRowsAndCols(request)";
        this.logMethodStart("modifyRowsAndCols(request)");
        PageTO page = (PageTO)req.getPortletSession().getAttribute("page");
        this.logDebug("modifyRowsAndCols(request)", "Current page: " + page);
        String title = req.getParameter("title");
        page.setTitle(title);
        String description = req.getParameter("description");
        page.setDescription(description);
        String rows = req.getParameter("numrows");
        page.setRows(Integer.parseInt(rows));
        String cols = req.getParameter("numcols");
        page.setCols(Integer.parseInt(cols));
        this.logDebug("modifyRowsAndCols(request)", "Updated current page: " + page);
        req.getPortletSession().setAttribute("page", (Object)page);
        this.logMethodEnd("modifyRowsAndCols(request)");
    }

    public Map getPortletMapForSelect(String app) {
        HashMap<String, String> map = new HashMap<String, String>();
        List portlets = null;
        Iterator iter = this.getPageRegistry();
        while (iter.hasNext()) {
            PageTO page = (PageTO)iter.next();
            if (!page.getName().equalsIgnoreCase(app)) continue;
            portlets = page.getPortlets();
            break;
        }
        Iterator piter = portlets.iterator();
        while (piter.hasNext()) {
            PortletTO plet = (PortletTO)piter.next();
            map.put(plet.getName(), plet.getValue());
        }
        return map;
    }
}

