/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portlet.admin.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.PortletDiskFileUpload;
import org.apache.pluto.descriptors.portlet.PortletDD;
import org.apache.pluto.portalImpl.Deploy;
import org.apache.pluto.portalImpl.om.entity.impl.PortletApplicationEntityImpl;
import org.apache.pluto.portlet.admin.BaseAdminObject;
import org.apache.pluto.portlet.admin.PlutoAdminConstants;
import org.apache.pluto.portlet.admin.PlutoAdminException;
import org.apache.pluto.portlet.admin.bean.PageTO;
import org.apache.pluto.portlet.admin.bean.PortletMessage;
import org.apache.pluto.portlet.admin.bean.PortletMessageType;
import org.apache.pluto.portlet.admin.bean.PortletTO;
import org.apache.pluto.portlet.admin.model.PageRegistryXao;
import org.apache.pluto.portlet.admin.model.PortletEntityRegistryXao;
import org.apache.pluto.portlet.admin.services.PortletConfigService;
import org.apache.pluto.portlet.admin.services.PortletNameFinder;
import org.apache.pluto.portlet.admin.services.PortletRegistryService;
import org.apache.pluto.portlet.admin.util.PlutoAdminContext;

public class DeployWarService
extends BaseAdminObject {
    public static final String ERROR_NO_FILE = "ERROR_NO_FILE";
    public static final String CLASS_NAME = "DeployWarService";

    public DeployWarService() {
        super(CLASS_NAME);
    }

    public DeployWarService(String logId) {
        super(CLASS_NAME, logId);
    }

    public String processFileUpload(ActionRequest request, ActionResponse response) {
        String METHOD_NAME = "processFileUpload(request,response)";
        String fileName = null;
        String serverFileName = null;
        boolean modifyWebXml = true;
        request.getPortletSession().setAttribute("message", (Object)new PortletMessage("Deployment unsuccessful", PortletMessageType.ERROR));
        if (PortletDiskFileUpload.isMultipartContent(request)) {
            PortletDiskFileUpload dfu = new PortletDiskFileUpload();
            dfu.setSizeMax(10000000L);
            dfu.setSizeThreshold(100000);
            try {
                List fileItems = dfu.parseRequest(request);
                Iterator iter = fileItems.iterator();
                while (iter.hasNext()) {
                    FileItem item = (FileItem)iter.next();
                    if (item.isFormField()) {
                        String fieldName = item.getFieldName();
                        String value = item.getString();
                        response.setRenderParameter(fieldName, value);
                        if (!fieldName.equalsIgnoreCase("NoWebXmlModification")) continue;
                        String noWebXmlModification = item.getString();
                        this.logWarn("processFileUpload(request,response)", "Don't modify web.xml? " + noWebXmlModification);
                        if (noWebXmlModification == null) continue;
                        modifyWebXml = false;
                        continue;
                    }
                    fileName = item.getName();
                    String contentType = item.getContentType();
                    long size = item.getSize();
                    response.setRenderParameter("size", Long.toString(size));
                    response.setRenderParameter("contentType", contentType);
                    String tempDir = System.getProperty("java.io.tmpdir");
                    serverFileName = this.getRootFilename(File.separatorChar, fileName);
                    File serverFile = new File(tempDir, serverFileName);
                    item.write(serverFile);
                    response.setRenderParameter("serverFileName", serverFileName);
                    int index = serverFileName.indexOf(".war");
                    String context = "";
                    context = index != -1 ? serverFileName.substring(0, index) : serverFileName;
                    PortletEntityRegistryXao xao = new PortletEntityRegistryXao();
                    boolean appExists = xao.applicationExists(context);
                    ArrayList argList = this.createDeploymentArgs(serverFileName, tempDir, request, appExists, context);
                    HashMap pmap = (HashMap)request.getPortletSession().getAttribute("portlet-map");
                    this.logDebug("processFileUpload(request,response)", "Arguments for Deploy.main():");
                    String[] args = DeployWarService.arrayListToStringArray(argList);
                    for (int i = 0; i < args.length; ++i) {
                        this.logDebug("processFileUpload(request,response)", "args[" + i + "]=" + args[i]);
                    }
                    Deploy.main(args);
                    if (modifyWebXml) {
                        this.updateWebXml(context);
                    }
                    if (appExists) {
                        request.getPortletSession().setAttribute("message", (Object)new PortletMessage("Deployment of the new portlet app has been successful, but the portlet app record '" + context + "' already exists in portletentityregistry.xml. " + "This may have occurred if the portlet was previously partially deployed. If that is the case, continue with this screen and the next to register the portlet in pageregistry.xml. " + "If you are deploying a previously deployed portlet app, click on the 'Deploy War home' link below and then the 'Hot deploy . . .' link on the resulting page to see your redeployed portlet. " + "However, caching of the old app may require that you restart Pluto to see the new changes.", PortletMessageType.INFO));
                        continue;
                    }
                    request.getPortletSession().setAttribute("message", (Object)new PortletMessage("Deployment and addition to portletentityregistry.xml successful.", PortletMessageType.SUCCESS));
                }
            }
            catch (FileUploadException e) {
                String msg = "File Upload Exception: " + e.getMessage();
                this.logError("processFileUpload(request,response)", msg, e);
                throw new PlutoAdminException(e);
            }
            catch (Exception e) {
                String msg = "Exception: " + e.getMessage();
                this.logError("processFileUpload(request,response)", msg, e);
                throw new PlutoAdminException(e);
            }
        } else {
            request.getPortletSession().setAttribute("message", (Object)new PortletMessage("No file appears to have been selected.", PortletMessageType.ERROR));
        }
        this.logMethodEnd("processFileUpload(request,response)", serverFileName);
        return serverFileName;
    }

    private String getRootFilename(char delimiter, String pathName) {
        int startFilenameIndex = pathName.lastIndexOf(delimiter) + 1;
        String filename = pathName.substring(startFilenameIndex);
        return filename;
    }

    private static String[] arrayListToStringArray(ArrayList argStringArrayList) {
        return argStringArrayList.toArray(new String[argStringArrayList.size()]);
    }

    private InputStream extractFile(String zipfilename, String filename) {
        String METHOD_NAME = "extractFile(zipfilename,filename)";
        InputStream ins = null;
        try {
            ZipEntry ze;
            ZipFile zf = new ZipFile(zipfilename);
            if (null != zf && null != (ze = zf.getEntry(filename))) {
                ins = zf.getInputStream(ze);
            }
        }
        catch (Exception e) {
            this.logError(CLASS_NAME, "extractFile(zipfilename,filename)", e);
            throw new PlutoAdminException(e);
        }
        return ins;
    }

    private ArrayList createDeploymentArgs(String serverFileName, String tempDir, ActionRequest request, boolean appExists, String context) throws Exception {
        String METHOD_NAME = "createDeploymentArgs(serverFileName,tempDir,request)";
        Properties props = PlutoAdminContext.getProperties();
        String CONTAINER_HOME = PlutoAdminContext.getContainerHome();
        String PORTLET_DEPLOY_DIR = props.getProperty("portlet-deploy-dir");
        ArrayList<String> args = new ArrayList<String>();
        args.add(PlutoAdminContext.getDeploymentPath());
        args.add(PlutoAdminContext.getPlutoWebContext());
        args.add(tempDir + PlutoAdminConstants.FS + serverFileName);
        args.add(CONTAINER_HOME + PlutoAdminConstants.FS + PORTLET_DEPLOY_DIR);
        String appId = PortletRegistryService.getNextAppId();
        if (!appExists) {
            args.add("-addToEntityReg");
            args.add(appId);
        } else {
            PortletEntityRegistryXao xao = new PortletEntityRegistryXao();
            PortletApplicationEntityImpl app = xao.getApplication(context);
            appId = app.getCastorId();
        }
        HashMap pmap = new HashMap();
        InputStream ins = this.extractFile(tempDir + PlutoAdminConstants.FS + serverFileName, "WEB-INF/portlet.xml");
        if (null != ins) {
            ArrayList names = PortletNameFinder.getPortletNames(ins);
            for (int i = 0; i < names.size(); ++i) {
                if (!appExists) {
                    args.add(i + ":" + names.get(i));
                }
                pmap.put(names.get(i), appId + "." + i);
            }
        } else {
            String msg = "Input stream is null";
            PlutoAdminException e = new PlutoAdminException(msg);
            this.logError("createDeploymentArgs(serverFileName,tempDir,request)", e);
            throw e;
        }
        ins.close();
        request.getPortletSession().setAttribute("portlet-map", pmap);
        return args;
    }

    public static String mapToEntrySetString(Map inputMap) {
        StringBuffer sb = new StringBuffer();
        Set es = inputMap.entrySet();
        Iterator it = es.iterator();
        sb.append("Number of entries: " + es.size());
        for (int i = 0; i < es.size(); ++i) {
            Map.Entry entry = it.next();
            sb.append(entry.getKey().toString());
            sb.append(entry.getValue().toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public void setPage(ActionRequest req) {
        String METHOD_NAME = "setPage(request)";
        this.logMethodStart("setPage(request)");
        PageTO page = (PageTO)req.getPortletSession().getAttribute("page");
        if (page == null) {
            page = new PageTO();
        }
        String title = req.getParameter("title");
        page.setTitle(title);
        String desc = req.getParameter("description");
        page.setDescription(desc);
        String rows = req.getParameter("numrows");
        page.setRows(Integer.parseInt(rows));
        String cols = req.getParameter("numcols");
        page.setCols(Integer.parseInt(cols));
        req.getPortletSession().setAttribute("page", (Object)page);
        this.logMethodEnd("setPage(request)");
    }

    public void savePageLayout(ActionRequest req) {
        String METHOD_NAME = "savePageLayout(request)";
        this.logMethodStart("savePageLayout(request)");
        PageTO page = (PageTO)req.getPortletSession().getAttribute("page");
        ArrayList<PortletTO> list = new ArrayList<PortletTO>();
        int rows = page.getRows();
        int cols = page.getCols();
        for (int i = 1; i <= rows; ++i) {
            for (int j = 1; j <= cols; ++j) {
                String portletParam = "portlet" + i + "." + j;
                String name_val = req.getParameter(portletParam);
                int underscore = name_val.lastIndexOf("_");
                String name = name_val.substring(0, underscore);
                String val = name_val.substring(underscore + 1);
                PortletTO nPortlet = new PortletTO();
                nPortlet.setName(name);
                nPortlet.setValue(val);
                nPortlet.setRow(i);
                nPortlet.setCol(j);
                list.add(nPortlet);
            }
        }
        page.setPortlets(list);
        this.addToPageReg(page);
        this.logMethodEnd("savePageLayout(request)");
    }

    public void addToPageReg(PageTO page) {
        String METHOD_NAME = "addToPageReg(PageTO)";
        this.logMethodStart("addToPageReg(PageTO)");
        RandomAccessFile ras = null;
        int cols = page.getCols();
        String name = page.getName();
        try {
            String pageregpath = PlutoAdminContext.getInstance().getPageRegistryPath();
            File file = new File(pageregpath);
            ras = new RandomAccessFile(file, "rw");
            long length = ras.length();
            byte[] contentByte = new byte[(int)length];
            ras.read(contentByte);
            String contentString = new String(contentByte);
            String prev = "fragment name=\"" + name;
            if (contentString.lastIndexOf(prev) != -1) {
                String errMsg = "Portlet '" + name + "' already exists in pageregistry.xml";
                PlutoAdminException e = new PlutoAdminException(errMsg);
                this.logError("addToPageReg(PageTO)", errMsg, e);
                throw e;
            }
            long pos = contentString.lastIndexOf("</portal>");
            ras.seek(pos);
            ras.writeBytes("    <fragment name=\"" + name + "\" type=\"page\" >" + PlutoAdminConstants.LS);
            ras.writeBytes("        <navigation>" + PlutoAdminConstants.LS);
            ras.writeBytes("\t        <title>" + page.getTitle());
            ras.writeBytes("</title>" + PlutoAdminConstants.LS);
            ras.writeBytes("\t        <description>" + page.getDescription());
            ras.writeBytes("</description>" + PlutoAdminConstants.LS);
            ras.writeBytes("        </navigation>" + PlutoAdminConstants.LS);
            List portlets = page.getPortlets();
            Collections.sort(portlets);
            Iterator iter = portlets.iterator();
            int count = 0;
            int currRow = 0;
            int lastRow = 0;
            int currCol = 0;
            while (iter.hasNext()) {
                ++count;
                PortletTO portlet = (PortletTO)iter.next();
                this.logDebug("addToPageReg(PageTO)", "Portlet: " + portlet);
                currRow = portlet.getRow();
                currCol = portlet.getCol();
                if (currRow != lastRow) {
                    ras.writeBytes("          <fragment name=\"row" + currRow + "\" type=\"row\">" + PlutoAdminConstants.LS);
                    ras.writeBytes("             <fragment name=\"col" + count + "\" type=\"column\">" + PlutoAdminConstants.LS);
                }
                ras.writeBytes("                  <fragment name=\"p" + count + "\" type=\"portlet\">" + PlutoAdminConstants.LS);
                ras.writeBytes("                    <property name=\"portlet\" value=\"" + portlet.getValue() + "\"/>" + PlutoAdminConstants.LS);
                ras.writeBytes("                  </fragment><!-- end of portlet frag -->" + PlutoAdminConstants.LS);
                if (cols == currCol) {
                    ras.writeBytes("             </fragment><!-- end of col frag -->" + PlutoAdminConstants.LS);
                    ras.writeBytes("         </fragment><!-- end of row frag -->" + PlutoAdminConstants.LS);
                }
                lastRow = currRow;
            }
            ras.writeBytes("    </fragment><!-- end of 'page' frag -->" + PlutoAdminConstants.LS);
            ras.writeBytes(PlutoAdminConstants.LS);
            ras.writeBytes(PlutoAdminConstants.LS);
            ras.writeBytes("</portal>" + PlutoAdminConstants.LS);
        }
        catch (IOException e) {
            this.logError("addToPageReg(PageTO)", e);
            throw new PlutoAdminException(e);
        }
        finally {
            if (ras != null) {
                try {
                    ras.close();
                }
                catch (IOException e) {
                    this.logError("addToPageReg(PageTO)", e);
                }
            }
        }
        this.logMethodEnd("addToPageReg(PageTO)");
    }

    public boolean addToPortletContexts(String context) {
        String METHOD_NAME = "addToPortletContexts(context)";
        this.logMethodStart("addToPortletContexts(context)");
        this.logParam("addToPortletContexts(context)", "context", context);
        String path = PlutoAdminContext.getInstance().getPortletContextsPath();
        this.logDebug("addToPortletContexts(context)", "portletcontexts.txt path: " + path);
        File file = new File(path);
        boolean found = false;
        if (file.exists()) {
            String fileContents = this.readFileToString(file);
            this.logDebug("addToPortletContexts(context)", "portletcontexts.txt contents: " + fileContents);
            int ind = fileContents.indexOf(context);
            boolean bl = found = ind != -1;
            if (found && !fileContents.substring(ind - 1, ind).equals("/")) {
                found = false;
            }
            if (found) {
                int len = context.length();
                String contextInFile = fileContents.substring(ind);
                int indLS = contextInFile.indexOf(PlutoAdminConstants.LS);
                long fileLen = file.length();
                if (indLS != len && (long)(ind + len) != fileLen) {
                    found = false;
                }
            }
            if (!found) {
                this.logDebug("addToPortletContexts(context)", "Writing new context: " + context);
                StringBuffer buf = new StringBuffer(fileContents);
                buf.append(PlutoAdminConstants.LS);
                buf.append("/");
                buf.append(context);
                this.writeStringToFile(file, buf.toString());
            }
        } else {
            this.logWarn("addToPortletContexts(context)", "File portletcontexts.txt cannot be found! You must be using Release Candidate 1.");
        }
        this.logMethodEnd("addToPortletContexts(context)", Boolean.toString(found));
        return found;
    }

    public boolean pageExists(String pageName) {
        String METHOD_NAME = "pageExists(pageName)";
        boolean exists = true;
        try {
            PageRegistryXao xao = new PageRegistryXao();
            exists = xao.pageExists(pageName);
        }
        catch (Exception e) {
            this.logError("pageExists(pageName)", e);
            throw new PlutoAdminException(e);
        }
        return exists;
    }

    public String readFileToString(File file) {
        String METHOD_NAME = "readFileToString(path)";
        String contents = null;
        FileInputStream fis = null;
        try {
            int c;
            fis = new FileInputStream(file);
            StringBuffer sb = new StringBuffer();
            while ((c = fis.read()) != -1) {
                char b = (char)c;
                sb.append(b);
            }
            contents = sb.toString().trim();
        }
        catch (FileNotFoundException e) {
            this.logError("readFileToString(path)", e);
            throw new PlutoAdminException(e);
        }
        catch (IOException e) {
            this.logError("readFileToString(path)", e);
            throw new PlutoAdminException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    this.logError("readFileToString(path)", e);
                    throw new PlutoAdminException(e);
                }
            }
        }
        return contents;
    }

    public void writeStringToFile(File file, String contents) {
        String METHOD_NAME = "addFileToStringToFile(contents)";
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            byte[] bytes = contents.getBytes();
            fos.write(bytes);
        }
        catch (FileNotFoundException e) {
            this.logError("addFileToStringToFile(contents)", e);
            throw new PlutoAdminException(e);
        }
        catch (IOException e) {
            this.logError("addFileToStringToFile(contents)", e);
            throw new PlutoAdminException(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    this.logError("addFileToStringToFile(contents)", e);
                    throw new PlutoAdminException(e);
                }
            }
        }
    }

    void updateWebXml(String context) {
        String newWebXml;
        String METHOD_NAME = "updateWebXml(context)";
        String[] PRIOR_ELEMENTS_SERVLET = new String[]{"servlet", "listener", "filter-mapping", "filter", "context-param", "distributable", "description", "display-name", "icon", "web-app"};
        String[] PRIOR_ELEMENTS_SERVLET_MAPPING = new String[]{"servlet-mapping", "servlet"};
        String webapps = PlutoAdminContext.getDeploymentPath();
        File webXml = new File(webapps + PlutoAdminConstants.FS + context + PlutoAdminConstants.FS + "WEB-INF" + PlutoAdminConstants.FS + "web.xml");
        DeployWarService svc = new DeployWarService();
        String contents = svc.readFileToString(webXml);
        File portletXml = new File(webapps + PlutoAdminConstants.FS + context + PlutoAdminConstants.FS + "WEB-INF" + PlutoAdminConstants.FS + "portlet.xml");
        List plist = null;
        try {
            FileInputStream ins = new FileInputStream(portletXml);
            PortletConfigService pcsvc = new PortletConfigService(ins);
            plist = pcsvc.getPortletDDList();
        }
        catch (FileNotFoundException e) {
            this.logError(METHOD_NAME, e);
            throw new PlutoAdminException(e);
        }
        contents = newWebXml = svc.addRecordsToWebXml(context, contents, PRIOR_ELEMENTS_SERVLET, plist);
        newWebXml = svc.addRecordsToWebXml(context, contents, PRIOR_ELEMENTS_SERVLET_MAPPING, plist);
        this.writeStringToFile(webXml, newWebXml);
    }

    String addRecordsToWebXml(String context, String contents, String[] elements, List portletData) {
        String METHOD_NAME = "addRecordsToWebXml(context.contents,elements,portletData)";
        StringBuffer results = new StringBuffer(contents);
        int index = -1;
        int len = portletData.size();
        int lenElements = elements.length;
        String before = null;
        String newRecord = null;
        String remainder = null;
        String rest = null;
        block0: for (int i = 0; i < len; ++i) {
            for (int j = 0; j < lenElements; ++j) {
                index = results.lastIndexOf("</" + elements[j] + ">");
                if (index == -1) continue;
                rest = results.substring(index);
                int elementLen = rest.indexOf(62) + 1;
                if (i == 0 & elements[j].equals("web-app")) {
                    index = results.indexOf("<web-app");
                    rest = results.substring(index);
                    elementLen = rest.indexOf(62) + 1;
                }
                this.logDebug(METHOD_NAME, "Length of '" + elements[j] + "' tag = " + elementLen);
                before = results.substring(0, index + elementLen);
                remainder = results.substring(index + elementLen);
                if (elements[0].equals("servlet")) {
                    newRecord = this.getServletRecord(context, (PortletDD)portletData.get(i));
                } else if (elements[0].equals("servlet-mapping")) {
                    newRecord = this.getServletMappingRecord((PortletDD)portletData.get(i));
                }
                results = new StringBuffer();
                results.append(before);
                results.append(PlutoAdminConstants.LS);
                results.append(newRecord);
                results.append(remainder);
                continue block0;
            }
        }
        return results.toString();
    }

    private String getServletRecord(String context, PortletDD portletData) {
        StringBuffer record = new StringBuffer();
        record.append("    <servlet>" + PlutoAdminConstants.LS);
        record.append("      <servlet-name>" + portletData.getPortletName() + "</servlet-name>" + PlutoAdminConstants.LS);
        record.append("      <display-name>" + portletData.getPortletName() + " Wrapper</display-name>" + PlutoAdminConstants.LS);
        record.append("      <description>Automated generated Portlet Wrapper</description>" + PlutoAdminConstants.LS);
        record.append("      <servlet-class>org.apache.pluto.core.PortletServlet</servlet-class>" + PlutoAdminConstants.LS);
        record.append("      <init-param>" + PlutoAdminConstants.LS);
        record.append("        <param-name>portlet-guid</param-name>" + PlutoAdminConstants.LS);
        record.append("        <param-value>" + context + "." + portletData.getPortletName() + "</param-value>" + PlutoAdminConstants.LS);
        record.append("      </init-param>" + PlutoAdminConstants.LS);
        record.append("      <init-param>" + PlutoAdminConstants.LS);
        record.append("        <param-name>portlet-class</param-name>" + PlutoAdminConstants.LS);
        record.append("        <param-value>" + portletData.getPortletClass() + "</param-value>" + PlutoAdminConstants.LS);
        record.append("      </init-param>" + PlutoAdminConstants.LS);
        String securityRef = this.getSecurityRoleRefRecord(context, portletData);
        if (securityRef != null && !securityRef.equals("")) {
            record.append(securityRef);
        }
        record.append("    </servlet>" + PlutoAdminConstants.LS);
        return record.toString();
    }

    private String getSecurityRoleRefRecord(String context, PortletDD portletData) {
        StringBuffer record = new StringBuffer("");
        List refs = portletData.getSecurityRoleRefs();
        String link = null;
        Iterator iter = refs.iterator();
        while (iter.hasNext()) {
            PortletConfigService.RoleRef ref = (PortletConfigService.RoleRef)iter.next();
            record.append("      <security-role-ref>" + PlutoAdminConstants.LS);
            record.append("        <role-name>" + ref.roleName + "</role-name>" + PlutoAdminConstants.LS);
            link = ref.roleLink;
            if (link != null && !link.equals("")) {
                record.append("        <role-link>" + link + "</role-link>" + PlutoAdminConstants.LS);
            }
            record.append("      </security-role-ref>" + PlutoAdminConstants.LS);
        }
        return record.toString();
    }

    private String getServletMappingRecord(PortletDD portletData) {
        StringBuffer record = new StringBuffer();
        record.append("    <servlet-mapping>" + PlutoAdminConstants.LS);
        record.append("      <servlet-name>" + portletData.getPortletName() + "</servlet-name>" + PlutoAdminConstants.LS);
        record.append("      <url-pattern>/" + portletData.getPortletName() + "/*</url-pattern>" + PlutoAdminConstants.LS);
        record.append("    </servlet-mapping>" + PlutoAdminConstants.LS);
        return record.toString();
    }
}

