/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portlet.admin.model;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.pluto.portalImpl.om.entity.impl.PortletApplicationEntityImpl;
import org.apache.pluto.portalImpl.om.entity.impl.PortletApplicationEntityListImpl;
import org.apache.pluto.portalImpl.om.entity.impl.PortletEntityImpl;
import org.apache.pluto.portlet.admin.BaseAdminObject;
import org.apache.pluto.portlet.admin.PlutoAdminException;
import org.apache.pluto.portlet.admin.util.PlutoAdminContext;
import org.apache.pluto.util.StringUtils;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;

public class PortletEntityRegistryXao
extends BaseAdminObject {
    public static final String CONFIG_FILE = "WEB-INF/data/portletentityregistry.xml";
    public static final String DEFAULT_MAPPING = "WEB-INF/data/xml/portletentitymapping.xml";
    private static final String CLASS_NAME = "PortletEntityRegistryXao";
    private Collection castorApplications = new ArrayList();
    private Mapping mapping;

    public PortletEntityRegistryXao() throws Exception {
        super(CLASS_NAME);
        this.init();
    }

    public void init() throws Exception {
        String METHOD_NAME = "init()";
        String _mapping = PlutoAdminContext.getInstance().getPlutoHome() + "/" + DEFAULT_MAPPING;
        this.mapping = new Mapping();
        try {
            this.mapping.loadMapping(_mapping);
        }
        catch (Exception e) {
            this.logError("init()", "Failed to load mapping file " + _mapping, e);
            throw e;
        }
    }

    public void save(PortletApplicationEntityListImpl apps) throws Exception {
        String METHOD_NAME = "save(AdminPortalImpl)";
        String filename = PlutoAdminContext.getInstance().getPlutoHome() + "/" + CONFIG_FILE;
        this.logDebug("save(AdminPortalImpl)", "Registry file to save: " + filename);
        FileWriter writer = new FileWriter(filename);
        Marshaller marshaller = new Marshaller((Writer)writer);
        marshaller.setMapping(this.mapping);
        marshaller.marshal((Object)apps);
    }

    public PortletApplicationEntityListImpl load() throws Exception {
        String METHOD_NAME = "load()";
        String filename = PlutoAdminContext.getInstance().getPlutoHome() + "/" + CONFIG_FILE;
        this.logDebug("load()", "Registry file to load: " + filename);
        Unmarshaller unmarshaller = new Unmarshaller(this.mapping);
        unmarshaller.setMapping(this.mapping);
        PortletApplicationEntityListImpl apps = (PortletApplicationEntityListImpl)unmarshaller.unmarshal((Reader)new FileReader(filename));
        this.castorApplications = apps.getCastorApplications();
        return apps;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuffer buffer = new StringBuffer(1000);
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append(this.getClass().toString());
        buffer.append(":");
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append("{");
        Iterator iterator = this.castorApplications.iterator();
        if (iterator.hasNext()) {
            StringUtils.newLine((StringBuffer)buffer, (int)indent);
            buffer.append("Portlet Application Entities");
            int count = this.castorApplications.size();
            buffer.append("(");
            buffer.append(count);
            buffer.append("):");
        }
        while (iterator.hasNext()) {
            buffer.append(((PortletApplicationEntityImpl)iterator.next()).toString(indent + 2));
        }
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append("}");
        return buffer.toString();
    }

    public Collection getApplications() throws Exception {
        String METHOD_NAME = "getApplications()";
        this.logMethodStart(METHOD_NAME);
        Collection elist = null;
        PortletApplicationEntityListImpl per = this.load();
        this.logDebug(METHOD_NAME, "PER: " + per);
        if (per != null) {
            elist = per.getCastorApplications();
        }
        this.logMethodEnd(METHOD_NAME, elist);
        return elist;
    }

    public PortletApplicationEntityImpl getApplication(String appContext) throws Exception {
        PortletApplicationEntityImpl app = null;
        Collection apps = this.getApplications();
        Iterator iter = apps.iterator();
        while (iter.hasNext() && !(app = (PortletApplicationEntityImpl)iter.next()).getDefinitionId().equalsIgnoreCase(appContext)) {
        }
        return app;
    }

    public Collection getPortletPreferences(String appId, String portletId) throws Exception {
        Collection list = null;
        PortletApplicationEntityImpl app = this.getApplication(appId);
        Collection plets = app.getCastorPortlets();
        Iterator iter = plets.iterator();
        while (iter.hasNext()) {
            PortletEntityImpl plet = (PortletEntityImpl)iter.next();
            if (!plet.getCastorId().equalsIgnoreCase(portletId)) continue;
            list = plet.getCastorPreferences();
            break;
        }
        return list;
    }

    public boolean applicationExists(String appContext) {
        String METHOD_NAME = "applicationExists(appContext)";
        boolean exists = false;
        Collection apps = null;
        try {
            apps = this.getApplications();
        }
        catch (Exception e) {
            this.logError("applicationExists(appContext)", e);
            throw new PlutoAdminException(e);
        }
        Iterator iter = apps.iterator();
        while (iter.hasNext()) {
            PortletApplicationEntityImpl app = (PortletApplicationEntityImpl)iter.next();
            if (!app.getDefinitionId().equalsIgnoreCase(appContext)) continue;
            exists = true;
            break;
        }
        return exists;
    }
}

