/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portlet.admin.model;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import org.apache.pluto.portalImpl.om.page.impl.FragmentImpl;
import org.apache.pluto.portalImpl.om.page.impl.PortalImpl;
import org.apache.pluto.portlet.admin.BaseAdminObject;
import org.apache.pluto.portlet.admin.PlutoAdminException;
import org.apache.pluto.portlet.admin.util.PlutoAdminContext;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;

public class PageRegistryXao
extends BaseAdminObject {
    public static final String CONFIG_FILE = "WEB-INF/data/pageregistry.xml";
    public static final String DEFAULT_MAPPING = "WEB-INF/data/xml/pageregistrymapping.xml";
    private static final String CLASS_NAME = "PageRegistryXao";
    private Mapping mapping;

    public PageRegistryXao() throws Exception {
        super(CLASS_NAME);
        this.init();
    }

    public void init() throws Exception {
        String METHOD_NAME = "init()";
        String _mapping = PlutoAdminContext.getInstance().getPlutoHome() + "/" + DEFAULT_MAPPING;
        this.mapping = new Mapping();
        try {
            this.mapping.loadMapping(_mapping);
        }
        catch (Exception e) {
            this.logError("init()", "Failed to load mapping file " + _mapping, e);
            throw e;
        }
    }

    public void save(PortalImpl page) throws Exception {
        String METHOD_NAME = "save(PortalImpl)";
        String filename = PlutoAdminContext.getInstance().getPlutoHome() + "/" + CONFIG_FILE;
        this.logDebug("save(PortalImpl)", "Registry file to save: " + filename);
        FileWriter writer = new FileWriter(filename);
        Marshaller marshaller = new Marshaller((Writer)writer);
        marshaller.setMapping(this.mapping);
        marshaller.marshal((Object)page);
    }

    public PortalImpl load() throws Exception {
        String METHOD_NAME = "load()";
        String filename = PlutoAdminContext.getInstance().getPlutoHome() + "/" + CONFIG_FILE;
        this.logDebug("load()", "File to load: " + filename);
        Unmarshaller unmarshaller = new Unmarshaller(this.mapping);
        unmarshaller.setMapping(this.mapping);
        PortalImpl pages = (PortalImpl)unmarshaller.unmarshal((Reader)new FileReader(filename));
        return pages;
    }

    public boolean pageExists(String page) {
        String METHOD_NAME = "pageExists(page)";
        boolean exists = false;
        Collection frags = null;
        try {
            PortalImpl portal = this.load();
            frags = portal.getFragments();
        }
        catch (Exception e) {
            this.logError("pageExists(page)", e);
            throw new PlutoAdminException(e);
        }
        Iterator iter = frags.iterator();
        while (iter.hasNext()) {
            FragmentImpl frag = (FragmentImpl)iter.next();
            String type = null;
            String name = null;
            if (frag != null) {
                type = frag.getType();
                name = frag.getName();
            }
            if (type == null || !type.equalsIgnoreCase("page") || name == null || !name.equalsIgnoreCase(page)) continue;
            exists = true;
            break;
        }
        return exists;
    }
}

