/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portlet.admin.controller;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.pluto.portlet.admin.bean.PageTO;
import org.apache.pluto.portlet.admin.bean.PortletMessage;
import org.apache.pluto.portlet.admin.bean.PortletMessageType;
import org.apache.pluto.portlet.admin.controller.ControllerPortlet;
import org.apache.pluto.portlet.admin.services.DeployWarService;

public class DeployWarPortlet
extends ControllerPortlet {
    private DeployWarService service;

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        super.doEdit(request, response);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        super.doView(request, response);
    }

    public void init() throws PortletException {
        super.init();
        this.service = new DeployWarService();
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        super.doHelp(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        try {
            String action = request.getParameter("action");
            this.log("Action param == " + action);
            if (action == null) {
                String fileName = this.service.processFileUpload(request, response);
                int index = fileName.indexOf(".war");
                String name = null;
                name = index != -1 ? fileName.substring(0, index) : fileName;
                this.service.addToPortletContexts(name);
                PageTO oPage = new PageTO();
                oPage.setName(name);
                request.getPortletSession().setAttribute("page", (Object)oPage);
                this._incView = "/portlets/admin/PageRegistryAdd.jsp";
                response.setPortletMode(PortletMode.VIEW);
            } else if (action.equals("showhome")) {
                this._incView = "/portlets/admin/DeployWarView.jsp";
                response.setPortletMode(PortletMode.VIEW);
            } else if (action.equals("showpagelayout")) {
                PortletSession session = request.getPortletSession();
                PageTO page = (PageTO)session.getAttribute("page");
                String name = "";
                if (page != null) {
                    name = page.getName();
                }
                if (page != null && !this.service.pageExists(name)) {
                    this.service.setPage(request);
                    this._incView = "/portlets/admin/PageRegistryAdd2.jsp";
                } else {
                    session.setAttribute("message", (Object)new PortletMessage("Page '" + name + "' already exists in pageregistry.xml", PortletMessageType.INFO));
                    this._incView = "/portlets/admin/DeployWarView.jsp";
                }
                response.setPortletMode(PortletMode.VIEW);
            } else if (action.equals("savepagelayout")) {
                this.service.savePageLayout(request);
                request.getPortletSession().setAttribute("message", (Object)new PortletMessage("Deployment successful. Please restart the Pluto portal or click the hot deploy link below.", PortletMessageType.SUCCESS));
                this._incView = "/portlets/admin/DeployWarView.jsp";
                response.setPortletMode(PortletMode.VIEW);
            }
        }
        catch (Throwable e) {
            this.log("Error! ", e);
            request.getPortletSession().setAttribute("message", (Object)new PortletMessage("A problem has occurred: " + e.getMessage() + ". Please check the log file for details.", PortletMessageType.ERROR));
        }
    }
}

