/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portlet.admin.controller;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.pluto.portlet.admin.PlutoAdminConstants;
import org.apache.pluto.portlet.admin.util.PlutoAdminContext;

public class ControllerPortlet
extends GenericPortlet {
    protected String _incView = "/view.jsp";
    protected String _incEdit = "/edit.jsp";
    protected String _incHelp = "/help.jsp";
    protected Properties _properties;
    protected PortletContext _ctx;

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        PortletRequestDispatcher rd = this._ctx.getRequestDispatcher(this._incEdit);
        rd.include(request, response);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        PortletRequestDispatcher rd = this._ctx.getRequestDispatcher(this._incView);
        rd.include(request, response);
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        PortletRequestDispatcher rd = this._ctx.getRequestDispatcher(this._incHelp);
        rd.include(request, response);
    }

    public void init() throws PortletException {
        super.init();
        try {
            this._ctx = this.getPortletContext();
            PortletConfig config = this.getPortletConfig();
            String tmp = config.getInitParameter("view_include");
            if (tmp != null) {
                this._incView = tmp;
            }
            this.log("View include: " + this._incView);
            tmp = config.getInitParameter("edit_include");
            if (tmp != null) {
                this._incEdit = tmp;
            }
            this.log("Edit include: " + this._incEdit);
            tmp = config.getInitParameter("help_include");
            if (tmp != null) {
                this._incHelp = tmp;
            }
            this.log("Help include: " + this._incHelp);
            this._properties = PlutoAdminContext.getProperties();
            String plutoPath = this._ctx.getRealPath("");
            PlutoAdminContext.parseDeploymentPaths(plutoPath);
        }
        catch (Throwable e) {
            this.log("Error thrown in ControllerPortlet.init()", e);
        }
    }

    protected void log(String msg) {
        this._ctx.log(msg);
    }

    protected void log(String msg, Throwable e) {
        this._ctx.log(msg, e);
    }

    protected String getPageRegistryFileName() {
        String fileName = this._properties.getProperty("pageregistry-file");
        return fileName;
    }

    protected String getPageRegistryFilePath() {
        return this.getDataDirPath() + PlutoAdminConstants.FS + this.getPageRegistryFileName();
    }

    protected String getPortletRegistryFileName() {
        String fileName = this._properties.getProperty("portletregistry-file");
        return fileName;
    }

    protected String getPortletRegistryFilePath() {
        return this.getDataDirPath() + PlutoAdminConstants.FS + this.getPortletRegistryFileName();
    }

    protected String getDataDirPath() {
        String path = null;
        String plutoHome = PlutoAdminContext.getInstance().getPlutoHome();
        String dataDirRelPath = this._properties.getProperty("data-dir-relative-path");
        path = plutoHome + PlutoAdminConstants.FS + dataDirRelPath;
        return path;
    }

    protected void printParams(PortletRequest request) {
        this.log("Parameter names/values");
        Enumeration penum = request.getParameterNames();
        while (penum.hasMoreElements()) {
            String pname = (String)penum.nextElement();
            String[] pvals = request.getParameterValues(pname);
            for (int i = 0; i < pvals.length; ++i) {
                String val = pvals[i];
                this.log("Parameter: " + pname + "==" + val);
            }
        }
    }
}

