/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portalImpl.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.pluto.portalImpl.xml.Constants;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlParser {
    public static Document parsePortletXml(InputStream portletXml) throws IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setAttribute("http://xml.org/sax/features/validation", Boolean.TRUE);
        documentBuilderFactory.setAttribute("http://apache.org/xml/features/validation/schema", Boolean.TRUE);
        documentBuilderFactory.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
        documentBuilderFactory.setAttribute("http://apache.org/xml/features/dom/include-ignorable-whitespace", Boolean.FALSE);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrorHandler());
            documentBuilder.setEntityResolver(new EntityResolver(Constants.RES_PORTLET_DTDS, Constants.RES_PORTLET_DTD_NAMES));
            Document returnDoc = documentBuilder.parse(portletXml);
            returnDoc.normalize();
            return returnDoc;
        }
        catch (ParserConfigurationException e) {
            throw new SAXException("Failed creating DocumentBuilder", e);
        }
    }

    public static Document parseWebXml(InputStream webXml) throws IOException, SAXException {
        DOMParser domParser = new DOMParser();
        domParser.setErrorHandler((org.xml.sax.ErrorHandler)new ErrorHandler());
        domParser.setEntityResolver((org.xml.sax.EntityResolver)new EntityResolver("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "/org/apache/pluto/portalImpl/xml/web-app_2_3.dtd", "web-app_2_3.dtd"));
        domParser.setFeature("http://xml.org/sax/features/validation", false);
        domParser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", false);
        InputSource source = new InputSource(webXml);
        domParser.parse(source);
        return domParser.getDocument();
    }

    public static class EntityResolver
    implements org.xml.sax.EntityResolver {
        public String publicDTD = null;
        public String[] resourceDTDs = new String[1];
        public String[] resourceDTDNames = new String[1];

        public EntityResolver(String publicDTD, String resourceDTD, String resourceDTDName) {
            this.publicDTD = publicDTD;
            this.resourceDTDs[0] = resourceDTD;
            this.resourceDTDNames[0] = resourceDTDName;
        }

        public EntityResolver(String[] resourceDTDs, String[] resourceDTDNames) {
            this.resourceDTDs = resourceDTDs;
            this.resourceDTDNames = resourceDTDNames;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            for (int i = 0; i < this.resourceDTDNames.length; ++i) {
                if ((publicId == null || !publicId.equals(this.publicDTD)) && (systemId == null || !systemId.endsWith(this.resourceDTDNames[i]))) continue;
                InputStream is = this.getClass().getResourceAsStream(this.resourceDTDs[i]);
                if (is != null) {
                    return new InputSource(is);
                }
                throw new SAXException("XML configuration DTD not found: " + this.resourceDTDs[i]);
            }
            throw new SAXException("External entites are not permitted in XML configuration files");
        }
    }

    public static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }
}

