/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portalImpl.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.pluto.util.StringUtils;

public abstract class NameValuePairs {
    private NameValuePairs iParent;
    private List iEntries = new LinkedList();

    public int size() {
        return this.iEntries.size();
    }

    public String getString(String aName) {
        return this.findString(aName);
    }

    public String getString(String aName, String aDefault) {
        String result = this.findString(aName);
        if (result == null) {
            result = aDefault;
        }
        return result;
    }

    public String[] getStrings(String aName) {
        String[] result = null;
        Entry entry = this.findEntry(aName);
        if (entry != null) {
            result = entry.iValues;
        }
        return result;
    }

    public Integer getInteger(String aName) {
        return this.getInteger(aName, null);
    }

    public Integer getInteger(String aName, Integer aDefault) {
        Integer result = aDefault;
        String value = this.findString(aName);
        if (value != null) {
            result = Integer.valueOf(value);
        }
        return result;
    }

    public int getInteger(String aName, int aDefault) {
        int result = aDefault;
        String value = this.findString(aName);
        if (value != null) {
            result = Integer.parseInt(value);
        }
        return result;
    }

    public Boolean getBoolean(String aName) {
        return this.getBoolean(aName, null);
    }

    public Boolean getBoolean(String aName, Boolean aDefault) {
        Boolean result = aDefault;
        String value = this.findString(aName);
        if (value != null) {
            result = StringUtils.booleanOf((String)value);
        }
        return result;
    }

    public boolean getBoolean(String aName, boolean aDefault) {
        return this.getBoolean(aName, aDefault ? Boolean.TRUE : Boolean.FALSE);
    }

    public Iterator names() {
        return new EntryIterator(this);
    }

    public final Iterator keys() {
        return this.names();
    }

    public void setParent(NameValuePairs aParent) {
        this.iParent = aParent;
    }

    public String toString() {
        return this.iEntries.toString();
    }

    protected NameValuePairs() {
    }

    protected void add(String aName, String aValue) {
        this.add(aName, new String[]{aValue});
    }

    protected void add(String aName, String[] aValues) {
        if (aName == null) {
            throw new IllegalArgumentException("NameValuePairs: Argument \"aName\" cannot be null.");
        }
        if (aValues == null) {
            throw new IllegalArgumentException("NameValuePairs: Argument \"aValues\" cannot be null.");
        }
        for (int i = 0; i < aValues.length; ++i) {
            if (aValues[i] != null) continue;
            throw new IllegalArgumentException("NameValuePairs: Argument \"aValues\" cannot contain null.");
        }
        Entry entry = this.findEntry(aName);
        if (entry == null) {
            entry = new Entry(aName, aValues);
            this.iEntries.add(entry);
        } else {
            String[] values = new String[entry.iValues.length + aValues.length];
            System.arraycopy(entry.iValues, 0, values, 0, entry.iValues.length);
            System.arraycopy(aValues, 0, values, entry.iValues.length, aValues.length);
            entry.iValues = values;
        }
    }

    protected Entry findEntry(String aName) {
        if (aName == null) {
            throw new IllegalArgumentException("NameValuePairs: Argument \"aName\" cannot be null!");
        }
        Entry result = null;
        Iterator iter = this.iEntries.iterator();
        while (iter.hasNext()) {
            Entry entry = (Entry)iter.next();
            if (!entry.iName.equals(aName)) continue;
            result = entry;
            break;
        }
        if (result == null && this.iParent != null) {
            result = this.iParent.findEntry(aName);
        }
        return result;
    }

    protected void removeEntry(String aName) {
        if (aName == null) {
            throw new IllegalArgumentException("NameValuePairs: Argument \"aName\" cannot be null!");
        }
        boolean found = false;
        Iterator iter = this.iEntries.iterator();
        while (iter.hasNext()) {
            Entry entry = (Entry)iter.next();
            if (!entry.iName.equals(aName)) continue;
            iter.remove();
            found = true;
            break;
        }
        if (!found && this.iParent != null) {
            this.iParent.removeEntry(aName);
        }
    }

    private String findString(String aName) {
        String result = null;
        Entry entry = this.findEntry(aName);
        if (entry != null) {
            result = entry.iValues[0];
        }
        return result;
    }

    NameValuePairs getParent() {
        return this.iParent;
    }

    List getEntries() {
        return this.iEntries;
    }

    private static class EntryIterator
    implements Iterator {
        private NameValuePairs iPairs;
        private Iterator iIterator;

        private EntryIterator(NameValuePairs aPairs) {
            this.iPairs = aPairs;
            this.iIterator = this.iPairs.getEntries().iterator();
        }

        public boolean hasNext() {
            if (!this.nextParent()) {
                return false;
            }
            return this.iIterator.hasNext();
        }

        public Object next() {
            if (!this.nextParent()) {
                return null;
            }
            return ((Entry)this.iIterator.next()).iName;
        }

        public void remove() {
            this.iIterator.remove();
        }

        private boolean nextParent() {
            while (!this.iIterator.hasNext()) {
                this.iPairs = this.iPairs.getParent();
                if (this.iPairs == null) {
                    return false;
                }
                this.iIterator = this.iPairs.getEntries().iterator();
            }
            return true;
        }
    }

    public static class Entry {
        String iName;
        String[] iValues;

        protected Entry(String aName, String[] aValues) {
            this.iName = aName;
            this.iValues = aValues;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append(this.iName);
            result.append(" = ");
            for (int i = 0; i < this.iValues.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(this.iValues[i]);
            }
            return result.toString();
        }
    }
}

