/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portalImpl.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.om.entity.PortletApplicationEntity;
import org.apache.pluto.om.entity.PortletApplicationEntityList;
import org.apache.pluto.om.entity.PortletApplicationEntityListCtrl;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.om.entity.PortletEntityListCtrl;
import org.apache.pluto.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.om.portlet.PortletApplicationDefinitionList;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.portalImpl.Servlet;
import org.apache.pluto.portalImpl.aggregation.Fragment;
import org.apache.pluto.portalImpl.aggregation.RootFragment;
import org.apache.pluto.portalImpl.om.page.impl.FragmentImpl;
import org.apache.pluto.portalImpl.om.page.impl.NavigationImpl;
import org.apache.pluto.portalImpl.om.page.impl.PropertyImpl;
import org.apache.pluto.portalImpl.services.pageregistry.PageRegistry;
import org.apache.pluto.portalImpl.services.portletdefinitionregistry.PortletDefinitionRegistry;
import org.apache.pluto.portalImpl.services.portletentityregistry.PortletEntityRegistry;

public class TCKdriver
extends Servlet {
    private int testpageNo = 1;
    private int windowNo = 100;

    public final String getServletInfo() {
        return "portalImpl - Pluto TCK Driver";
    }

    public void doGet(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        String[] portletNames = servletRequest.getParameterValues("portletName");
        if (portletNames != null) {
            String pageName = servletRequest.getParameter("pageName");
            if (pageName == null) {
                pageName = "TCK_testpage" + this.testpageNo++;
            }
            RootFragment root = PageRegistry.getRootFragment();
            ArrayList<FragmentImpl> fragments = new ArrayList<FragmentImpl>();
            PortletApplicationEntityList entityList = PortletEntityRegistry.getPortletApplicationEntityList();
            PortletApplicationDefinitionList definitionList = PortletDefinitionRegistry.getPortletApplicationDefinitionList();
            for (int i = 0; i < portletNames.length; ++i) {
                StringTokenizer tokenizer = new StringTokenizer(portletNames[i], "/");
                String appName = tokenizer.nextToken();
                String portletName = tokenizer.nextToken();
                Iterator appIt = entityList.iterator();
                PortletApplicationEntity appEntity = null;
                boolean found = false;
                while (appIt.hasNext() && !found) {
                    appEntity = (PortletApplicationEntity)appIt.next();
                    String displayName = appEntity.getPortletApplicationDefinition().getWebApplicationDefinition().getDisplayName(Locale.ENGLISH).getDisplayName();
                    if (displayName == null || !displayName.equals(appName)) continue;
                    found = true;
                }
                if (!found) {
                    Iterator iter = definitionList.iterator();
                    while (!found && iter.hasNext()) {
                        PortletApplicationDefinition portletApp = (PortletApplicationDefinition)iter.next();
                        if (!portletApp.getId().toString().equals(appName)) continue;
                        PortletApplicationEntityListCtrl appEntityListCtrl = (PortletApplicationEntityListCtrl)entityList;
                        appEntity = appEntityListCtrl.add(portletApp.getId().toString());
                        this.log("added Portlet Application " + appName + " to PortletEntityRegistry");
                        found = true;
                    }
                }
                if (!found) {
                    this.log("Portlet Application " + appName + " not found!");
                    throw new ServletException("Portlet Application " + appName + " not found!");
                }
                Iterator portletIt = appEntity.getPortletEntityList().iterator();
                PortletEntity portlet = null;
                found = false;
                while (portletIt.hasNext() && !found) {
                    portlet = (PortletEntity)portletIt.next();
                    PortletDefinition tmpPortletDef = portlet.getPortletDefinition();
                    if (tmpPortletDef == null) {
                        this.log("ERROR: Portlet definition of portlet enity (id=" + portlet.getId() + ") not found!");
                        this.log("       Portlet may not be defined in portlet.xml!");
                        throw new ServletException("Portlet definition of portlet enity (id=" + portlet.getId() + ") not found!");
                    }
                    String tmpPortletName = tmpPortletDef.getName();
                    if (tmpPortletName == null || !tmpPortletName.equals(portletName)) continue;
                    Iterator iter = portlet.getPreferenceSet().iterator();
                    while (iter.hasNext()) {
                        iter.next();
                        iter.remove();
                    }
                    found = true;
                }
                if (!found) {
                    Iterator appIter = definitionList.iterator();
                    while (!found && appIter.hasNext()) {
                        PortletApplicationDefinition appDef = (PortletApplicationDefinition)appIter.next();
                        if (!appDef.getId().toString().equals(appName)) continue;
                        Iterator portletIter = appDef.getPortletDefinitionList().iterator();
                        while (!found && portletIter.hasNext()) {
                            PortletDefinition portletDef = (PortletDefinition)portletIter.next();
                            if (!portletDef.getId().toString().equals(appName + "." + portletName)) continue;
                            PortletEntityListCtrl entityListCtrl = (PortletEntityListCtrl)appEntity.getPortletEntityList();
                            portlet = entityListCtrl.add(appEntity, portletDef.getId().toString());
                            PortletEntityRegistry.refresh(portlet);
                            this.log("added Portlet " + portletName + " to PortletEntityRegistry");
                            found = true;
                        }
                    }
                }
                if (!found) {
                    this.log("ERROR: Portlet " + portletName + " not found!");
                    throw new ServletException("Portlet " + portletName + " not found!");
                }
                FragmentImpl tckPortlet = new FragmentImpl();
                tckPortlet.setType("portlet");
                tckPortlet.setName("p" + this.windowNo++);
                PropertyImpl property = new PropertyImpl();
                property.setName("portlet");
                property.setValue(portlet.getId().toString());
                tckPortlet.getProperties().add(property);
                fragments.add(tckPortlet);
            }
            FragmentImpl tckCol = new FragmentImpl();
            tckCol.setType("column");
            tckCol.setName("col");
            tckCol.setFragments(fragments);
            ArrayList<FragmentImpl> colFragments = new ArrayList<FragmentImpl>();
            colFragments.add(tckCol);
            FragmentImpl tckRow = new FragmentImpl();
            tckRow.setType("row");
            tckRow.setName("row");
            tckRow.setFragments(colFragments);
            ArrayList<FragmentImpl> rowFragments = new ArrayList<FragmentImpl>();
            rowFragments.add(tckRow);
            FragmentImpl tckPage = new FragmentImpl();
            tckPage.setType("page");
            tckPage.setName(pageName);
            NavigationImpl tckNav = new NavigationImpl();
            tckNav.setTitle(pageName);
            tckNav.setDescription("dynamically generated TCK test page");
            tckPage.setNavigation(tckNav);
            tckPage.setFragments(rowFragments);
            try {
                Fragment rootFragment = tckPage.build(this.getServletConfig(), root);
                root.addChild(rootFragment);
            }
            catch (Exception e) {
                this.log("Exception in building new TCK page occured! " + e.getMessage());
                throw new ServletException("Exception in building new TCK page occured!", (Throwable)e);
            }
            StringBuffer path = servletRequest.getRequestURL();
            path.append("/");
            path.append(pageName);
            servletResponse.sendRedirect(path.toString());
            return;
        }
        super.doGet(servletRequest, servletResponse);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }
}

