/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portalImpl.services.portletentityregistry;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.entity.PortletApplicationEntity;
import org.apache.pluto.om.entity.PortletApplicationEntityList;
import org.apache.pluto.om.entity.PortletEntity;
import org.apache.pluto.portalImpl.om.entity.impl.PortletApplicationEntityListImpl;
import org.apache.pluto.portalImpl.services.log.Log;
import org.apache.pluto.portalImpl.services.portletentityregistry.PortletEntityRegistry;
import org.apache.pluto.portalImpl.services.portletentityregistry.PortletEntityRegistryService;
import org.apache.pluto.portalImpl.util.Properties;
import org.apache.pluto.services.log.Logger;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

public class PortletEntityRegistryServiceFileImpl
extends PortletEntityRegistryService {
    public static final String CONFIG_FILE = "WEB-INF/data/portletentityregistry.xml";
    public static final String DEFAULT_MAPPING = "WEB-INF/data/xml/portletentitymapping.xml";
    protected static final String CONFIG_MAPPING = "mapping.configfile";
    protected Mapping mapping = null;
    protected ServletContext servletContext = null;
    private Logger log = null;
    protected PortletApplicationEntityListImpl registry = null;
    protected Map portletEntitiesKeyObjectID = new HashMap();

    public void init(ServletConfig servletConfig, Properties properties) throws Exception {
        this.servletContext = servletConfig.getServletContext();
        this.log = Log.getService().getLogger(this.getClass());
        String _mapping = properties.getString(CONFIG_MAPPING, DEFAULT_MAPPING);
        File f = new File(_mapping);
        if (!f.isAbsolute()) {
            _mapping = this.servletContext.getRealPath(_mapping);
        }
        this.mapping = new Mapping();
        try {
            this.mapping.loadMapping(_mapping);
        }
        catch (Exception e) {
            this.log.error("Failed to load mapping file " + _mapping, (Throwable)e);
            throw e;
        }
        this.load();
    }

    public PortletApplicationEntityList getPortletApplicationEntityList() {
        return this.registry;
    }

    public PortletEntity getPortletEntity(ObjectID id) {
        return (PortletEntity)this.portletEntitiesKeyObjectID.get(id.toString());
    }

    public void store() throws IOException {
        String filename = CONFIG_FILE;
        File f = new File(filename);
        if (!f.isAbsolute()) {
            filename = this.servletContext.getRealPath(filename);
        }
        FileWriter writer = new FileWriter(filename);
        try {
            Marshaller marshaller = new Marshaller((Writer)writer);
            marshaller.setMapping(this.mapping);
            this.registry.preStore(null);
            marshaller.marshal((Object)this.registry);
            this.registry.postStore(null);
        }
        catch (MappingException e) {
            e.printStackTrace(System.err);
            throw new IOException(e.toString());
        }
        catch (ValidationException e) {
            e.printStackTrace(System.err);
            throw new IOException(e.toString());
        }
        catch (MarshalException e) {
            e.printStackTrace(System.err);
            throw new IOException(e.toString());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new IOException(e.toString());
        }
    }

    public void load() throws IOException {
        this._load();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Dumping complete object model description as it is read from the xml file...");
            this.log.debug(this.registry.toString());
        }
        this.fill();
    }

    public void refresh(PortletEntity portletEntity) {
        this.portletEntitiesKeyObjectID.put(portletEntity.getId().toString(), portletEntity);
    }

    private void _load() throws IOException {
        String filename = CONFIG_FILE;
        File f = new File(filename);
        if (!f.isAbsolute()) {
            filename = this.servletContext.getRealPath(filename);
        }
        try {
            Unmarshaller unmarshaller = new Unmarshaller(this.mapping);
            this.registry = (PortletApplicationEntityListImpl)unmarshaller.unmarshal((Reader)new FileReader(filename));
            this.registry.postLoad(null);
            this.registry.preBuild(null);
            this.registry.postBuild(null);
        }
        catch (MappingException e) {
            e.printStackTrace(System.err);
            throw new IOException(e.toString());
        }
        catch (ValidationException e) {
            e.printStackTrace(System.err);
            throw new IOException(e.toString());
        }
        catch (MarshalException e) {
            e.printStackTrace(System.err);
            throw new IOException(e.toString());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new IOException(e.toString());
        }
    }

    private void fill() {
        Iterator iterator = this.registry.iterator();
        while (iterator.hasNext()) {
            PortletApplicationEntity appInst = (PortletApplicationEntity)iterator.next();
            Iterator portlets = appInst.getPortletEntityList().iterator();
            while (portlets.hasNext()) {
                PortletEntity portletInst = (PortletEntity)portlets.next();
                this.portletEntitiesKeyObjectID.put(portletInst.getId().toString(), portletInst);
            }
        }
    }

    public Map getPortletEntities() {
        return this.portletEntitiesKeyObjectID;
    }

    public void postInit() throws Exception {
        PortletEntityRegistry.setPortletEntityRegistryService();
    }
}

