/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.portalImpl.services.portletdefinitionregistry;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.pluto.om.common.ObjectID;
import org.apache.pluto.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.om.portlet.PortletApplicationDefinitionList;
import org.apache.pluto.om.portlet.PortletDefinition;
import org.apache.pluto.portalImpl.om.portlet.impl.PortletApplicationDefinitionImpl;
import org.apache.pluto.portalImpl.om.portlet.impl.PortletApplicationDefinitionListImpl;
import org.apache.pluto.portalImpl.om.servlet.impl.WebApplicationDefinitionImpl;
import org.apache.pluto.portalImpl.services.log.Log;
import org.apache.pluto.portalImpl.services.portletdefinitionregistry.PortletDefinitionRegistry;
import org.apache.pluto.portalImpl.services.portletdefinitionregistry.PortletDefinitionRegistryService;
import org.apache.pluto.portalImpl.util.Properties;
import org.apache.pluto.portalImpl.xml.XmlParser;
import org.apache.pluto.services.log.Logger;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Unmarshaller;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class PortletDefinitionRegistryServiceFileImpl
extends PortletDefinitionRegistryService {
    private static String fileSeparator = System.getProperty("file.separator");
    private static final String INITIAL_TMP_PREFIX = "tmp";
    private static final int FULL_TMP_PREFIX_LEN = "tmp".length() + 5;
    private static final String WAR_FILE_EXT = ".war";
    public static final String DEFAULT_MAPPING_PORTLETXML = "WEB-INF/data/xml/portletdefinitionmapping.xml";
    public static final String DEFAULT_MAPPING_WEBXML = "WEB-INF/data/xml/servletdefinitionmapping.xml";
    private static final String CONFIG_MAPPING_PORTLETXML = "mapping.portletxml.configfile";
    private static final String CONFIG_MAPPING_WEBXML = "mapping.webxml.configfile";
    private Mapping mappingPortletXml = null;
    private Mapping mappingWebXml = null;
    private ServletContext servletContext = null;
    private String baseWMDir = null;
    private Logger log = null;
    protected PortletApplicationDefinitionListImpl registry = new PortletApplicationDefinitionListImpl();
    protected Map portletsKeyObjectId = new HashMap();

    public void init(ServletConfig config, Properties properties) throws Exception {
        this.log = Log.getService().getLogger(this.getClass());
        System.out.println("Initializing portlet registry....:" + config);
        this.servletContext = config.getServletContext();
        if (properties.getBoolean("non-servlet") == Boolean.TRUE) {
            String root = config.getServletContext().getRealPath("/");
            this.baseWMDir = String.valueOf(root) + fileSeparator + "WEB-INF" + fileSeparator + "portletapps" + fileSeparator;
            if (this.log.isDebugEnabled()) {
                this.log.debug("baseWMDir = " + this.baseWMDir + " fileSeparator = " + fileSeparator);
            }
        } else {
            this.baseWMDir = this.servletContext.getRealPath("");
            if (this.baseWMDir.endsWith(fileSeparator)) {
                this.baseWMDir = this.baseWMDir.substring(0, this.baseWMDir.length() - 1);
            }
            this.baseWMDir = String.valueOf(this.baseWMDir.substring(0, this.baseWMDir.lastIndexOf(fileSeparator))) + fileSeparator;
            System.out.println("servletContext.getRealPath('') =" + this.servletContext.getRealPath(""));
            System.out.println("baseWMDir = " + this.baseWMDir);
            if (this.log.isDebugEnabled()) {
                this.log.debug("servletContext.getRealPath('') =" + this.servletContext.getRealPath(""));
                this.log.debug("baseWMDir = " + this.baseWMDir);
            }
        }
        String _mapping = properties.getString(CONFIG_MAPPING_PORTLETXML, DEFAULT_MAPPING_PORTLETXML);
        System.out.println("_mapping = " + _mapping);
        File f = new File(_mapping);
        if (!f.isAbsolute()) {
            _mapping = this.servletContext.getRealPath(_mapping);
        }
        this.mappingPortletXml = new Mapping();
        try {
            this.mappingPortletXml.loadMapping(_mapping);
        }
        catch (Exception e) {
            this.log.error("Failed to load mapping file " + _mapping, (Throwable)e);
            throw e;
        }
        _mapping = properties.getString(CONFIG_MAPPING_WEBXML, DEFAULT_MAPPING_WEBXML);
        f = new File(_mapping);
        if (!f.isAbsolute()) {
            _mapping = this.servletContext.getRealPath(_mapping);
        }
        this.mappingWebXml = new Mapping();
        try {
            this.mappingWebXml.loadMapping(_mapping);
        }
        catch (Exception e) {
            this.log.error("Failed to load mapping file " + _mapping, (Throwable)e);
            throw e;
        }
        this.load();
        this.fill();
    }

    public PortletApplicationDefinitionList getPortletApplicationDefinitionList() {
        return this.registry;
    }

    public PortletDefinition getPortletDefinition(ObjectID id) {
        return (PortletDefinition)this.portletsKeyObjectId.get(id);
    }

    private void load() throws Exception {
        System.out.println("baseWMDir in load(): " + this.baseWMDir);
        File f = new File(this.baseWMDir);
        String[] entries = f.list();
        int i = 0;
        while (i < entries.length) {
            File entry = new File(String.valueOf(this.baseWMDir) + entries[i]);
            System.out.println("entry: " + entry);
            if (entry.isDirectory()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Searching in directory: " + entries[i]);
                }
                this.load(this.baseWMDir, entries[i]);
            }
            ++i;
        }
    }

    private String resolveURI(String webModule) {
        int len = webModule.length();
        if (webModule.endsWith(WAR_FILE_EXT) && webModule.startsWith(INITIAL_TMP_PREFIX) && len > FULL_TMP_PREFIX_LEN + WAR_FILE_EXT.length()) {
            webModule = webModule.substring(FULL_TMP_PREFIX_LEN, len - WAR_FILE_EXT.length());
        }
        return webModule;
    }

    private void load(String baseDir, String webModule) throws Exception {
        String directory = String.valueOf(baseDir) + webModule + fileSeparator + "WEB-INF" + fileSeparator;
        File portletXml = new File(String.valueOf(directory) + "portlet.xml");
        File webXml = new File(String.valueOf(directory) + "web.xml");
        System.out.println("portletXml: " + portletXml);
        System.out.println("portletXml: " + webXml);
        if (portletXml.exists()) {
            System.out.println("Loading the following Portlet Applications XML files..." + portletXml + ", " + webXml);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Loading the following Portlet Applications XML files..." + portletXml + ", " + webXml);
            }
            InputSource source = new InputSource(new FileInputStream(portletXml));
            source.setSystemId(portletXml.toURL().toExternalForm());
            Unmarshaller unmarshaller = new Unmarshaller(this.mappingPortletXml);
            unmarshaller.setIgnoreExtraElements(true);
            PortletApplicationDefinitionImpl portletApp = (PortletApplicationDefinitionImpl)unmarshaller.unmarshal(source);
            WebApplicationDefinitionImpl webApp = null;
            if (webXml.exists()) {
                Document webDocument = XmlParser.parseWebXml(new FileInputStream(webXml));
                unmarshaller = new Unmarshaller(this.mappingWebXml);
                unmarshaller.setIgnoreExtraElements(true);
                webApp = (WebApplicationDefinitionImpl)unmarshaller.unmarshal((Node)webDocument);
                Vector<Object> structure = new Vector<Object>();
                structure.add(portletApp);
                structure.add("/" + this.resolveURI(webModule));
                webApp.postLoad(structure);
                webApp.preBuild(structure);
                webApp.postBuild(structure);
                if (this.log.isDebugEnabled()) {
                    this.log.debug(webApp.toString());
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("no web.xml...");
                }
                Vector<String> structure = new Vector<String>();
                structure.add("/" + this.resolveURI(webModule));
                structure.add(null);
                structure.add(null);
                portletApp.postLoad(structure);
                portletApp.preBuild(structure);
                portletApp.postBuild(structure);
            }
            this.registry.add(portletApp);
            System.out.println("Dumping content of web.xml...");
            System.out.println(webApp.toString());
            System.out.println("Dumping content of portlet.xml...");
            System.out.println(portletApp.toString());
            if (this.log.isDebugEnabled()) {
                if (webApp != null) {
                    this.log.debug("Dumping content of web.xml...");
                    this.log.debug(webApp.toString());
                }
                this.log.debug("Dumping content of portlet.xml...");
                this.log.debug(portletApp.toString());
            }
        } else {
            this.log.debug("Could not find " + portletXml);
            System.out.println("Could not find " + portletXml);
        }
    }

    private void fill() {
        Iterator iterator = this.registry.iterator();
        while (iterator.hasNext()) {
            PortletApplicationDefinition papp = (PortletApplicationDefinition)iterator.next();
            System.out.println("papp: " + papp.toString());
            Iterator portlets = papp.getPortletDefinitionList().iterator();
            while (portlets.hasNext()) {
                PortletDefinition portlet = (PortletDefinition)portlets.next();
                System.out.println("portlet: " + portlet.toString());
                this.portletsKeyObjectId.put(portlet.getId(), portlet);
            }
        }
    }

    public void postInit() throws Exception {
        PortletDefinitionRegistry.setPortletDefinitionRegistryService();
    }
}

